package com.cku.oa.ipaddress.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.ipaddress.entity.IpBlackList;
import com.cku.oa.ipaddress.dao.IpBlackListDao;

/**
 * ip_black_list映射表Service
 * @author ip_black_list映射表
 * @version 2019-10-18
 */
@Service
@Transactional(readOnly = true)
public class IpBlackListService extends CrudService<IpBlackListDao, IpBlackList> {

	@Autowired
	private IpBlackListDao ipBlackListDao;
	
	public IpBlackList get(String id) {
		return super.get(id);
	}
	
	public List<IpBlackList> findList(IpBlackList ipBlackList) {
		return super.findList(ipBlackList);
	}
	
	public Page<IpBlackList> findPage(Page<IpBlackList> page, IpBlackList ipBlackList) {
		return super.findPage(page, ipBlackList);
	}
	
	@Transactional(readOnly = false)
	public void save(IpBlackList ipBlackList) {
		super.save(ipBlackList);
	}
	
	@Transactional(readOnly = false)
	public void delete(IpBlackList ipBlackList) {
		super.delete(ipBlackList);
	}
	
	@Transactional(readOnly = false)
	public void insert(IpBlackList ipBlackList) {
		List<IpBlackList> result = ipBlackListDao.findList(ipBlackList);
		if(CollectionUtils.isEmpty(result)) {
			ipBlackListDao.insert(ipBlackList);
		}else {
			
			ipBlackListDao.update(ipBlackList);
		}
		
	}
	
	@Transactional(readOnly = false)
	public void updateIpStatus(IpBlackList ipBlackList) {
		ipBlackListDao.update(ipBlackList);
	}
}