/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.web;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 审查员表Controller
 * @author lgl
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "${adminPath}/handeler/handlerShowReferee")
public class HandlerShowRefereeController extends BaseController {

	@Autowired
	private GroomerShowRefereeService groomerShowRefereeService;

	@ModelAttribute
	public GroomerShowReferee get(@RequestParam(required=false) String id) {
		GroomerShowReferee entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerShowRefereeService.get(id);
		}
		if (entity == null){
			entity = new GroomerShowReferee();
		}
		return entity;
	}

	@RequiresPermissions("handeler:handlerShowReferee:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerShowReferee groomerShowReferee, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerShowReferee.setType("1");
		groomerShowReferee.setDelFlag("0");
		Page<GroomerShowReferee> page = groomerShowRefereeService.findPage(new Page<GroomerShowReferee>(request, response), groomerShowReferee);
		model.addAttribute("page", page);
		return "oa/handler/handlerRefereeList";
	}

	@RequiresPermissions("handeler:handlerShowReferee:view")
	@RequestMapping(value = "form")
	public String form(GroomerShowReferee groomerShowReferee, Model model) {
		model.addAttribute("groomerShowReferee", groomerShowReferee);
		return "oa/handler/handlerRefereeForm";
	}

	@RequiresPermissions("handeler:handlerShowReferee:edit")
	@RequestMapping(value = "save")
	public String save(GroomerShowReferee groomerShowReferee, Model model, RedirectAttributes redirectAttributes) {
		groomerShowRefereeService.saveHandlerShowReferee(groomerShowReferee);
		addMessage(redirectAttributes, "保存审查员成功");
		return "redirect:"+Global.getAdminPath()+"/handeler/handlerShowReferee/?repage";
	}

	@RequiresPermissions("handeler:handlerShowReferee:delete")
	@RequestMapping(value = "delete")
	public String delete(GroomerShowReferee groomerShowReferee, RedirectAttributes redirectAttributes) {
		groomerShowRefereeService.delete(groomerShowReferee);
		addMessage(redirectAttributes, "删除审查员成功");
		return "redirect:"+Global.getAdminPath()+"/handeler/handlerShowReferee/?repage";
	}
	@RequiresPermissions("handeler:handlerShowReferee:view")
	@RequestMapping(value = "view")
	public String view(GroomerShowReferee groomerShowReferee, RedirectAttributes redirectAttributes,Model model) {
		GroomerShowReferee showReferee = groomerShowRefereeService.get(groomerShowReferee.getId());
		model.addAttribute("groomerShowReferee", showReferee);
		return "oa/handler/handlerRefereeView";
	}

}