package com.cku.oa.groomer.web;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.RotationChart;
import com.cku.oa.groomer.service.RotationChartService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**
 * 轮播图
 *user zhangxiang
 *2020年9月9日
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/rotationChart")
public class RotationChartController extends BaseController {

	@Autowired
	private RotationChartService rotationChartService;


	@RequestMapping(value = {"list", ""})
	public String list(Model model){
		List<RotationChart> list = rotationChartService.findList(new RotationChart());
		list.stream().forEach(e->{
			if(e.getCreateBy()!=null){
				User user = UserUtils.get(e.getCreateBy().getId());
				e.setCreateBy(user);
			}
		});


		model.addAttribute("list",list);
		return "oa/groomer/rotationChartList";
	}
	@RequiresPermissions("groomer:rotationChart:save")
	@RequestMapping(value = {"fromAdd", ""})
	public String fromSave(RotationChart rotationChart,Model model){
		model.addAttribute("rotationChart",rotationChart);

		return "oa/groomer/rotationChartAdd";
	}

	@RequiresPermissions("groomer:rotationChart:save")
	@RequestMapping(value = {"save", ""})
	public String save(RotationChart rotationChart,Model model){
		//查重
		rotationChartService.ISrepeat(rotationChart);
		if(StringUtils.isNotBlank(rotationChart.getRotationCurriculum())){
			//判断跳转课程
			List<GroomerCourse> groomerCourse = rotationChartService.getGroomerCourse(rotationChart);
			if(groomerCourse.size()<1){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的课程编号不匹配，请重新输入");
			}
			//判断是否审核通过
			if(!"3".equals(groomerCourse.get(0).getStates())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的课程编号未审核通过");
			}
			rotationChart.setRotationType(groomerCourse.get(0).getType());
		}else{
			rotationChart.setRotationType("");
		}
		//保存
		rotationChartService.save(rotationChart);
		return "redirect:"+ Global.getAdminPath()+"/groomer/rotationChart/list?repage";
	}

	@RequiresPermissions("groomer:rotationChart:edit")
	@RequestMapping(value = {"form", ""})
	public String form(RotationChart rotationChart,Model model){
		RotationChart rotationChart1 = rotationChartService.get(rotationChart.getId());
		model.addAttribute("rotationChart",rotationChart1);
		//搜索课程列表


		return "oa/groomer/rotationChartAdd";
	}

	@RequiresPermissions("groomer:rotationChart:edit")
	@RequestMapping(value = {"edit", ""})
	public String edit(RotationChart rotationChart,Model model){
		//查重
		rotationChartService.ISrepeat(rotationChart);
		rotationChartService.save(rotationChart);
		return "redirect:"+ Global.getAdminPath()+"/groomer/rotationChart/list?repage";
	}
	@RequiresPermissions("groomer:rotationChart:del")
	@RequestMapping(value = {"del", ""})
	public String del(RotationChart rotationChart,Model model){
		rotationChartService.delete(rotationChart);
		return "redirect:"+ Global.getAdminPath()+"/groomer/rotationChart/list?repage";
	}

	@ResponseBody
	@RequestMapping(value = {"iSrepeat", ""})
	public Object iSrepeat(RotationChart rotationChart, HttpServletRequest request, HttpServletResponse response)throws IOException {
		//查重
		HashMap<String,String> map = new HashMap<String,String>();
		try {
			rotationChartService.ISrepeat(rotationChart);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	//获取课程
	@ResponseBody
	@RequestMapping(value = {"getRotationChart", ""})
	public Object getGroomerCourse(RotationChart rotationChart, HttpServletRequest request, HttpServletResponse response)throws IOException {
		//查重
		HashMap<String,String> map = new HashMap<String,String>();
		try {
			List<GroomerCourse> groomerCourse = rotationChartService.getGroomerCourse(rotationChart);
			if(groomerCourse.size()>0){
				map.put("rc", "0");
				map.put("msg","查询到正确的跳转课程");
			}else{
				map.put("rc", "1");
				map.put("msg", "输入的课程编号不匹配，请重新输入");
			}
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
}
