package com.cku.oa.groomer.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.text.StrBuilder;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerExcelEntity;
import com.cku.oa.groomer.entity.InternationalGroomerCertificate;
import com.cku.oa.groomer.service.InternationalGroomerCertificateService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.sys.web.AlipayController;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.Encodes;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 国际美容师管理Controller
 *
 * @author wangjie
 * @version 2019-07-29
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/internationalGroomerCertificate")
public class InternationalGroomerCertificateController extends BaseController {

	private Logger logger = LoggerFactory.getLogger(AlipayController.class);
	@Autowired
	private InternationalGroomerCertificateService internationalGroomerCertificateService;
	@Autowired
	private FileService fileService;
	@Autowired
	private MemberService memberService;

	@ModelAttribute
	public InternationalGroomerCertificate get(@RequestParam(required = false) String id) {
		InternationalGroomerCertificate entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = internationalGroomerCertificateService.get(id);
		}
		if (entity == null) {
			entity = new InternationalGroomerCertificate();
		}
		return entity;
	}

	@RequiresPermissions("groomer:internationalGroomerCertificate:view")
	@RequestMapping(value = { "list", "" })
	public String list(InternationalGroomerCertificate internationalGroomerCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<InternationalGroomerCertificate> page = internationalGroomerCertificateService.findPage(
				new Page<InternationalGroomerCertificate>(request, response), internationalGroomerCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/internationalGroomerCertificateList";
	}

	@RequiresPermissions("groomer:internationalGroomerCertificate:view")
	@RequestMapping(value = "form")
	public String form(InternationalGroomerCertificate internationalGroomerCertificate, Model model) {
		model.addAttribute("internationalGroomerCertificate", internationalGroomerCertificate);
		return "oa/groomer/internationalGroomerCertificateForm";
	}

	@RequiresPermissions("groomer:internationalGroomerCertificate:edit")
	@RequestMapping(value = "save")
	public String save(InternationalGroomerCertificate internationalGroomerCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, internationalGroomerCertificate)) {
			return form(internationalGroomerCertificate, model);
		}
		internationalGroomerCertificateService.save(internationalGroomerCertificate);
		addMessage(redirectAttributes, "保存国际美容师成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/internationalGroomerCertificate/?repage";
	}

	@RequiresPermissions("groomer:internationalGroomerCertificate:edit")
	@RequestMapping(value = "delete")
	public String delete(InternationalGroomerCertificate internationalGroomerCertificate,
			RedirectAttributes redirectAttributes) {
		internationalGroomerCertificateService.delete(internationalGroomerCertificate);
		addMessage(redirectAttributes, "删除国际美容师成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/internationalGroomerCertificate/?repage";
	}

	/**
	 * 打印证书
	 *
	 * @param internationalGroomerCertificate
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("groomer:internationalGroomerCertificate:print")
	@RequestMapping(value = "print")
	public String print(InternationalGroomerCertificate internationalGroomerCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		try {
			return internationalGroomerCertificateService.print(internationalGroomerCertificate.getId(), model);
		} catch (ZAException e) {
			logger.warn("打印出错", e);
			addMessage(redirectAttributes, "打印出错:" + e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/groomer/internationalGroomerCertificate/?repage";

		}

	}

	/**
	 * 根据图片id 查看图片
	 *
	 * @Author
	 * @2017年3月17日下午3:16:06
	 */
	@RequestMapping(value = "/image/{id}")
	@ResponseBody
	public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
		response.setContentType("image/jpeg");
		fileService.fileDownload(id,response.getOutputStream());
	}

	/**
	 * 打印重置
	 *
	 * @param internationalGroomerCertificate
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("groomer:internationalGroomerCertificate:print")
	@RequestMapping(value = "restPrint")
	public String restPrint(InternationalGroomerCertificate internationalGroomerCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		try {
			internationalGroomerCertificateService.restPrint(internationalGroomerCertificate.getId(), model);
		} catch (ZAException e) {
			logger.warn("打印出错", e);
			addMessage(redirectAttributes, "打印重置出错:" + e.getMessage());

		}
		return "redirect:" + Global.getAdminPath() + "/groomer/internationalGroomerCertificate/?repage";
	}

	@RequestMapping(value = "uploadXls", method = RequestMethod.POST)
	public String uploadXls(MultipartFile file, HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes) throws Exception {
		try {
			uploadXls(file);
			addMessage(redirectAttributes, "导入证书信息成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes,
					"导入证书信息失败！失败信息：" + (StringUtils.isNotBlank(e.getMessage()) ? e.getMessage() : "请检查上传文件是否正确！"));

		}
		return "redirect:" + Global.getAdminPath() + "/groomer/internationalGroomerCertificate";
	}

	/**
	 * 把不符合要求的数据写入xls
	 */
	private void putXls(List<InternationalGroomerCertificate> lstCm, int cloumnCount) throws IOException {
		String path = System.getProperty("java.io.tmpdir") + "/errorDateMeiRong.xls";
		OutputStream out = null;
		try {
			// 获取总列数
			int columnNumCount = cloumnCount;
			// 读取Excel文档
			File finalXlsxFile = new File(path);
			Workbook workBook = getWorkbok(finalXlsxFile);
			// sheet 对应一个工作页
			Sheet sheet = workBook.getSheetAt(0);
			/**
			 * 删除原有数据，除了属性列
			 */
			int rowNumber = sheet.getLastRowNum(); // 第一行从0开始算
			System.out.println("原始数据总行数，除属性列：" + rowNumber);
			for (int i = 1; i <= rowNumber; i++) {
				Row row = sheet.getRow(i);
				sheet.removeRow(row);
			}
			// 创建文件输出流，输出电子表格：这个必须有，否则你在sheet上做的任何操作都不会有效
			out = new FileOutputStream(path);
			workBook.write(out);
			/**
			 * 往Excel中写新数据
			 */
			for (int j = 0; j < lstCm.size(); j++) {
				// 创建一行：从第二行开始，跳过属性列
				Row row = sheet.createRow(j + 1);
				// 得到要插入的每一条记录
				InternationalGroomerCertificate cm = lstCm.get(j);
				for (int k = 0; k <= columnNumCount; k++) {
					// 在一行内循环
					Cell first = row.createCell(0);
					first.setCellValue(cm.getCertificateType().equals("ISPG") ? "国际高级宠物美容师资格证书" : "国际宠物美容师资格证书");

					Cell second = row.createCell(1);
					second.setCellValue(cm.getMemberCode());

					Cell cnname = row.createCell(2);
					cnname.setCellValue(cm.getCnName());

					Cell paymentState = row.createCell(3);
					paymentState.setCellValue(cm.getPaymentState().equals("2") ? "已缴费" : "未交费");

					Cell paymentWay = row.createCell(4);
					paymentWay.setCellValue(cm.getPaymentWay().equals("25") ? "账户余额" : "");// 支付方式

					Cell totalPrice = row.createCell(5);
					totalPrice.setCellValue(cm.getTotalPrice());// 订单金额

					Cell taymentTime = row.createCell(6);
					taymentTime.setCellValue(formatYmdDate(cm.getPaymentTime()));

					Cell reviewerState = row.createCell(7);
					reviewerState.setCellValue(cm.getReviewState().equals("1") ? "已通过" : "未通过");

					Cell reviewer = row.createCell(8);
					reviewer.setCellValue(cm.getReviewer());

					Cell reviewTime = row.createCell(9);
					reviewTime.setCellValue(formatYmdDate(cm.getReviewTime()));

					Cell issueDate = row.createCell(10);
					issueDate.setCellValue(formatYmdhmsDate(cm.getIssueDate()));

					Cell applyTime = row.createCell(11);
					applyTime.setCellValue(formatYmdDate(cm.getApplyTime()));// 申请时间
				}
			}
			// 创建文件输出流，准备输出电子表格：这个必须有，否则你在sheet上做的任何操作都不会有效
			out = new FileOutputStream(path);
			workBook.write(out);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.flush();
					out.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		System.out.println("数据导出成功");
	}

	/**
	 * 判断文件是否存在.
	 *
	 * @param fileDir
	 *            文件路径
	 * @return
	 */
	public boolean fileExist(String fileDir) {
		boolean flag = false;
		File file = new File(fileDir);
		flag = file.exists();
		return flag;
	}

	/**
	 * 判断Excel的版本,获取Workbook
	 *
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public static Workbook getWorkbok(File file) throws IOException {
		Workbook wb = null;
		FileInputStream in = new FileInputStream(file);
		if (file.getName().endsWith("xls")) { // Excel&nbsp;2003
			wb = new HSSFWorkbook(in);
		} else if (file.getName().endsWith("xlsx")) { // Excel 2007/2010
			wb = new XSSFWorkbook(in);
		}
		return wb;
	}

	/**
	 * 通过会员号查询该会员美容师正式会员截止日期超过申请日期及该会员名下有美容师资格证书编号，满足以上两个条件的信息为有效信息
	 *
	 * @param memberCode
	 * @param sdate
	 * @return
	 */
	private boolean dataVerification(String memberCode, Date sdate) {
		// SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		// Date date = null;
		// try {
		// date = sDateFormat.parse(sdate);
		// System.out.println(date);
		// } catch (ParseException px) {
		// px.printStackTrace();
		// }
		String sql = String.format(
				"SELECT a.member_code AS 'memberCode',a.member_end_date AS 'memberEndDate',b.certificate_code AS 'certificateCode' "
						+ "FROM sys_member a JOIN groomer_qualification_certificate AS b ON a.member_code = b.member_code "
						+ "WHERE a.del_flag = '0' AND b.del_flag = '0' AND "
						+ "a.member_code = '%s' AND b.certificate_code IS NOT NULL AND "
						+ "a.groomer_end_date>='%tF%n'  AND a.groomer_type='formal'  LIMIT 1;",
				memberCode, sdate);
		Map endtime = internationalGroomerCertificateService.customSelectMemberEndDate(sql);
		return endtime == null ? false : true;
	}

	private boolean memberVerification(String memberCode, String certificateType, String memberName) {

		Integer memberCertificateCount = internationalGroomerCertificateService.countMemberCertificate(memberCode,
				certificateType);
		if (memberCertificateCount != null && memberCertificateCount > 0) {
			return Boolean.FALSE;
		}

		Member member = memberService.getByMemberCode(memberCode);
		if (member == null || member.getName() == null || !member.getName().equals(memberName)) {
			return Boolean.FALSE;
		}

		return Boolean.TRUE;
	}

	/**
	 * @param response
	 * @param redirectAttributes
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "downloadImportXls")
	public void downloadImportXls(HttpServletRequest request, HttpServletResponse response) throws Exception {
		InputStream inStream = null;
		try {
			String fileDir = getClass().getResource("/").getFile().toString() + "templates/groomer_import_template.xls";
			inStream = new FileInputStream(fileDir);// 文件的存放路径
			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition", "attachment; filename=" + Encodes.urlEncode("宠物美容师证书导入模板.xls"));
			byte[] b = new byte[1024];
			int len;
			while ((len = inStream.read(b)) > 0) {
				response.getOutputStream().write(b, 0, len);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inStream != null) {
				inStream.close();
			}
		}
	}

	@RequestMapping(value = "downloadViolationXls", method = RequestMethod.GET)
	public void downloadViolationXls(HttpServletRequest request, HttpServletResponse response) throws Exception {
		InputStream inStream = null;
		try {
			inStream = new FileInputStream(System.getProperty("java.io.tmpdir") + "/errorDateMeiRong.xls");// 文件的存放路径
			response.setContentType("application/octet-stream; charset=utf-8");
			response.setHeader("Content-Disposition", "attachment; filename=" + Encodes.urlEncode("不合规宠物美容师证书.xls"));
			int len;
			byte[] b = new byte[1024];
			while ((len = inStream.read(b)) > 0) {
				response.getOutputStream().write(b, 0, len);
			}

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inStream != null) {
				inStream.close();
			}
		}
	}

	private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
	private SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	private String formatYmdDate(Date date) {
		String result = "";
		try {
			if (date == null) {
				result = "日期为空";
			}
			result = sDateFormat.format(date);
		} catch (Exception e) {
			logger.info(e.getMessage());
			result = "日期格式不正确";
		}
		return result;
	}

	private String formatYmdhmsDate(Date date) {
		String result = "";
		try {
			if (date == null) {
				result = "日期为空";
			} else {
				result = simpleDateFormat.format(date);
			}
		} catch (Exception e) {
			logger.info(e.getMessage());
			result = "日期格式不正确";
		}
		return result;
	}

	private void uploadXls(MultipartFile file) throws Exception {

		ImportExcel ei = new ImportExcel(file, 0, 0);
		List<GroomerExcelEntity> list = ei.getDataList(GroomerExcelEntity.class);

		/**
		 * 保留原校验 start
		 */
		Workbook wb = WorkbookFactory.create(file.getInputStream());
		Row row0 = wb.getSheetAt(0).getRow(0);
		short colCount = row0.getLastCellNum();// 总列数
		boolean headFlag = true;
		// TODO 校验标头
		String[] headerName = new String[] { "证书类型", "会员号", "会员姓名", "缴费状态", "支付方式", "订单金额", "缴费时间", "审核状态", "审核人",
				"审核时间", "签发日期", "申请时间" };
		for (int k = 0; k < colCount; k++) {
			Cell cell = row0.getCell(k);
			if (cell != null) {
				cell.setCellType(Cell.CELL_TYPE_STRING);
				if (!headerName[k].equals(cell.getStringCellValue().trim())) {
					headFlag = false;
					break;
				}
			}
		}
		if (!headFlag) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "模板标题不匹配！");
		}
		if (!fileExist(System.getProperty("java.io.tmpdir") + "/errorDateMeiRong.xls")) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "不符合规则的文件不存在！");
		}

		/**
		 * 保留原校验 end
		 */

		int successCount = 0;
		List<InternationalGroomerCertificate> lstError = new ArrayList<>();

		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		StrBuilder strBuilder = new StrBuilder();
		for (GroomerExcelEntity entity : list) {

			InternationalGroomerCertificate cm = new InternationalGroomerCertificate();
			cm.setCertificateType(entity.getType().trim().equals("国际高级宠物美容师资格证书") ? "ISPG" : "IPG");
			cm.setMemberCode(entity.getMemberCode().trim());
			cm.setCnName(entity.getMemberName().trim());
			cm.setPaymentState(entity.getPaymentStatus().trim().equals("已缴费") ? "2" : "1");
			cm.setPaymentWay(entity.getPaymentType().trim().equals("账户余额") ? "25" : "");
			cm.setTotalPrice(entity.getPaymentPrice().trim());
			cm.setReviewState(entity.getExamineStatus().trim().equals("已通过") ? "1" : "0");
			cm.setReviewer(entity.getExamineBy());
			try {

				cm.setPaymentTime(sDateFormat.parse(entity.getPaymentDate().trim()));
				cm.setReviewTime(sDateFormat.parse(entity.getExamineDate()));
				cm.setIssueDate(simpleDateFormat.parse(entity.getSendDate()));
				cm.setApplyTime(sDateFormat.parse(entity.getApplyDate()));

				if("ISPG".equals(cm.getCertificateType())){
					// 高级条件限制
					if (dataVerification(cm.getMemberCode(), cm.getApplyTime())){
						if(memberVerification(cm.getMemberCode(), cm.getCertificateType(), cm.getCnName())){
							cm.setPrintState("0");
						internationalGroomerCertificateService.saveCertificate(cm);
						successCount = successCount + 1;
						}else{
							lstError.add(cm);
							strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##").append("该会员名下已存在美容师资格证书编号");
						}
					}else{
						lstError.add(cm);
						strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##").append("该会员非美容师会员/美容师会员未在有效期内。");
					}
				}else{
					//低级条件限制
					Member member = memberService.getByMemberCode(cm.getMemberCode());
					if(member!=null && member.getGroomerType()!=null && StringUtils.isNotBlank(member.getGroomerType()) && member.getGroomerEndDate()!= null && member.getGroomerEndDate().getTime()>new Date().getTime()){
						Integer memberCertificateCount = internationalGroomerCertificateService.countMemberCertificate(member.getMemberCode(),
								cm.getCertificateType());
						if (memberCertificateCount != null && memberCertificateCount > 0) {
							lstError.add(cm);
							strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##").append("该会员名下已存在美容师资格证书编号。");
						}else{
							cm.setPrintState("0");
							internationalGroomerCertificateService.saveCertificate(cm);
							successCount = successCount + 1;
						}
					}else{
						lstError.add(cm);
						strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##").append("该会员非美容师会员/美容师会员未在有效期内。");
					}
				}

			} catch (ParseException ex) {
				logger.info(ex.getMessage());
				lstError.add(cm);
				strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##");
			} catch (Exception e) {
				logger.info(e.getMessage());
				lstError.add(cm);
				strBuilder.append(cm.getCnName() + "-" + cm.getMemberCode()).append("##");
			}

		}

		if (!lstError.isEmpty()) {
			putXls(lstError, headerName.length);
			strBuilder.append("不符合规则！");
			strBuilder
					.append("<a href='internationalGroomerCertificate/downloadViolationXls' target='_blank'>点击下载</a>");
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, strBuilder.toString());
		}
	}

}