package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容资格证书换发Entity
 * @author yuanshuai
 * @version 2024-02-18
 */
public class GroomerQualificationCertificateChange extends DataEntity<GroomerQualificationCertificateChange> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private Integer certificateSource;		// 证书来源（1CKU、2FCI、3香港）
	private String certificateLevel;		// 证书级别
	private String ckuCertificateLevel;		// CKU证书级别
	private String breedName;		// 品种名称
	private String breedCate;		// 品种类别
	private String country;		// 国家
	private String reviewer;		// 审查员
	private Date issueDate;		// 签发日期
	private String certificateImg;		// 证书图片
	private String runningNumber;		// 流水号
	private String paymentState;		// 支付状态
	private Date paymentTime;		// 支付时间
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核原因
	private Date proccessTime;		// 处理时间
	private String proccessState;		// 处理状态
	
	public GroomerQualificationCertificateChange() {
		super();
	}

	public GroomerQualificationCertificateChange(String id){
		super(id);
	}

	@Length(min=1, max=32, message="会员号长度必须介于 1 和 32 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@NotNull(message="证书来源（1CKU、2FCI、3香港）不能为空")
	public Integer getCertificateSource() {
		return certificateSource;
	}

	public void setCertificateSource(Integer certificateSource) {
		this.certificateSource = certificateSource;
	}
	
	@Length(min=1, max=32, message="证书级别长度必须介于 1 和 32 之间")
	public String getCertificateLevel() {
		return certificateLevel;
	}

	public void setCertificateLevel(String certificateLevel) {
		this.certificateLevel = certificateLevel;
	}
	
	@Length(min=0, max=32, message="CKU证书级别长度必须介于 0 和 32 之间")
	public String getCkuCertificateLevel() {
		return ckuCertificateLevel;
	}

	public void setCkuCertificateLevel(String ckuCertificateLevel) {
		this.ckuCertificateLevel = ckuCertificateLevel;
	}

	public String getBreedName() {
		return breedName;
	}

	public void setBreedName(String breedName) {
		this.breedName = breedName;
	}

	@Length(min=0, max=64, message="品种类别长度必须介于 0 和 64 之间")
	public String getBreedCate() {
		return breedCate;
	}

	public void setBreedCate(String breedCate) {
		this.breedCate = breedCate;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	@Length(min=0, max=64, message="审查员长度必须介于 0 和 64 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="签发日期不能为空")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}
	
	@Length(min=0, max=128, message="证书图片长度必须介于 0 和 128 之间")
	public String getCertificateImg() {
		return certificateImg;
	}

	public void setCertificateImg(String certificateImg) {
		this.certificateImg = certificateImg;
	}
	
	@Length(min=0, max=64, message="流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=64, message="支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@Length(min=0, max=64, message="审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=64, message="审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}
	
	@Length(min=0, max=64, message="处理状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}
	
}