package com.cku.oa.groomer.dao;

import java.util.List;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.vo.GroomerQualificationCertificateVO;
import org.apache.ibatis.annotations.Param;

import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.InternationalGroomerCertificate;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 美容师资格证书DAO接口
 * @author cxt
 * @version 2016-07-22
 */
@MyBatisDao
public interface GroomerQualificationCertificateDao extends CrudDao<GroomerQualificationCertificate> {

	//添加证书
	int insertCertificate(GroomerQualificationCertificate groomerQualificationCertificate);
	//查询会员最新级别
	List<GroomerQualificationCertificate> getLevel(String memberCode);
	//查询会员的考试信息
	List<GroomerQualificationCertificate> getMemberTest(String memberCode);
	//生成资格证书号
	void createCode(GroomerQualificationCertificate qualificationCertificate);
	void updateCertificateState(@Param("id") String id);
	//导出的数据
	List<GroomerQualificationCertificate> getCertificateList(GroomerQualificationCertificate qualificationCertificate);
	//打印
	GroomerQualificationCertificate  print(String id);
	//重置打印
	void resetPrint(GroomerQualificationCertificate gqc);
	//未处理的资格证书申请
	int getAuditCount();
	//领取胸花
	void updateCorsage(GroomerQualificationCertificate certificate);
	//CKU官网美容资格证书查询
	List<GroomerQualificationCertificate> getByKey(@Param("key")String key);
	//CKU官网国际宠物洗护师证书查询
	List<GroomerQualificationCertificate> getNurseByKey(@Param("key")String key);
	//根据报名id得到资格信息
	GroomerQualificationCertificate getRegister(@Param("registerId")String registerId);
	GroomerQualificationCertificate getRegisterById(@Param("id")String id);

	//根据会员号 和级别 查询是否有同级别的资格证书
	List<GroomerQualificationCertificate> eqCertificate(@Param("memberCode") String memberCode, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);

	List<GroomerQualificationCertificate> eqCertificatepay(@Param("memberCode") String memberCode, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);

	//获取胸花申领列表
	List<String> getCorsageClaimList();

	//删除证书
	void deleteCertificate(GroomerQualificationCertificate certificate);
	
	
	List<GroomerQualificationCertificate> getByMemberCode(String memberCode);

	int checkFistApply(@Param("memberCode")String memberCode);

	List<GroomerQualificationCertificate> getPersonnel(GroomerQualificationCertificate groomerQualificationCertificate);

	void updatePayment(GroomerQualificationCertificate certificate);

	int selectMaxCertificateNumI(@Param("certificateNumPrefix") String certificateNumPrefix);
	int selectMaxCertificateNum(@Param("certificateNumPrefix") String certificateNumPrefix);


	List<InternationalGroomerCertificate> getByMemcode(String memberCode);
	
	List<GroomerQualificationCertificate> findListByMember(@Param("memberList")List<Member> memberList);

	InternationalGroomerCertificate getById(String id);

	List<GroomerQualificationCertificate> findListBycku(GroomerQualificationCertificate groomerQualificationCertificate);

	List<GroomerQualificationCertificate> findListByCertificate(GroomerQualificationCertificate groomerQualificationCertificate);
	
	//一次考试中的付费证书
	GroomerQualificationCertificate getRegisterIdForPay(@Param("registerId")String registerId);
	
	//获取国际洗护师证书信息获取全部的报名信息
	List<GroomerRegister> findNurseRegisterList(@Param("memberCode") String memberCode);

	GroomerQualificationCertificate getByCertificateCode(@Param("certificateCode") String certificateCode ,@Param("certificateType") String certificateType );
	
	GroomerQualificationCertificate  getGroomerCertificateByCode(@Param("certificateCode")String certificateCode);

	GroomerQualificationCertificate getRegisterByIdAndLevel(@Param("id")String id, @Param("levelEn") String levelEn, @Param("memberCode") String memberCode);

	List<GroomerRegister> queryCertificateList(@Param("memberCode") String memberCode, @Param("pageNum") Integer pageNum, @Param("pageSize") Integer pageSize);

	/**
	 * 根据会员和级别查询资格证书
	 *
	 * @author yuanshuai
	 * @since 2024/2/19 16:44
	 */
	Integer findCountByMemberAndLevel(@Param("memberCode")String memberCode,@Param("levelEn") String levelEn);

	List<GroomerQualificationCertificate> queryGroomerQualificationCertificateAllInfo(GroomerQualificationCertificate groomerQualificationCertificate);

	GroomerQualificationCertificate getGroomerQualificationCertificateById(String id);

	GroomerQualificationCertificate getByMemberCodeAndLevel(@Param("levelEn") String levelEn, @Param("memberCode") String memberCode);

	/**
	 * 美容学校查询证书dao
	 * @param groomerQualificationCertificate
	 * @return
	 */
	List<GroomerQualificationCertificate> queryGroomerQualificationCertificateAllInfoByJG(GroomerQualificationCertificate groomerQualificationCertificate);

	List<GroomerQualificationCertificate> getPdgByShowCodeAndMemberCode(@Param("showCode") String showCode, @Param("memberCode") String memberCode);

	List<GroomerQualificationCertificateVO> exportGroomerQualificationCertificates(GroomerQualificationCertificate groomerQualificationCertificate);

	int selectCatNurseMaxCertificateNum( @Param("yearSuffix") String yearSuffix);

	GroomerQualificationCertificate  getGroomerCertificateById(@Param("id")String id);

	List<GroomerQualificationCertificate> findCertificatePayList(@Param("memberCode") String memberCode, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);

	List<GroomerQualificationCertificate> batchFindCertificatePayList(@Param("memberCodes") List<String> memberCodes, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);

	/**
	 * 伴侣猫洗护证书
	 */
	List<GroomerQualificationCertificate> getPartnerCatCertificateByKey(@Param("key")String key);

	List<GroomerQualificationCertificate> getByKeyNew(@Param("key")String key);
}