package com.cku.oa.dog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.dog.entity.DogNoseResult;
import com.cku.oa.dog.service.DogNoseResultService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 鼻纹识别结果Controller
 * 
 * @author zhaoxy
 * @version 2020-11-30
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogNoseResult")
public class DogNoseResultController extends BaseController {

	@Autowired
	private DogNoseResultService dogNoseResultService;

	@RequiresPermissions("dog:dogNoseResult:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogNoseResult dogNoseResult, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<DogNoseResult> page = dogNoseResultService.findPage(new Page<DogNoseResult>(request, response),
				dogNoseResult);
		model.addAttribute("page", page);
		return "oa/dog/dogNoseResult/dogNoseResultList";
	}

}