package com.cku.oa.dog.service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogSecondBreederDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogSecondBreeder;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 第二繁殖人Service
 *
 * @author wj
 * @version 2020-08-13
 */
@Service
@Transactional(readOnly = true)
public class DogSecondBreederService extends CrudService<DogSecondBreederDao, DogSecondBreeder> {

	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	public DogSecondBreeder get(String id) {
		return super.get(id);
	}

	public List<DogSecondBreeder> findList(DogSecondBreeder dogSecondBreeder) {
		return super.findList(dogSecondBreeder);
	}

	public Page<DogSecondBreeder> findPage(Page<DogSecondBreeder> page, DogSecondBreeder dogSecondBreeder) {
		return super.findPage(page, dogSecondBreeder);
	}

	@Transactional(readOnly = false)
	public void save(DogSecondBreeder dogSecondBreeder) {
		super.save(dogSecondBreeder);
	}

	@Transactional(readOnly = false)
	public void delete(DogSecondBreeder dogSecondBreeder) {
		if (StringUtils.isNotBlank(dogSecondBreeder.getPaymentState())
				&& dogSecondBreeder.getPaymentState().equals("2")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人已缴费、无法删除");
		}
		List<DogBirthCertificate> list = dogBirthCertificateDao
				.findByFmdogBreedCertifiedCode(dogSecondBreeder.getBreedCertifiedCode());
		if (!Collections3.isEmpty(list)) {
			for (DogBirthCertificate data : list) {
				data.setSecondBreeder("");
				data.setSecondBreederMemberCode("");
				dogBirthCertificateDao.update(data);
				Dog dog = dogDao.getByBirthCertificateLevelCode(data.getBirthCerRegCode());
				if (dog != null) {
					dogDao.updateSecondBreeder(dog.getId(), "");
				}
			}
		}
		super.delete(dogSecondBreeder);
	}

	@Transactional(readOnly = false)
	public void process(DogSecondBreeder dogSecondBreeder) throws Exception {
		if (StringUtils.isNotBlank(dogSecondBreeder.getReviewState())
				&& !dogSecondBreeder.getReviewState().equals("1")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人审核未通过");
		}
		if (StringUtils.isNotBlank(dogSecondBreeder.getPaymentState())
				&& !dogSecondBreeder.getPaymentState().equals("2")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人未缴费");
		}
		if (StringUtils.isNotBlank(dogSecondBreeder.getProcessState())
				&& !dogSecondBreeder.getProcessState().equals("0")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人无法处理");
		}
		List<DogBirthCertificate> list = dogBirthCertificateDao
				.findByFmdogBreedCertifiedCode(dogSecondBreeder.getBreedCertifiedCode());
		if (!Collections3.isEmpty(list)) {
			if (!"1".equals(list.get(0).getReviewState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡审核未通过");
			}
			for (DogBirthCertificate data : list) {
				data.setSecondBreeder(dogSecondBreeder.getSecondBreeder());
				data.setSecondBreederMemberCode(dogSecondBreeder.getSecondBreederMemberCode());
				dogBirthCertificateDao.update(data);
				Dog dog = dogDao.getByBirthCertificateLevelCode(data.getBirthCerRegCode());
				if (dog != null) {
					dogDao.updateSecondBreeder(dog.getId(), dogSecondBreeder.getSecondBreeder());
				}
			}
			dogSecondBreeder.setProcessState("1");
			dogSecondBreeder.setProcessTime(new Date());
			save(dogSecondBreeder);
		}
	}

	@Transactional(readOnly = false)
	public void saveInfo(String dogBirthCertificateId,String orderCode) {
		DogSecondBreeder secondBreeder = dao.getByBreedCertifiedCodeAndOrderCode(dogBirthCertificateId,orderCode);
		if(secondBreeder == null || "3".equals(secondBreeder.getReviewState())){
			List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.findByFmdogBreedCertifiedCode(dogBirthCertificateId);
			if(!Collections3.isEmpty(dogBirthCertificateList)) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateList.get(0);
				if (StringUtils.isNotBlank(dogBirthCertificate.getSecondBreederMemberCode())) {
					DogSecondBreeder dogSecondBreeder = new DogSecondBreeder();
					dogSecondBreeder.setBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
					dogSecondBreeder.setSecondBreeder(dogBirthCertificate.getSecondBreeder());
					dogSecondBreeder.setSecondBreederMemberCode(dogBirthCertificate.getSecondBreederMemberCode());
					dogSecondBreeder.setBreeder(dogBirthCertificate.getBreeder());
					dogSecondBreeder.setBreederMemberCode(dogBirthCertificate.getBreederMemberCode());
					dogSecondBreeder.setProcessTime(new Date());
					dogSecondBreeder.setProcessState("1");
					dogSecondBreeder.setReviewState("1");
					dogSecondBreeder.setReviewTime(new Date());
					dogSecondBreeder.setPaymentState(dogBirthCertificate.getPaymentState());
					dogSecondBreeder.setPaymentTime(dogBirthCertificate.getPaymentTime());
					dogSecondBreeder.setRunningNumber(orderCode);
					dogSecondBreeder.preInsert();
					dao.insert(dogSecondBreeder);
				}
			}
		}
	}

	@Transactional(readOnly = false)
	public void review(DogSecondBreeder dogSecondBreeder) {
		DogSecondBreeder secondBreeder = dao.get(dogSecondBreeder.getId());
		if (StringUtils.isNotBlank(secondBreeder.getPaymentState()) && !secondBreeder.getPaymentState().equals("2")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人未缴费");
		}
		secondBreeder.setReviewTime(new Date());
		secondBreeder.setReviewRemarks(dogSecondBreeder.getReviewRemarks());
		secondBreeder.setReviewState(dogSecondBreeder.getReviewState());
		dao.update(secondBreeder);
	}

	public Map<String, Object> getSecondBreeder(String secondBreederMemberCode) {
		if (StringUtils.isBlank(secondBreederMemberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人会员号为空");
		}
		Member member = memberService.getByMemberCode(secondBreederMemberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号码有误，请输入正确会员号");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理!");
		}
		if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(secondBreederMemberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理！");
		}
		Map<String, Object> map = new HashedMap();
		if (member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime()) {
			map.put("states", "1");
		} else {
			map.put("states", "0");
		}
		map.put("secondBreederMemberCode", member.getMemberCode());
		map.put("secondBreeder", member.getName());
		map.put("memberCardType", DictUtils.getDictLabel(member.getMemberCardType(), "member_card_type", ""));
		return map;
	}

	@Transactional(readOnly = false)
	public void saveOrder(DogSecondBreeder dogSecondBreeder) {
		String secondBreederMemberCode = dogSecondBreeder.getSecondBreederMemberCode();
		Member member = memberService.getByMemberCode(secondBreederMemberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号码有误，请输入正确会员号");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理!");
		}
		if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(secondBreederMemberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "第二繁殖人需为有效爱宠银卡及以上会员办理！");
		}
		String runningNumber = dogSecondBreeder.getRunningNumber();
		List<DogSecondBreeder> list = dao.getByRunningNumber(runningNumber);
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(runningNumber);
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findByOrderCode(runningNumber);
		if (!Collections3.isEmpty(list) && list.size() >= orderDetailList.size()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已经录入！");
		}
		String breedCertifiedCode = dogSecondBreeder.getBreedCertifiedCode();
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao
				.findByFmdogBreedCertifiedCode(breedCertifiedCode);
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateList.get(0);
		if (StringUtils.isNotBlank(dogBirthCertificate.getSecondBreederMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该窝犬只已登记第二繁殖，无法再次提交办理。");
		}
		Member loginMember = memberService.getByMemberCode(dogBirthCertificate.getMemberCode());
		String memberSite = loginMember.getMemberSite();
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(memberSite))
				|| memberSite.equals(member.getMemberSite()))) {
			memberSite = memberSite == null ? "2" : loginMember.getMemberSite();
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"第二繁殖人需为" + DictUtils.getDictLabel(memberSite, "member_site", "") + "有效银卡及以上会员办理");
		}
		dogSecondBreeder.setBreeder(dogBirthCertificate.getBreeder());
		dogSecondBreeder.setBreederMemberCode(dogBirthCertificate.getBreederMemberCode());
		dogSecondBreeder.setSecondBreeder(member.getName());
		dogSecondBreeder.setProcessState("0");
		dogSecondBreeder.setReviewState("0");
		dogSecondBreeder.setPaymentState("2");
		dogSecondBreeder.setPaymentTime(paymentOrder.getPaymentTime());
		dogSecondBreeder.preInsert();
		dao.insert(dogSecondBreeder);
		for (PaymentOrderDetail data : orderDetailList) {
			if (StringUtils.isBlank(data.getBusinessIds())) {
				data.setBusinessIds(dogSecondBreeder.getId());
				data.setBusinessTable("dog_second_breeder");
				paymentOrderDetailDao.update(data);
				break;
			}
		}
	}

	@Transactional(readOnly = false)
	public void updatePaymentStates(String businessIds,String orderCode) {
		DogSecondBreeder secondBreeder = dao.getByBreedCertifiedCodeAndOrderCode(businessIds,orderCode);
		if(secondBreeder != null){
			secondBreeder.setPaymentTime(new Date());
			secondBreeder.setPaymentState("2");
			secondBreeder.preUpdate();
			dao.update(secondBreeder);
		}
	}
}