package com.cku.oa.clubdog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 淘宠宝犬只信息Controller
 * @author cxt
 * @version 2017-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/clubdog/clubDog")
public class ClubDogController extends BaseController {

	@Autowired
	private ClubDogService clubDogService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogTypeService dogTypeService;
	
	@ModelAttribute
	public ClubDog get(@RequestParam(required=false) String id) {
		ClubDog entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = clubDogService.get(id);
		}
		if (entity == null){
			entity = new ClubDog();
		}
		return entity;
	}
	
	@RequiresPermissions("clubdog:clubDog:view")
	@RequestMapping(value = {"list", ""})
	public String list(ClubDog clubDog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ClubDog> page = clubDogService.findPage(new Page<ClubDog>(request, response), clubDog); 
		model.addAttribute("page", page);
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		return "oa/clubdog/clubDogList";
	}

	@RequiresPermissions("clubdog:clubDog:view")
	@RequestMapping(value = "form")
	public String form(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		return "oa/clubdog/clubDogForm";
	}
	/**
	 * 查看页面
	 * @Author chaixueteng
	 * @2017年10月23日上午10:35:14
	 */
	@RequiresPermissions("clubdog:clubDog:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(ClubDog clubDog, Model model) {
		model.addAttribute("clubDog", clubDog);
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		return "oa/clubdog/clubDogViewForm";
	}

	@RequiresPermissions("clubdog:clubDog:edit")
	@RequestMapping(value = "save")
	public String save(ClubDog clubDog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, clubDog)){
			return form(clubDog, model);
		}
		clubDogService.save(clubDog);
		addMessage(redirectAttributes, "保存犬只信息成功");
		return "redirect:"+Global.getAdminPath()+"/clubdog/clubDog/?repage";
	}
	
	@RequiresPermissions("clubdog:clubDog:delete")
	@RequestMapping(value = "delete")
	public String delete(ClubDog clubDog, RedirectAttributes redirectAttributes) {
		clubDogService.delete(clubDog);
		addMessage(redirectAttributes, "删除犬只信息成功");
		return "redirect:"+Global.getAdminPath()+"/clubdog/clubDog/?repage";
	}

}