package com.cku.cab.editor.handlervenue.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.cab.editor.handlervenue.entity.HandlerVenue;
import com.cku.cab.editor.handlervenue.entity.RestfulHandlerVenue;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.cab.editor.groomervenue.entity.GroomerVenue;
import com.cku.cab.editor.groomervenue.entity.RestfulGroomerVenue;
import com.cku.cab.editor.handlervenue.dao.HandlerVenueDao;

/**
 * 培训场馆Service
 * @author zhuoHeng
 * @version 2016-11-25
 */
@Service
@Transactional(readOnly = true)
public class HandlerVenueService extends CrudService<HandlerVenueDao, HandlerVenue> {

	public HandlerVenue get(String id) {
		return super.get(id);
	}
	
	public List<HandlerVenue> findList(HandlerVenue handlerVenue) {
		return super.findList(handlerVenue);
	}
	
	public Page<HandlerVenue> findPage(Page<HandlerVenue> page, HandlerVenue handlerVenue) {
		return super.findPage(page, handlerVenue);
	}
	
	@Transactional(readOnly = false)
	public void save(HandlerVenue handlerVenue) {
		super.save(handlerVenue);
	}
	
	@Transactional(readOnly = false)
	public void delete(HandlerVenue handlerVenue) {
		super.delete(handlerVenue);
	}
	
	/**
	 * 
	 * @Description：培训场馆
	 * @author: zhuoHeng
	 * @version: 2016年11月28日 上午10:43:42
	 */
	public RESTResponse getVenue(HttpServletRequest request) {
		
		String id = request.getParameter("id");
		HandlerVenue model = super.get(id);
		RestfulHandlerVenue vo = new RestfulHandlerVenue();
		BeanUtil.copyProperties(vo, model, "yyyy-MM-dd");
		
		return new RESTResponse("data", vo);
	}
}