<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展酒店管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showHotel/">犬展酒店列表</a></li>
		<shiro:hasPermission name="show:showHotel:add"><li><a href="${ctx}/show/showHotel/form">犬展酒店添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showHotel" action="${ctx}/show/showHotel/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>酒店名称：</label>
				<form:input path="hotelName" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>酒店地址：</label>
				<form:input path="hotelAddress" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>酒店电话：</label>
				<form:input path="hotelPhone" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>酒店名称</th>
				<th>酒店地址</th>
				<th>酒店电话</th>
				<th>创建时间</th>
				<th>备注信息</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showHotel">
			<tr>
				<td>
					${showHotel.hotelName}
				</td>
				<td>
					${showHotel.hotelAddress}
				</td>
				<td>
					${showHotel.hotelPhone}
				</td>
				<td>
					<fmt:formatDate value="${showHotel.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${showHotel.remarks}
				</td>
				<td>
				<shiro:hasPermission name="show:showHotel:view">
					<a href="${ctx}/show/showHotel/view?id=${showHotel.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="show:showHotel:edit">
    				<a href="${ctx}/show/showHotel/form?id=${showHotel.id}">修改</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="show:showHotel:delete">
					<a href="${ctx}/show/showHotel/delete?id=${showHotel.id}" onclick="return confirmx('确认要删除该犬展酒店吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>