<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>

</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerRegister/view?id=${handlerRegister.id}">报名信息查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerRegister"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.registerCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
			${fns:getDictLabel(handlerRegister.gender, 'user_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.mobile)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
					${fns:getDictLabel(handlerRegister.showLevel, 'groomer_test_level', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.schoolNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.fee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">桌面审查犬：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.desktopReviewerDog)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地面审查犬：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.floorReviewerDog)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">任意品种：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.anyBreed)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容品种：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.groomerBreed)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
					${fns:getDictLabel(handlerRegister.reviewState, 'review_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">付款的状态：</label>
			<div class="controls">
					${fns:getDictLabel(handlerRegister.paymentState, 'payment_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.reviewRemarks)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.remarks)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">照片：</label>
			<div class="controls">
			${fns:escapeHtml(handlerRegister.avatar)}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>