<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>成绩查看</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<style>
		#table{
			padding: 20px;
		}
		.table_row{
			margin-bottom: 20px;
		}
	</style>
</head>

<body>

	<div id="table">
		<c:forEach items="${groomerExamQuestionsList}" var="groomerExamQuestions" varStatus="status">
			<div class="table_row">
				<div class="table_label">
					${status.index + 1}、${fns:escapeHtml(groomerExamQuestions.questionContent)}
				</div>
				<div class="table_value">
					<c:forEach items="${groomerExamQuestions.groomerExamQuestionsOptionsList}"
							   var="groomerExamQuestionsOption" varStatus="status">
						<c:choose>
							<c:when test="${groomerExamQuestionsOption.optionId==groomerExamQuestions.selectOptionId}">
								<input type="checkbox" checked onclick="return false;"/>${fns:escapeHtml(groomerExamQuestionsOption.optionContent)}
							</c:when>
							<c:otherwise>
								<input type="checkbox" onclick="return false;"/>${fns:escapeHtml(groomerExamQuestionsOption.optionContent)}
							</c:otherwise>
						</c:choose>
					</c:forEach>
				</div>
				<div class="table_result">
					<c:choose>
						<c:when test="${groomerExamQuestions.selectOptionId == null || groomerExamQuestions.selectOptionId == ''}">
						</c:when>
						<c:otherwise>
							<c:choose>
								<c:when test="${groomerExamQuestions.selectOptionId==groomerExamQuestions.answer}">
									<span style="color: green">正确</span>
								</c:when>
								<c:otherwise>
									<span style="color: red">错误</span>
								</c:otherwise>
							</c:choose>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
		</c:forEach>
	</div>
</body>
</html>