<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>培训课程</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnSubmit").click(function(){
				window.location.href="${ctx}/groomer/curriculum/form";
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
			return false;
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/curriculum/list">推荐课程</a></li>
	</ul>
	<br>
	<form:form id="searchForm" modelAttribute="curriculum" action="${ctx}/groomer/curriculum/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li>
				<label>类型：</label>
                <form:select path="curriculumType" class="input-small">
                    <form:option label="全部" value=""></form:option>
                    <form:options items="${fns:getDictList('curriculum_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
			</li>
			<li class="btns"><input  class="btn btn-primary" type="submit" value="查询"/>
				<shiro:hasPermission name="groomer:curriculum:save">
					<input id="btnSubmit" class="btn btn-primary" type="button" value="新建"/>
				</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>

	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>序号</th>
				<th>名称</th>
				<th>类型</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="curriculum">
			<tr>
				<td>
						${curriculum.curriculumIndex}
				</td>
				<td>
						${curriculum.curriculumName}
				</td>
				<td>
                        <%--${fns:getDictLabel(curriculum.curriculumType, 'curriculum_type', '')}--%>
							<c:if test="${curriculum.curriculumType=='1'}">线下培训课</c:if>
							<c:if test="${curriculum.curriculumType=='2'}">线上公开课</c:if>

				</td>
				<td>
					<shiro:hasPermission name="groomer:curriculum:save">
						<a href="${ctx}/groomer/curriculum/form?id=${curriculum.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="groomer:curriculum:isRecommend">
						<c:if test="${curriculum.recommend==null or curriculum.recommend=='' or curriculum.recommend=='0'}">
							<a href="${ctx}/groomer/curriculum/isRecommend?id=${curriculum.id}&recommend=1">推荐</a>
						</c:if>
						<c:if test="${curriculum.recommend==1}">
							<a href="${ctx}/groomer/curriculum/isRecommend?id=${curriculum.id}&recommend=0">取消推荐</a>
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>