<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>视频鉴定管理</title>
<meta name="decorator" content="default" />

	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<style>
		.picDiv>div{
			width:33%;
		}
	</style>
	
<script type="text/javascript">
	$(document).ready(function() {
		
	});
	
	function viewImg(obj,tit){
		var img = new Image();  
        img.src = obj.src;
        var imgHtml = "<img src='" + obj.src + "' width='800px' height='900px'/>";  
        //弹出层
        layer.open({  
            type: 1,  
            shade: 0.8,
            offset: 'auto',
            area:['auto','auto'],
            shadeClose:true,
            scrollbar: false,
            title: tit, //不显示标题  
            content: imgHtml, //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响  
            cancel: function () {  
                //layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', { time: 5000, icon: 6 });  
            }  
        }); 
	}
</script>
<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogvideoappraisal/">视频鉴定列表</a></li>
	</ul>
	<br />
	<form:form id="inputForm" modelAttribute="dogVideoAppraisal" class="form-horizontal">
		<form:hidden path="id" />
		<sys:message content="${message}" />
		犬只信息:
		<div  class="control-group" style="width: 100%;float: left; height: 190px">
			<div style="margin-top: 20px">
				<div class="control-group">
					<label class="control-label">犬种：</label>
					<div class="controls">
						${info.dogBreedCn }
					</div>
				</div>
				<div class="control-group">
					<label class="control-label">毛色：</label>
					<div class="controls">
						${fns:escapeHtml(info.dogColorCn)}
					</div>
				</div>
				<div class="control-group">
					<label class="control-label">犬只名称：</label>
					<div class="controls">
						${fns:escapeHtml(info.dogName)}</div>
				</div>
				<div class="control-group">
					<label class="control-label">性别：</label>
					<div class="controls">
						${fns:escapeHtml(info.dogGenderDesc)}</div>
				</div>
				<div class="control-group">
					<label class="control-label">出生日期：</label>
					<div class="controls">
						<fmt:formatDate value="${info.dogBirth}"
							pattern="yyyy-MM-dd" />
					</div>
				</div>
				<div class="control-group">
					<label class="control-label">犬只主人：</label>
					<div class="controls">
						${fns:escapeHtml(info.memberName)}</div>
				</div>
				<div class="control-group">
					<label class="control-label">芯片编号：</label>
					<div class="controls">
						${fns:escapeHtml(info.chipNo)}</div>
				</div>
				<div class="control-group">
					<label class="control-label">护照编号：</label>
					<div class="controls">
						${fns:escapeHtml(info.passportNo)}</div>
				</div>
			</div>
		</div>
		<div  class="control-group" style="width: 100%;float: left; height: 190px">
			<label class="control-label">犬只图片：</label>
				<div class="controls">
					<c:forEach items="${info.imgs }" var = "list" varStatus = "status">
						<c:if test="${list.fileSort eq '1'}">
							<img style="width:180px; height: 190px" alt="犬只正面照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只正面照片')" src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '2'}">
							<img style="width:180px; height: 190px" alt="犬只左侧照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只左侧照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '3'}">
							<img  style="width:180px; height: 190px" alt="犬只右侧照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只右侧照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '4'}">
							<img  style="width:180px; height: 190px" alt="犬只背面照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只背面照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
					</c:forEach>
			 </div>
		</div>
		
		<div  class="control-group" style="width: 100%;float: left;">
			<label class="control-label">犬只视频：</label>
				<div class="controls">
			<%-- <c:forEach items="${info.videos }" var = "list" varStatus = "status">
				<video src="${info.vodUrl }" controls="controls">
				</video>
			</c:forEach> --%>
			<video width="600px" height="400px" src="${info.vodUrl}" controls="controls">
				</video>
		   </div>
		</div>
		

		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)" />
		</div>
	</form:form>
</body>
</html>