<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function dogAppraisalApply(identifyType,paymentMemberCode,paymentChargingItemId,runningNumber){
			parent.layer.open({
				type: 2,
				title: ['纯种犬鉴定申请', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '450px'],
				content: ctx+"/dogappraisal/dogAppraisal/dogAppraisalApply?identifyType="+identifyType+"&paymentMemberCode="+paymentMemberCode+"&paymentChargingItemId="+paymentChargingItemId+"&runningNumber="+runningNumber,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogappraisal/dogAppraisal/list?dogBreed=230">犬只鉴定列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogAppraisal" action="${ctx}/dogappraisal/dogAppraisal/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="dogOwnerName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬名：</label>
				<form:input path="dogName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬种：</label>
				<input name="dogBreed" type="text" value="230" readonly/>
			</li>
			<li><label>鉴定类型：</label>
				<form:select path="identifyType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_appraisal_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>鉴定地点：</label>
				<form:input path="identifySite" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_appraisal_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>付款的状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>流程状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogAppraisal.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogAppraisal.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬只姓名</th>
				<th>鉴定证书号</th>
				<th>宠爱证书号</th>
				<th>犬种</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>鉴定类型</th>
				<th>鉴定地点</th>
				<th>订单状态</th>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:audit"><th>审核状态</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:resolve"><th>处理</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:delete"><th>删除</th></shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:print"><th>打印</th></shiro:hasPermission>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogAppraisal">
			<tr>
				<td>
					${fns:escapeHtml(dogAppraisal.dogName)}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.chongaiCertificateCode)}
				</td>
				<td title="${fns:escapeHtml(dogAppraisal.breedCnName)}">
					${fns:escapeHtml(dogAppraisal.dogBreed)}
				</td>
				<td title="${fns:escapeHtml(dogAppraisal.dogOwnerCode)}">
					${fns:escapeHtml(dogAppraisal.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogAppraisal.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:getDictLabel(dogAppraisal.identifyType, 'dog_appraisal_type', '')}
				</td>
				<td>
					${fns:escapeHtml(dogAppraisal.identifySite)}
				</td>
				<td style="color:${dogAppraisal.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogAppraisal.paymentState, 'user_payment_state', '')}
				</td>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:audit">
				<td style="color:#000">
					<c:if test="${dogAppraisal.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogAppraisal.reviewState=='2'}">
							<a style="color:#F00" href="${ctx}/dogappraisal/dogAppraisal/auditForm?id=${dogAppraisal.id}">
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogAppraisal.reviewState=='0'}">
							<a style="color:#000" title="${fns:escapeHtml(dogAppraisal.reviewRemarks)}">
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogAppraisal.reviewState, 'dog_appraisal_review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:resolve">
				<td style="color:#000">
					<c:if test="${dogAppraisal.reviewState=='1' &&  dogAppraisal.businessRefundState!='1' && dogAppraisal.businessRefundState!='3' }">
    					<c:choose>
							<c:when test="${dogAppraisal.processState=='0'}">
								<a href="${ctx}/dogappraisal/dogAppraisal/resolve?id=${dogAppraisal.id}" style="color:#F00" onclick="return confirmx('确认要处理该犬只鉴定吗？', this.href)">
								${fns:getDictLabel(dogAppraisal.processState, 'proccess_state', '')}
								</a>
							</c:when>
							<c:otherwise>
								${fns:getDictLabel(dogAppraisal.processState, 'proccess_state', '')}
							</c:otherwise>
    					</c:choose>
    				</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:delete">
				<td>
					<a href="${ctx}/dogappraisal/dogAppraisal/delete?id=${dogAppraisal.id}" onclick="return confirmx('确认要删除该犬只鉴定吗？', this.href)">删除</a>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogappraisal:dogAppraisal:print">
				<td>
					<c:if test="${dogAppraisal.reviewState=='1'&&dogAppraisal.processState=='1'}">
						<c:if test="${dogAppraisal.identifyType=='1'}">
							<c:if test="${dogAppraisal.dnaPrintFlag=='0'}">
								<a href="${ctx}/dogappraisal/dogAppraisal/printDna?id=${dogAppraisal.id}">DNA打印</a>
							</c:if>
							<c:if test="${dogAppraisal.dnaPrintFlag=='1'}">
								<a href="${ctx}/dogappraisal/dogAppraisal/resetPrintDna?id=${dogAppraisal.id}">DNA打印重置</a>
							</c:if>
						</c:if>
						<c:if test="${dogAppraisal.printState=='1'}">
						<a href="${ctx}/dogappraisal/dogAppraisal/print?id=${dogAppraisal.id}">鉴定打印</a>
						</c:if>
						<shiro:hasPermission name="dogappraisal:dogAppraisal:resetPrint">
						<c:if test="${dogAppraisal.printState=='01'}">
						<a href="${ctx}/dogappraisal/dogAppraisal/resetPrint?id=${dogAppraisal.id}">重置鉴定打印</a>
						</c:if>
						</shiro:hasPermission>
					</c:if>
				</td>
				</shiro:hasPermission>
				<td>
					<a href="${ctx}/dogappraisal/dogAppraisal/form?id=${dogAppraisal.id}">查看</a>
					<c:if test="${dogAppraisal.businessRefundState!='1' && dogAppraisal.businessRefundState!='3' }">
						<a href="${ctx}/dogappraisal/dogAppraisal/editForm?id=${dogAppraisal.id}">编辑</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>