<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>出生证明管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //默认状态
            $("#remarks1").show();
            $("#remarks2").hide();
            $("#identificationFlag1").show();
            $("#identificationFlag2").hide();
        });

        function changeReGetType(obj){
            var val = $(obj).val();
            if(val == '1'){
                $("#remarks1").show();
                $("#remarks2").hide();
                $("#identificationFlag1").show();
                $("#identificationFlag2").hide();
                $("#dogChipPaymentChargingItem").show();
                $("#dogChipLabel").html("芯片费");
                $("#totalPrice").html("100.0");
            }else if(val == '2'){
                $("#remarks1").hide();
                $("#remarks2").show();
                $("#identificationFlag1").show();
                $("#identificationFlag2").hide();
                $("#dogChipPaymentChargingItem").hide();
                $("#totalPrice").html("50.0");
            }else if(val == '3'){
                $("#remarks1").show();
                $("#remarks2").hide();
                $("#identificationFlag1").hide();
                $("#identificationFlag2").show();
                $("#dogChipPaymentChargingItem").show();
                $("#dogChipPaymentChargingItemPrice").html("0.00");
                $("#dogBirthCertificatePaymentChargingItemPrice").html("0.00");
                $("#dogChipLabel").html("芯片费（补发芯片）");
                $("#totalPrice").html("0.0");

            }
        }
    </script>
    <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active">重领出生证明</li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogBirthCertificate"
           action="${ctx}/birthcertificate/dogBirthCertificate/reGet" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">原出生纸编号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">新出生纸编号：</label>
        <div class="controls">
                ${fns:escapeHtml(birthCerRegCodeNew)}
            <input name="birthCerRegCodeNew" type="hidden" value="${fns:escapeHtml(birthCerRegCodeNew)}"/>
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">配种证明编号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
                ${fns:escapeHtml(dogBirthCertificate.dogBreed)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
                ${fns:getDictLabel(dogBirthCertificate.dogGender, 'dog_gender', '')}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">毛色：</label>
        <div class="controls">
                ${fns:escapeHtml(dogBirthCertificate.colorFlag)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogBirthCertificate.dogEnName)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div id="identificationFlag1" class="controls">
                ${fns:escapeHtml(dogBirthCertificate.identificationFlag)}
        </div>
        <div id="identificationFlag2" class="controls">
            <form:input path="identificationFlag" htmlEscape="false"  maxlength="255" class="input-xlarge required"/>
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">繁殖人会员号：</label>
        <div class="controls">
                ${fns:escapeHtml(breeder.memberCode)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">繁殖人姓名：</label>
        <div class="controls">
                ${fns:escapeHtml(breeder.name)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">繁殖人账户余额：</label>
        <div class="controls">
                ${fns:escapeHtml(breeder.accountBalance)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">类型：</label>
        <div class="controls">
            <input name="reGetType" class="input-xlarge "  type="radio" checked  value="1" onchange="changeReGetType(this)"/>
            <label>登记卡重领（100元）</label>
            <input name="reGetType" class="input-xlarge "  type="radio"  value="2" onchange="changeReGetType(this)"/>
            <label>登记卡补办（50元）</label>
            <input name="reGetType" class="input-xlarge "  type="radio"  value="3" onchange="changeReGetType(this)"/>
            <label>登记卡补办（含芯片）（0元）</label>
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">${fns:escapeHtml(dogBirthCertificatePaymentChargingItem.name)}：</label>
        <div id="dogBirthCertificatePaymentChargingItemPrice" class="controls">
                ${fns:escapeHtml(dogBirthCertificatePaymentChargingItem.price)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div id="dogChipPaymentChargingItem" class="control-group">
        <label id="dogChipLabel" class="control-label">${fns:escapeHtml(dogChipPaymentChargingItem.name)}：</label>
        <div id="dogChipPaymentChargingItemPrice" class="controls">
                ${fns:escapeHtml(dogChipPaymentChargingItem.price)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">合计：</label>
        <div id="totalPrice" class="controls">
                ${fns:escapeHtml(totalPrice)}
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <div class="controls">
            <input name="payType" type="radio" value="" checked/>余额支付
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div id="remarks1" class="controls">
            出生纸重领(新出生纸号:${fns:escapeHtml(birthCerRegCodeNew)})。${fns:escapeHtml(dogBirthCertificate.remarks)}
        </div>
        <div id="remarks2" class="controls">
            <form:textarea path="remarks" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
        </div>
    </div>
    <div style="clear:both;"/>
    <div class="form-actions">
        <shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit"><input id="btnSubmit"
                                                                                     class="btn btn-primary"
                                                                                     type="submit"
                                                                                     value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>