<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展犬只管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/contest/contestExhibit/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/contest/contestExhibit/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/contest/contestExhibit/">犬展犬只列表</a></li>
		<shiro:hasPermission name="contest:contestExhibit:edit"><li><a href="${ctx}/contest/contestExhibit/form">犬展犬只添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="contestExhibit" action="${ctx}/contest/contestExhibit/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>秩序号：</label>
				<form:input path="exhibitNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>犬展评价：</label>
				<form:input path="grade" htmlEscape="false" maxlength="4" class="input-medium"/>
			</li>
			<li><label>血统证书：</label>
				<form:input path="pedigreeCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>犬种编号：</label>
				<form:input path="breedNo" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>年龄组别编号：</label>
				<form:input path="classNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>子犬展编号：</label>
				<form:input path="contestNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="contest:contestExhibit:import">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="犬只导入"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>活动区域</th>
				<th>秩序号</th>
				<th>犬展评价</th>
				<th>血统证书</th>
				<th>犬种编号</th>
				<th>年龄组别编号</th>
				<th>BOH</th>
				<th>子犬展编号</th>
				<shiro:hasPermission name="contest:contestExhibit:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="contestExhibit">
			<tr>
				<td>
					${contestExhibit.raceLap}
				</td>
				<td><a href="${ctx}/contest/contestExhibit/form?id=${contestExhibit.id}">
					${contestExhibit.exhibitNo}
				</a></td>
				<td>
					${contestExhibit.grade}
				</td>
				<td>
					${contestExhibit.pedigreeCode}
				</td>
				<td>
					${contestExhibit.breedNo}
				</td>
				<td>
					${contestExhibit.classNo}
				</td>
				<td>
					${fns:getDictLabel(contestExhibit.boh, 'yes_no', '')}
				</td>
				<td>
					${contestExhibit.contestNo}
				</td>
				<shiro:hasPermission name="contest:contestExhibit:edit"><td>
    				<a href="${ctx}/contest/contestExhibit/form?id=${contestExhibit.id}">修改</a>
					<a href="${ctx}/contest/contestExhibit/delete?id=${contestExhibit.id}" onclick="return confirmx('确认要删除该犬展犬只吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>