<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鉴赏课管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnUpload").click(function(){
				uploadCourseware("");
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function uploadCourseware(id){
			parent.isRefresh = false;
			top.layer.open({
                type: 2,
                title: ['课程资料上传', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['600px', '400px'],
                content: "${ctx}/appreciation/appreciationCourseware/editForm?id="+id,
                btn: ['保存', '取消'],
	    		yes: function(index,layero){
	    			$(layero).find("iframe")[0].contentWindow.saveCourseware();
	    		},
	    		end: function(){
					if(parent.isRefresh){
						$("#searchForm").submit();
					};
				}
            });
		}
	</script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="appreciationCourseware" action="${ctx}/appreciation/appreciationCourseware/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>资料名称：</label>
				<form:input path="coursewareName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>关联课程：</label>
				<form:input path="coursesName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>课件状态：</label>
				<form:select path="states" class="input-medium">
					<form:option value="" label=""/>
					<form:option value="" label="全部"/>
					<form:option value="1" label="已上架"/>
					<form:option value="0" label="已下架"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnUpload" class="btn btn-primary" type="button" value="上传资料"/></li>
			<li class="clearfix"></li>
			<li><label>上传时间：</label>
				<input name="beginUpdateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appreciationCourseware.beginUpdateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				-
				<input name="endUpdateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appreciationCourseware.endUpdateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd 23:59:59',isShowClear:true});"/>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>资料名称</th>
				<th>创建时间</th>
				<th>修改时间</th>
				<th>关联课程</th>
				<th>课件状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appreciationCourseware">
			<tr>
				<td>
					${appreciationCourseware.coursewareName}
				</td>
				<td>
					<fmt:formatDate value="${appreciationCourseware.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${appreciationCourseware.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
						${appreciationCourseware.coursesCount}
				</td>
				<td>
						已${fns:getDictLabel(appreciationCourseware.states, 'on_off_sale', '')}
				</td>
				<td>
					<a href="${appreciationCourseware.url}" target="_blank">下载</a>
					<shiro:hasPermission name="appreciation:appreciationCourseware:onoff">
						<a href="${ctx}/appreciation/appreciationCourseware/onoff?id=${appreciationCourseware.id}">
								${fns:getDictLabel(appreciationCourseware.states==0?1:0, 'on_off_sale', '')}
						</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="appreciation:appreciationCourseware:edit">
    				<a href="###" onclick="uploadCourseware('${appreciationCourseware.id}');">更新</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="appreciation:appreciationCourseware:del">
					<a href="${ctx}/appreciation/appreciationCourseware/delete?id=${appreciationCourseware.id}" onclick="return confirmx('确认要删除该鉴赏课吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>