package com.cku.restful.v1.sys.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.entity.WhitelistModule;
import com.cku.oa.breeder.service.WhitelistService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberType;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.sys.model.RestMember;
import com.cku.restful.v1.sys.model.RestRenew;
import com.cku.restful.v1.sys.model.RestRenewKennel;
import com.cku.restful.v1.sys.model.RestRenewMember;
import com.cku.restful.v1.sys.model.RestRenewPaymentItem;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 业务提醒功能Service
 * 
 * @author fanhuibin
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestMemberService {

	public static final String MEMER_BASIC = "sys_member@B";// 基础会员费
	public static final String MEMBER_PROFESSIONAL = "sys_member@P";// 专业会员费
	public static final String MEMBER_PROFESSIONAL_FIRST = "sys_member@F";// 专业会员的新注册费
	public static final String MEMBER_BASIC_TO_PROFESSIONAL = "sys_member@BTP";// 普通会员升级为专业会员
	public static final String ZF_PROFESSIONAL = "sys_member@PB"; // 专业繁育会员
	public static final String ZF_PROFESSIONAL_FIRST = "sys_member@PBF"; // 专业繁育会员

	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private WhitelistService whitelistService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;
	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;

	public static final String MEMBER_BASIC_TO_PROFESSIONAL_BREED = "sys_member@BTPB";// 普通会员升级为繁育会员

	public static final String MEMBER_PROFESSIONAL_BREED = "sys_member@PB";// 繁育专业会员
	public static final String MEMBER_PROFESSIONAL_BREED_FIRST = "sys_member@PBF";// 繁育专业会员新注册费
	public static final String MEMBER_PROFESSIONAL_BREED_PREFERENTIAL = "sys_member@PBP";// 繁育专业会员优惠

	public String getRenewPrice(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录用户信息为空，请登录");
		}
		if ("1".equals(member.getFreezeFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法续费!");
		}
		String shortName = null;
		if (StringUtils.isEmpty(member.getMemberType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员信息无效,请核实后重新输入!");
		}
		if ("basic".equals(member.getMemberType())) {
			shortName = MEMER_BASIC;
		}
		if ("1".equals(member.getRegisterFlag()) && "professional".equals(member.getMemberType())) {
			shortName = ZF_PROFESSIONAL;
		}
		if ("0".equals(member.getRegisterFlag()) && "professional".equals(member.getMemberType())) {
			shortName = MEMBER_PROFESSIONAL;
		}
		Date now = new Date();

		Double totalPrice = 0d;
		// 如果会员截至日期为空，走从新申请会员流程
		if (member.getMemberEndDate() != null && now.before(member.getMemberEndDate())) {
			// 未过期
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
			totalPrice += Double.parseDouble(paymentChargingItem.getPrice());
		} else {
			// 过期
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
			totalPrice += Double.parseDouble(paymentChargingItem.getPrice());

			if ("0".equals(member.getRegisterFlag()) && "professional".equals(member.getMemberType())
					&& (member.getMemberEndDate() == null
							|| !com.cku.oa.sys.util.DateUtils.isInXMounth(member.getMemberEndDate(), 1))) {
				PaymentChargingItem professionalFirst = paymentChargingItemService
						.getByShortName(MEMBER_PROFESSIONAL_FIRST);

				totalPrice += Double.parseDouble(professionalFirst.getPrice());
			}
			if ("1".equals(member.getRegisterFlag()) && "professional".equals(member.getMemberType())
					&& (member.getMemberEndDate() == null
							|| !com.cku.oa.sys.util.DateUtils.isInXMounth(member.getMemberEndDate(), 1))) {
				PaymentChargingItem zfProfessionalFirst = paymentChargingItemService
						.getByShortName(ZF_PROFESSIONAL_FIRST);
				totalPrice += Double.parseDouble(zfProfessionalFirst.getPrice());
			}
		}

		return totalPrice.toString();
	}

	public RestRenew getRenewInfo(String memberCode) {

		Member member = memberService.findMemberAndKennelByMemberCode(memberCode);
		RestRenew result = new RestRenew();
		result.setTotalPrice(BigDecimal.ZERO);
		RestRenewMember restMember = new RestRenewMember();
		BeanUtil.copyProperties(restMember, member, "yyyy-MM-dd");
		restMember.setItemTotalPrice(BigDecimal.ZERO);
		result.setMember(restMember);
		RestRenewKennel restKennel = new RestRenewKennel();
		if (member.getKennel() != null) {
			BeanUtil.copyProperties(restKennel, member.getKennel(), "yyyy-MM-dd");
		}
		restKennel.setItemTotalPrice(BigDecimal.ZERO);
		result.setKennel(restKennel);
		String memberRenewType = memberService.getMemberRenewalType(member);
		List<PaymentChargingItem> chargingItems = paymentChargingItemGroupService
				.findPaymentChargingItemById(memberRenewType);
		// 20201212活动
		PaymentChargingItem discount = memberActivity20201212Discount.get20201212Discount(memberRenewType, memberCode);
		if (discount != null) {
			chargingItems.add(discount);
		}
		if (!chargingItems.isEmpty()) {
			List<RestRenewPaymentItem> memberItems = chargingItems.stream()
					.filter(item -> item.getShortName().startsWith("sys_member")).map(item -> {
						RestRenewPaymentItem pi = new RestRenewPaymentItem();
						pi.setId(item.getId());
						pi.setName(item.getName());
						pi.setPrice(StringUtils.isBlank(item.getPrice()) ? BigDecimal.ZERO
								: new BigDecimal(item.getPrice()));
						pi.setShortName(item.getShortName());
						return pi;
					}).collect(Collectors.toList());
			BigDecimal memberTotalPrice = memberItems.stream().map(RestRenewPaymentItem::getPrice)
					.reduce(BigDecimal.ZERO, BigDecimal::add);
			restMember.setItemTotalPrice(memberTotalPrice);
			restMember.setPaymentItems(memberItems);
			result.setTotalPrice(memberTotalPrice);

			List<RestRenewPaymentItem> kennelItems = chargingItems.stream()
					.filter(item -> item.getShortName().startsWith("kennel")).map(item -> {
						RestRenewPaymentItem pi = new RestRenewPaymentItem();
						pi.setId(item.getId());
						pi.setName(item.getName());
						pi.setPrice(StringUtils.isBlank(item.getPrice()) ? BigDecimal.ZERO
								: new BigDecimal(item.getPrice()));
						pi.setShortName(item.getShortName());
						return pi;
					}).collect(Collectors.toList());
			BigDecimal kennelTotalPrice = kennelItems.stream().map(RestRenewPaymentItem::getPrice)
					.reduce(BigDecimal.ZERO, BigDecimal::add);
			result.getKennel().setItemTotalPrice(kennelTotalPrice);
			result.getKennel().setPaymentItems(kennelItems);
			result.setTotalPrice(result.getTotalPrice().add(kennelTotalPrice));
		}
		result.setRenewType(memberRenewType.toString());
		result.setCardType(UserUtils.getMemberCardType(member));
		return result;
	}

	public PaymentCart buildPaymentCart(Member po, String shortName, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("sys_member");
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	public PaymentCart buildPaymentCart(PaymentChargingItem paymentChargingItem, String businessId,
			String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("sys_member");
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessIds(businessId);
		return paymentCart;
	}

	public PaymentCart buildKennelPaymentCart(PaymentChargingItem paymentChargingItem, String businessId,
			String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("kennel");
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessIds(businessId);
		return paymentCart;
	}

	/**
	 * 身份证号查询会员
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日上午10:32:28
	 */
	public RESTResponse searchMemberByCardNo(HttpServletRequest request) {
		String cardNo = request.getParameter("card_no");
		if (StringUtils.isBlank(cardNo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号不能为空");
		}
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		Object isValid = memberService.getByCardNo(cardNo, loginServer.getMemberSite());
		return new RESTResponse("data", JSONObject.fromObject(isValid));
	}

	/**
	 * 生成会员
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日下午7:14:43
	 */
	@Transactional(readOnly = false)
	public RESTResponse save(String json) {
		// 获取参数
		RestMember vo = BeanUtil.toBean(json, RestMember.class);
		;
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		Member po = buildPo(vo);
		// 业务校验
		memberService.validateBusiness(po);
		// 写入业务表
		memberService.save(po);
		// 写入购物车
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCartService.addToCart(paymentCart, "1021");
		Map<String, String> map = new HashMap<String, String>();
		map.put("memberCode", po.getMemberCode());
		map.put("cartIds", paymentCart.getId());
		return new RESTResponse("data", JSONObject.fromObject(map));
	}

	/**
	 * 写入购物车
	 * 
	 * @Author chaixueteng
	 * @2016年9月25日上午11:11:41
	 */
	private PaymentCart buildPaymentCart(Member po) {
		// 得到会员的收费项 基础会员 依旧是基础费用 专业会员 失效 则缴纳初次注册专业注册费
		String payItem = memberService.getPayItem(po);
		// 业务查重
		PaymentCart paymentCart = new PaymentCart();
		// List<PaymentCart> paymentCartList = paymentCartService.getMyCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(payItem);
		/*
		 * for(PaymentCart cart:paymentCartList){
		 * if(paymentChargingItem.getId().equals(cart.getChargingItemId())){ throw new
		 * ZAException(ZAErrorCode.ZA_VALID_FAILED,"购物车已有相同订单，请勿重复提交"); } }
		 */
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		// 预备美容师会员费用
		String price = paymentChargingItem.getPrice();
		paymentCart.setPrice(price);
		paymentCart.setTotalPrice(price);
		paymentCart.setBusinessTable("sys_member");
		paymentCart.setBusinessOrderCode(IdGen.uuid());
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	/**
	 * 构建持久对象
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日下午7:23:27
	 */
	private Member buildPo(RestMember vo) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Member member = new Member();
		try {
			member.setBirthday(sdf.parse(vo.getBirthday()));
		} catch (Exception e) {
			e.printStackTrace();
		}
		member.setName(vo.getName());
		member.setEmail(vo.getEmail());
		member.setGender(vo.getGender());
		member.setMobile(vo.getMobile());
		member.setPhone(vo.getPhone());
		member.setFax(vo.getFax());
		member.setGroomerType("reserve");
		member.setCardNo(vo.getCardType());
		member.setPostcode(vo.getPostcode());
		member.setProvince(vo.getProvince());
		member.setCity(vo.getCity());
		member.setStreet(vo.getStreet());
		member.setQq(vo.getQq());
		return member;
	}

	/**
	 * 会员参数校验
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日下午2:30:31
	 */
	private void validateParameter(RestMember vo) {
		String name = vo.getName();// 姓名
		if (StringUtils.isBlank(name)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "姓名为空");
		}
		String gender = vo.getGender();// 性别
		if (StringUtils.isBlank(gender)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "性别为空");
		}
		if (!gender.equals("male") && !gender.equals("female")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "用户的性别格式不正确");
		}
		String birthday = vo.getBirthday();// 身份证号
		if (StringUtils.isBlank(birthday)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期为空");
		}
		String cardNo = vo.getCardNo();// 身份证号
		if (StringUtils.isBlank(cardNo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份证号为空");
		}
		String postcode = vo.getPostcode();// 邮编
		if (StringUtils.isBlank(postcode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮编为空");
		}
		String province = vo.getProvince();// 省
		if (StringUtils.isBlank(province)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "省为空");
		}
		String city = vo.getCity();// 市
		if (StringUtils.isBlank(city)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "市为空");
		}
		String street = vo.getStreet();// 街道
		if (StringUtils.isBlank(street)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "街道为空");
		}
		String email = vo.getEmail();// 邮箱
		if (StringUtils.isBlank(email)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮箱为空");
		}
		String phone = vo.getPhone();// 移动电话
		if (StringUtils.isBlank(phone)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "移动电话为空");
		}
		String mobile = vo.getMobile();// 固定电话
		if (StringUtils.isBlank(mobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "固定电话为空");
		}
		String fax = vo.getFax();// 传真电话
		if (StringUtils.isBlank(fax)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "传真电话为空");
		}
		String qq = vo.getQq();// qq
		// String startDate=vo.getString("avatar");//证件照
		if (StringUtils.isBlank(qq)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "qq为空");
		}
		String paymentInfo = vo.getPaymentInfo();// 缴费详情
		if (StringUtils.isBlank(paymentInfo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缴费详情为空");
		}
		String groomerRemarks = vo.getGroomerRemarks();// 备注
		if (StringUtils.isBlank(groomerRemarks)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "美容师备注为空");
		}

	}

	public RESTResponse getByQRCode(HttpServletRequest request) {
		User user = UserUtils.getLoginUser();
		// 白名单校验
		if (user == null || StringUtils.isBlank(user.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "token无效");
		}
		if (!whitelistService.isInWhitelist(null, user.getId(), WhitelistModule.SCAN_QRCODE.getValue())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该用户没有权限");
		}
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
		}
		JSONObject jo = new JSONObject();
		String avatar = "";
		if (StringUtils.isNotBlank(member.getAvatar())) {
			avatar = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
					+ request.getContextPath() + "/api/v1/file/image/" + member.getAvatar();
		}
		jo.put("avatar", getString(avatar));

		jo.put("name", getString(member.getName()));
		jo.put("gender", DictUtils.getDictLabel(member.getGender(), "user_gender", ""));
		String age = "";
		if (member.getBirthday() != null) {
			age = getAge(member.getBirthday());
		}
		jo.put("age", age);
		// 如果身份证号码长度为18位，性别和年龄根据身份证号码得出
		if (StringUtils.isNotBlank(member.getCardNo()) && member.getCardNo().length() == 18) {
			jo.put("gender", Integer.parseInt(member.getCardNo().substring(16, 17)) % 2 == 0 ? "女" : "男");
			try {
				member.setBirthday(DateUtils.parseDate(member.getCardNo().substring(6, 14), "yyyyMMdd"));
			} catch (ParseException e) {

			}
			jo.put("age", getAge(member.getBirthday()));
		}
		String memberType = "";
		if (MemberType.basic.toString().equals(member.getMemberType())) {
			memberType = "基础会员";
		} else if (MemberType.professional.toString().equals(member.getMemberType())) {
			memberType = "专业会员";
		} else if (MemberType.professional.toString().equals(member.getMemberType())
				&& "1".equals(member.getRegisterFlag())) {
			memberType = "繁育专业会员";
		}

		jo.put("memberType", memberType);
		String groomerType = "";
		if ("formal".equals(member.getGroomerType())) {
			groomerType = "正式会员";
		} else if ("reserve".equals(member.getGroomerType())) {
			groomerType = "预备会员";
		}
		jo.put("groomerType", groomerType);
		String memberEndDate = "";
		if (member.getMemberEndDate() != null) {
			memberEndDate = DateUtils.formatDate(member.getMemberEndDate(), "yyyy-MM-dd");
			Calendar memberEndDateCalendar = Calendar.getInstance();
			memberEndDateCalendar.setTime(member.getMemberEndDate());
			memberEndDateCalendar.add(Calendar.DATE, 1);
			if (memberEndDateCalendar.getTimeInMillis() < System.currentTimeMillis()
					&& member.getGroomerEndDate() != null) {
				Calendar groomerEndDateCalendar = Calendar.getInstance();
				groomerEndDateCalendar.setTime(member.getGroomerEndDate());
				groomerEndDateCalendar.add(Calendar.DATE, 1);
				if (groomerEndDateCalendar.getTimeInMillis() > System.currentTimeMillis()) {
					memberEndDate = DateUtils.formatDate(member.getGroomerEndDate(), "yyyy-MM-dd");
				}
			}
		}
		jo.put("memberEndDate", memberEndDate);
		String memberState = "";
		if ("1".equals(member.getPaymentState())) {
			memberState = "无效";
		} else if ("2".equals(member.getPaymentState())) {
			memberState = "有效";
		}
		jo.put("memberState", memberState);
		String banEndDate = "";
		if (member.getBanEndDate() != null) {
			banEndDate = DateUtils.formatDate(member.getBanEndDate(), "yyyy-MM-dd");
		}
		jo.put("banEndDate", banEndDate);
		String banState = "有效";
		if (member.getBanEndDate() != null) {
			Calendar banEndDateCalendar = Calendar.getInstance();
			banEndDateCalendar.setTime(member.getBanEndDate());
			banEndDateCalendar.add(Calendar.DATE, 1);
			if (banEndDateCalendar.getTimeInMillis() > System.currentTimeMillis()) {
				banState = "禁止报名";
			}
		}
		jo.put("banState", banState);
		String freezeFlag = "未冻结";
		if ("1".equals(member.getFreezeFlag())) {
			freezeFlag = "已冻结";
		}
		jo.put("freezeFlag", freezeFlag);

		jo.put("memberCode", member.getMemberCode());
		String authentication = "";
		if ("1".equals(member.getAuthentication())) {
			authentication = "已认证";
		}
		jo.put("authentication", authentication);
		jo.put("cardNo", getString(member.getCardNo()));
		jo.put("safeMobile", getString(member.getSafeMobile()));
		return new RESTResponse(jo);
	}

	private String getAge(Date birthdayDate) {
		Calendar now = Calendar.getInstance();
		now.setTimeInMillis(System.currentTimeMillis());
		Calendar birthday = Calendar.getInstance();
		birthday.setTime(birthdayDate);
		int year = now.get(Calendar.YEAR) - birthday.get(Calendar.YEAR);
		birthday.add(Calendar.YEAR, year);
		if (birthday.getTimeInMillis() > now.getTimeInMillis()) {
			year--;
		}
		return year + "岁";
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}
}