/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DogTypeShow;
import com.cku.oa.dog.service.BusinessBanService;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.DogTypeShowService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ChildShowsService;
import com.cku.oa.show.service.MainShowsService;
import com.cku.oa.show.service.ShowApplyDiscountService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.dog.model.RestDog;
import com.cku.restful.v1.show.model.RestChildShows;
import com.cku.restful.v1.show.model.RestMainShows;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.dao.DictDao;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 犬展报名表Service
 *
 * @author lgl
 * @version 2016-07-15
 */
@Service
@Transactional(readOnly = true)
@Slf4j
public class RestShowApplyService {
	private static final String DOG_SHOW_COUPON = "sys_coupon@show";
	private static final String DOG_SHOW_COUPON_ZZ = "sys_coupon@show_zz";// 郑州办公室
	private static final String DOG_SHOW_COUPON_CQ = "sys_coupon@show_cq";// 重庆办公室
	private static final String DOG_SHOW_COUPON_HZ = "sys_coupon@show_hz";// 杭州办公室
	private static final String DOG_SHOW_COUPON_CS = "sys_coupon@show_cs";// 长沙办公室
	private static final String DOG_SHOW_COUPON_BJ = "sys_coupon@show_bj";// 北京办公室
	private static final String DOG_SHOW_COUPON_CC = "sys_coupon@show_cc";// 长春办公室
	private static final String DOG_SHOW_COUPON_NF = "sys_coupon@show_nf";// 南方区
	private static final String DOG_SHOW_COUPON_BF = "sys_coupon@show_bf";// 北方区
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private DogService dogService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogTypeShowService dogTypeShowService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private BusinessBanService businessBanService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	public DictDao DictDao;
	@Autowired
	private HandlerQualificationCertificateDao handlerQualificationCertificateDao;
	@Autowired
	private ShowApplyDiscountService showApplyDiscountService;

	// 该规则到2019-04-01
	private static final ImmutableMap<String, Double> SHOW_ID_PRICE_MAP = ImmutableMap.<String, Double>builder()
			.put("e5c9d88210db411a8fcc5d1a20be0058", new Double(420))
			.put("b2f9ce081cdb48c181caa259f0d75e51", new Double(350))
			.put("37383f374eea492faba0fea1943736ff", new Double(420))
			.put("de1e0e55e32f4ce3a436779b3a44c929", new Double(350))
			.put("cdf441091ba24de6ab55123aec0cc748", new Double(540))
			.put("a4faf6ecffba413d9eb69ce864c00c21", new Double(540)).build();
	private static final ImmutableList<String> DISCOUNTS_AGE_GROUPS = ImmutableList.<String>builder().add("1").add("2")
			.add("3").add("4").build();
	public static Long DISCOUNTS_END_DATE_TIME_MILLIS = null;
	// 从2019-10-25日起，CAC及CACIB的特幼组、幼小组的犬只报名费变为150元。
	public static Long TYZYXZBMF_START_DATE_TIME_MILLIS = null;
	public static Long SHOW_START_DATE_TIME_MILLIS = null;

	static {
		try {
			String data = Global.getConfig("SJBYQJG_DATE");
			if (StringUtils.isBlank(data))
				data = "2019-04-02";
			DISCOUNTS_END_DATE_TIME_MILLIS = new SimpleDateFormat("yyyy-MM-dd").parse(data).getTime();
			data = Global.getConfig("TYZYXZBMF_DATA_TIME");
			if (StringUtils.isBlank(data))
				data = "2019-10-25 00:00:00";
			TYZYXZBMF_START_DATE_TIME_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(data).getTime();
		} catch (ParseException e) {
			System.out.println("判断新旧业务记录格式化时间出错,请配置SJBYQJG_DATE指定活动 幼犬价格优惠截止日期2019-04-02 不包括当日");
		}
	}
	// 该规则到2019-04-01

	public RESTResponse getDogappraisalMain(HttpServletRequest request) {
		// 获取参数
		String showLocation = request.getParameter("showLocation");
		String mainShowName = request.getParameter("mainShowName");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		// 获取当前时间X天前的时间
		// Calendar calendar = Calendar.getInstance();
		// List<MainShows> mainShowsList =
		// mainShowsDao.findDogAppraisalMainShows(showLocation, mainShowName,
		// DogAppraisalService.SHOW_APPRAISAL_BEFORE_DAY, (pageNoInt - 1) * pageSizeInt,
		// pageSizeInt);
		// long count = mainShowsDao.countDogAppraisalMainShows(showLocation,
		// mainShowName, DogAppraisalService.SHOW_APPRAISAL_BEFORE_DAY);
		// List<RestMainShows> list = new ArrayList<RestMainShows>();
		// SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		// for (MainShows mainShows : mainShowsList) {
		// RestMainShows vo = new RestMainShows();
		// BeanUtil.copyProperties(vo, mainShows, "yyyy-MM-dd");
		// //在截止日期的基础上加X天
		// calendar.setTime(mainShows.getStartTime());
		// calendar.add(Calendar.DATE, -DogAppraisalService.SHOW_APPRAISAL_BEFORE_DAY);
		// vo.setClosingTime(sdf.format(calendar.getTime()) + " 00:00:00");
		// list.add(vo);
		// }
		// 按照报名时间查询
		List<MainShows> mainShowsList = mainShowsDao.findDogAppraisalMainShows(showLocation, mainShowName,
				DogAppraisalService.SHOW_APPRAISAL_BEFORE_DAY, (pageNoInt - 1) * pageSizeInt, pageSizeInt);
		long count = mainShowsDao.countDogAppraisalMainShows(showLocation, mainShowName,
				DogAppraisalService.SHOW_APPRAISAL_BEFORE_DAY);
		List<RestMainShows> list = new ArrayList<RestMainShows>();
		for (MainShows mainShows : mainShowsList) {
			RestMainShows vo = new RestMainShows();
			// BeanUtil.copyProperties(vo, mainShows, "yyyy-MM-dd");
			vo.setClosingTime(com.thinkgem.jeesite.common.utils.DateUtils.formatDateTime(mainShows.getClosingTime()));
			vo.setShowLocation(mainShows.getShowLocation());
			vo.setMainShowName(mainShows.getMainShowName());
			vo.setId(mainShows.getId());
			vo.setStartTime(com.thinkgem.jeesite.common.utils.DateUtils.formatDate(mainShows.getStartTime()));
			vo.setEndTime(com.thinkgem.jeesite.common.utils.DateUtils.formatDate(mainShows.getEndTime()));
			vo.setDogNumMax(mainShows.getDogNumMax());
			String addr = mainShows.getShowLocation().contains("-") ? mainShows.getShowLocation().split("-")[0]
					: mainShows.getShowLocation();

			vo.setShowAddress(addr);
			list.add(vo);
		}
		return new RESTResponse("list", new PageBeanResult<RestMainShows>(list, count));
	}

	public RESTResponse getMain(HttpServletRequest request) {
		// 获取参数
		String showLocation = request.getParameter("showLocation");
		String mainShowName = request.getParameter("mainShowName");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		List<MainShows> mainShowsList = mainShowsDao.findUnCloseMainShows(showLocation, mainShowName, new Date(),
				(pageNoInt - 1) * pageSizeInt, pageSizeInt);
		List<RestMainShows> list = new ArrayList<RestMainShows>();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		for (MainShows mainShows : mainShowsList) {
			RestMainShows vo = new RestMainShows();
			BeanUtil.copyProperties(vo, mainShows, "yyyy-MM-dd");
			vo.setClosingTime(sdf.format(mainShows.getClosingTime()));
			list.add(vo);
		}
		long count = mainShowsDao.countUnCloseMainShows(showLocation, mainShowName, new Date());
		return new RESTResponse("list", new PageBeanResult<RestMainShows>(list, count));
	}

	public RESTResponse getChild(HttpServletRequest request) {
		// 获取参数
		String mainShowId = request.getParameter("mainShowId");
		// 参数校验
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展id为空");
		}
		List<ChildShows> childShowsList = childShowsService.findChildShowsByMainShowId(mainShowId);
		List<RestChildShows> list = new ArrayList<RestChildShows>();
		for (ChildShows childShows : childShowsList) {
			// 去掉id为720e92783d5e43ad8573a3c6da39e3e9，名称为2017年CKU西藏獒犬单独展 10月6日的子犬展
			if ("720e92783d5e43ad8573a3c6da39e3e9".equals(childShows.getId())) {
				continue;
			}
			RestChildShows vo = new RestChildShows();
			BeanUtil.copyProperties(vo, childShows, "yyyy-MM-dd");
			list.add(vo);
		}
		return new RESTResponse("list", new PageBeanResult<RestChildShows>(list, (long) childShowsList.size()));
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String showCodes = request.getParameter("showCodes");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String ageGroupJson = request.getParameter("ageGroupJson");
		JSONObject jo = new JSONObject();
		jo.put("price", getPrice(showCodes, pedigreeCertified, ageGroupJson));
		return new RESTResponse("data", jo);
	}

	public RESTResponse appGetPrice(HttpServletRequest request) throws Exception {
		// 获取参数
		String showIdAgeGroups = request.getParameter("showIdAgeGroup");
		String couponNum = request.getParameter("couponNum");
		String pedigreeCertified = request.getParameter("pedigreeNum");
		if (StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号为空");
		}
		String[] showIdAgeGroup = showIdAgeGroups.split(",");
		String[] showIdArray = new String[showIdAgeGroup.length];
		HashMap<String, String> map = new HashMap<String, String>();
		StringBuilder sb = new StringBuilder();
		for (int i = 0, len = showIdAgeGroup.length; i < len; i++) {
			String[] showIdAgeGroupArray = showIdAgeGroup[i].split("=");
			showIdArray[i] = showIdAgeGroupArray[0];
			map.put(showIdAgeGroupArray[0], showIdAgeGroupArray[1]);
			sb.append(showIdAgeGroupArray[0]).append(",");
		}
		// 该规则到2019-04-01
		List<String> discountsChildShowIdList = Lists.newArrayList();
		if (System.currentTimeMillis() < DISCOUNTS_END_DATE_TIME_MILLIS) {
			String[] array = showIdAgeGroups.split(",");
			for (String s : array) {
				String[] a = s.split("=");
				// 年龄组别在1,2,3,4里且在特定的子犬展里，优惠
				if (DISCOUNTS_AGE_GROUPS.contains(a[1]) && SHOW_ID_PRICE_MAP.containsKey(a[0])) {
					discountsChildShowIdList.add(a[0]);
				}
			}
		}
		List<BigDecimal> canUseCouponPriceList = new ArrayList<>();// 该规则到2019-04-01
		
		// 本次报名是否满减优惠
		if(showApplyService.isUnpaidShowApply(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前犬主名下犬只已有未缴费的犬展订单，请先处理。");
		}
		boolean isDiscount = showApplyDiscountService.isDiscount(pedigreeCertified, map);
		String mainShowId  = showApplyDiscountService.getMainShowId(showIdArray[0]);
		Set<String> set = showApplyDiscountService.getDiscountChildShowsId(mainShowId);// 所有参与优惠的子犬展
		
		double totalFee = 0;
		JSONArray childShowsArray = new JSONArray();
		for (String showId : showIdArray) {
			ChildShows childShows = childShowsService.get(showId);
			JSONObject jo = new JSONObject();
			//有特殊符号，转成unicode编码,前端展示
			jo.put("showName", StringEscapeUtils.unescapeHtml4(childShows.getShowName()));
			String fee = childShows.getFee();
			if (discountsChildShowIdList.contains(childShows.getId())) {
				fee = SHOW_ID_PRICE_MAP.get(childShows.getId()).toString();
			}
			// 从2019-10-25日起，对于CAC及CACIB赛制，如果参展犬只组别为特幼组、幼小组，报名费为150元。
			SHOW_START_DATE_TIME_MILLIS = childShows.getStartTime().getTime();
			if (SHOW_START_DATE_TIME_MILLIS >= TYZYXZBMF_START_DATE_TIME_MILLIS) {
				// UPDATE BY ZJW 2021-07-01 单独展，幼小组（6-9月龄） 收费标准调整，不在优惠为 150
				// TAPD  【ID1003980】关于更改单独展4-6月龄报名费
				if("1".equals(childShows.getShowRules()) && (map.get(showId).equals("3") || map.get(showId).equals("4"))) {
					//如果是单独展，幼小组不做处理
				}else if (map.get(showId).equals("1") || map.get(showId).equals("2") || map.get(showId).equals("3")
						|| map.get(showId).equals("4")) {
					fee = "150.00";
				}
			}
			jo.put("ageGroup", DictUtils.getDictLabel(map.get(showId), "show_age_group", ""));
			//本场是否符合满减优惠
			if(isDiscount && set.contains(showId)) {
				fee = "0.00";
			}
			jo.put("fee", fee);
			if ("0".equals(childShows.getUseCoupon())) {
				canUseCouponPriceList.add(new BigDecimal(fee));
			}
			childShowsArray.add(jo);
			totalFee += Double.parseDouble(fee);
		}
		// 根据犬展最大金额抵扣优惠券金额
		if (StringUtils.isNotBlank(couponNum) && Integer.valueOf(couponNum) > 0
				&& !CollectionUtils.isEmpty(canUseCouponPriceList)) {
			Collections.sort(canUseCouponPriceList);
			Collections.reverse(canUseCouponPriceList);
			totalFee = new BigDecimal(totalFee).subtract(canUseCouponPriceList.stream().findFirst().get())
					.doubleValue();
		}

		JSONObject jo = new JSONObject();
		jo.put("childShowsArray", childShowsArray);
		jo.put("price", totalFee);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 返回犬展订单价格字符串
	 * @author: laiguanglong
	 * @date: 2016年10月17日 上午10:13:26
	 */
	private String getPrice(String showCodes, String pedigreeCertified, String ageGroupJson) {
		// 参数校验
		if (StringUtils.isBlank(showCodes)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬展编号为空");
		}
		double totalFee = 0;
		String[] childShowIdArray = ageGroupJson.split(",");
		// 2018-11-29增加世界杯犬展9月龄下报名费不变规则
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		for (int i = 0; i < childShowIdArray.length; i++) {
			String childShowIdAndAgeGroup = childShowIdArray[i];
			String childShowId = childShowIdAndAgeGroup;
			String ageGroup = childShowIdAndAgeGroup;
			if (childShowIdAndAgeGroup.contains("=")) {
				childShowId = childShowIdAndAgeGroup.split("=")[0];
				ageGroup = childShowIdAndAgeGroup.split("=")[1];
			}
			ChildShows childShows = childShowsService.get(childShowId);
			String fee = childShows.getFee();
			if (dog != null && !StringUtils.isBlank(dog.getId())) {
				int monthAge = getMonthAge(childShows.getStartTime(), dog.getBirthdate());
				if (monthAge < 9) {
					String tempFee = showApplyService.getFeeByShow(childShows.getId());
					fee = StringUtils.isBlank(tempFee) ? fee : tempFee;
				}
				// 特幼幼小组报名费固定150
				if (Integer.parseInt(ageGroup) <= 4) {
					fee = "150";
				}
			}
			totalFee += Double.parseDouble(fee);
		}
		return totalFee + "";
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) throws Exception {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		ShowApply vo = BeanUtil.toBean(json, ShowApply.class);
		// 参数校验
		validateParameter(vo);
		// 业务校验
		ShowApply po = buildShowApply(vo, member);
		po.setNowCouponNum(vo.getNowCouponNum());// 保存是否是否用优惠卷及数量
		// 写入业务表
		showApplyService.saveShowApply(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		Dog dog = dogService.getByPedigreeCertifiedCode(po.getPedigreeCertified());
		PaymentCart paymentCart = buildPaymentCart(po, vo.getShowCode(), businessOrderCode, dog);
		String businessId = getBusinessIdByShowApply(po);
		paymentCartService.addToCart(paymentCart, businessId);

		// 构造犬展参展券购物车
		if (StringUtils.isNotBlank(vo.getNowCouponNum())) {
			String useCouponNum = vo.getNowCouponNum();
			int num = Integer.parseInt(useCouponNum);
			if (num > 0) {// 使用参展劵 构造购物车及参展劵使用详情
				sysCouponService.buildCouponState(dog, po, num);
				PaymentCart paymentCouponCart = buildCouponPaymentCart(po, dog, businessOrderCode, num);
				paymentCartService.addToCart(paymentCouponCart, businessId);
				return new RESTResponse("data", paymentCart.getId() + "," + paymentCouponCart.getId());
			}
		}
		return new RESTResponse("data", paymentCart.getId());
	}

	private String getBusinessIdByShowApply(ShowApply showApply) {
		MainShows show = mainShowsService.get(showApply.getMainShowId());
		String organizer = show.getOrganizer();
		switch (organizer) {
		// 北京
		case "1":
			return "1027";
		// 杭州
		case "2":
			return "1036";
		// 长春
		case "3":
			return "1030";
		// 重庆
		case "4":
			return "1039";
		// 长沙
		case "5":
			return "1033";
		// 郑州
		case "6":
			return "1042";
		// 南方
		case "7":
			return "1070";
		// 北方
		case "8":
			return "1073";
		default:
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "举办城市错误，请联系管理员");
		}

	}

	/**
	 * @description: 构造参展劵收费项
	 * @author: zhangxiang
	 * @date: 2019/2/14 10:21
	 */
	private PaymentCart buildCouponPaymentCart(ShowApply showApply, Dog dog, String businessOrderCode, int num) {
		// 判断子犬展是否可以使用
		ArrayList<Integer> noUseList = Lists.newArrayList();
		String[] showCodeArray = showApply.getShowCode().split(",");
		for (int i = 0; i < showCodeArray.length; i++) {
			String showCode = showCodeArray[i];
			ChildShows childShows = childShowsService.getByShowCode(showCode);
			if (childShows.getUseCoupon().equals("1")) {
				noUseList.add(i);
			}
		}
		// 查询该场犬展的犬展办公室
		PaymentCart paymentCart = new PaymentCart();
		MainShows mainShows = mainShowsDao.get(showApply.getMainShowId());
		String label = DictUtils.getDictLabel(mainShows.getOrganizer(), "show_organizer", "");
		PaymentChargingItem paymentChargingItem = getCouponPaymentChargingItem(label);
		if (paymentChargingItem == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "获取CAC犬展免费参展券失败！");
		}
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum(num + "");
		// 如果年龄组别中有成犬则金额为280，如只有特幼和幼小则金额为150
		String price = "-150";
		ArrayList<String> ageList = new ArrayList<>(Arrays.asList(showApply.getAgeGroup().split(",")));
		Collections.reverse(noUseList);
		for (int i : noUseList) {
			ageList.remove(i);
		}
		for (String age : ageList) {
			if (Integer.parseInt(age) > 4) {
				price = paymentChargingItem.getPrice();
			}
		}
		paymentCart.setPrice(price);
		double priceDouble = Double.parseDouble(price);
		paymentCart.setTotalPrice(priceDouble * num + "");
		paymentCart.setBusinessTable("show_apply");
		paymentCart.setBusinessIds(showApply.getId() + "#" + dog.getPedigreeCertifiedCode());
		paymentCart.setCouponNum(num + "");
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCart;
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(ShowApply vo) {
		if (StringUtils.isBlank(vo.getShowCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬展编号为空");
		}
		if (StringUtils.isBlank(vo.getPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		if (StringUtils.isBlank(vo.getAgeGroup()) && StringUtils.isBlank(vo.getAgeGroupJson())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "年龄组别为空");
		}
		if (StringUtils.isBlank(vo.getHandlerMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "牵犬师会员号为空");
		}
		if (StringUtils.isBlank(vo.getBbeFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "BBE组标记位为空");
		}
		if (!"0".equals(vo.getBbeFlag()) && !"1".equals(vo.getBbeFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "BBE组标记位只能为0或1");
		}
	}

	private ShowApply buildShowApply(ShowApply vo, Member member) {
		// //校验有无犬展的未支付订单
		// List<PaymentOrder> searchApply =
		// paymentOrderDao.searchApply(member.getMemberCode(),"show_apply");
		// if (searchApply.size()>0) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"您有未支付的犬展订单!");
		// }

		// 基本校验
		Dog dog = dogService.getByPedigreeCertifiedCode(vo.getPedigreeCertified());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
		}

		// if(!member.getMemberCode().equals(dog.getMemberCode())){
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"血统证书号有误");
		// }
		ShowApply showApply = new ShowApply();
		showApply.setShowCode(vo.getShowCode());
		showApply.setPedigreeCertified(vo.getPedigreeCertified());
		showApply.setHandlerMemberCode(vo.getHandlerMemberCode());
		Member handler = memberService.getByMemberCode(vo.getHandlerMemberCode());
		if (handler != null) {
			showApply.setRemarks(handler.getName() + " " + handler.getMobile());
		}
		showApply.setDogOwnerNameCn(dog.getDogOwner());
		showApply.setDogOwnerMemberCode(dog.getMemberCode());
		showApply.setAgeGroup(vo.getAgeGroup());
		showApply.setAgeGroupJson(vo.getAgeGroupJson());
		showApply.setBbeFlag(vo.getBbeFlag());
		showApply.setApplyCode("WB");
		showApply.setPaymentMemberCode(member.getMemberCode());
		Member owner = memberService.getByMemberCode(dog.getMemberCode());
		// 2) 被报名犬只犬主人会员需与当前登录会员站点一致
		dog.setDogOwnerSite(owner.getMemberSite());
		// 校验犬只是否能办理当前登录类型的业务
		loginServerService.validDogType(dog);
		showApply.setDogOwnerNameEn(owner.getNameEn());
		String dogBreed = dog.getShowDogBreed();
		if (StringUtils.isBlank(dogBreed)) {
			dogBreed = dog.getDogBreed();
			DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
			if (dogType == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只的犬种" + dogBreed + "无效,请修改犬只犬种后提交。");
			}
			showApply.setFciCode(dogBreed);
			showApply.setDogBreedNameCn(dogType.getBreedCnName());
			showApply.setDogBreedNameEn(dogType.getBreedEnName());
			showApply.setDogBreedGroup(dogType.getTypeGroup());
		} else {
			DogTypeShow dogTypeShow = dogTypeShowService.getByDogShowCode(dogBreed);
			if (dogTypeShow == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只的犬种" + dogBreed + "无效,请修改犬只犬种后提交。");
			}
			showApply.setFciCode(dogBreed);
			showApply.setDogBreedNameCn(dogTypeShow.getShowCnName());
			showApply.setDogBreedNameEn(dogTypeShow.getShowEnName());
			showApply.setDogBreedGroup(dogTypeShow.getTypeGroup());
		}
		showApply.setDogName(dog.getNameEn());
		showApply.setDogGender(dog.getGender());
		showApply.setDogBirthday(dog.getBirthdate());
		showApply.setOtherCertified(dog.getPedigreeCertifiedEn());
		showApply.setBreeder(dog.getBreeder());
		showApply.setDogGeneration(dog.getDogGeneration());
		showApply.setFdogPedigreeCertified(dog.getFdogPedigreeCertified());
		showApply.setChipCode(dog.getIdentificationFlag());
		showApply.setReviewState("0");
		showApply.setProccessState("0");
		showApply.setDelFlag("0");
		Dog fdog = dogService.getByPedigreeCertifiedCode(dog.getFdogPedigreeCertified());
		if (fdog != null) {
			showApply.setFdogName(fdog.getNameEn());
		}
		showApply.setMdogPedigreeCertified(dog.getMdogPedigreeCertified());
		Dog mdog = dogService.getByPedigreeCertifiedCode(dog.getMdogPedigreeCertified());
		if (mdog != null) {
			showApply.setMdogName(mdog.getNameEn());
		}
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(vo.getStickerFlag())) {
//			showApply.setStickerFlag("1");
//		}
		showApply.setStickerFlag("0");
		// 提交上来的优惠劵
		int num = 0;
		List<SysCoupon> sysCouponList = null;
		if (StringUtils.isNotBlank(vo.getNowCouponNum())) {
			String useCouponNum = vo.getNowCouponNum();
			num = Integer.parseInt(useCouponNum);

			SysCoupon sysCoupon = new SysCoupon();
			sysCoupon.setMemberCode(member.getMemberCode());
			sysCoupon.setState("0");// 可用的
			sysCoupon.setTargetId(dog.getPedigreeCertifiedCode());
			sysCouponList = sysCouponService.findList(sysCoupon);
			if (num > 0 && num > sysCouponList.size()) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "可用优惠劵不足");
			}
		}
		return showApply;
	}

	private PaymentCart buildPaymentCart(ShowApply po, String showCodes, String businessOrderCode, Dog dog) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentChargingItemId());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		String price = getPrice(showCodes, po.getPedigreeCertified(), po.getAgeGroupJson());
		paymentCart.setPrice(price);
		paymentCart.setTotalPrice(price);
		paymentCart.setBusinessTable("show_apply");
		// 张向 2019-11-05： po.getId() + "#" + dog.getPedigreeCertifiedCode()
		// 拼接来判断是否使用优惠卷，不可修改此逻辑,因在犬展贴纸支付回调时使用businessIds，进行了相应处理
		paymentCart.setBusinessIds(po.getId() + "#" + dog.getPedigreeCertifiedCode());
		// paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		String businessId = getBusinessIdByShowApply(po);
		return paymentCartService.addBusinessManage(paymentCart, businessId);// 所属业务类型
	}

	/**
	 * @description: 是否包含犬展报名订单，返回true表示包含犬展报名订单
	 * @author: laiguanglong
	 * @date: 2016年11月21日 下午12:15:18
	 */
	public boolean isShowApplyOrder(PaymentOrder order) {
		boolean flag = false;
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.getOrderByRunningNum(order.getOrderCode(),
				order.getMemberCode());
		for (PaymentOrderDetail detail : orderDetailList) {
			PaymentChargingItem item = paymentChargingItemService.get(detail.getChargingItemId());
			if (item.getShortName() != null && item.getShortName().startsWith("show_apply")) {
				flag = true;
				break;
			}
		}
		return flag;
	}

	/**
	 * @description: 犬展报名会员校验 //报名当前账号会员有效 //本场犬展活动是否达到犬只报名数量上限 //判断是否已过报名时间
	 * @author: laiguanglong
	 * @date: 2017/7/25 10:03
	 */
	public RESTResponse showApplyCheck(HttpServletRequest request) {
		// 获取参数
		String mainShowId = request.getParameter("mainShowId");
		// 参数校验
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展id为空");
		}
		MainShows mainShows = mainShowsDao.get(mainShowId);
		if (mainShows == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展id有误");
		}
		boolean showApplyCheckFlag = true;
		String msg = "";
		JSONObject jo = new JSONObject();
		Member member = UserUtils.getLoginMember();
		if (!MemberUtil.isActiveMember(member)) {// 报名当前账号会员有效
			showApplyCheckFlag = false;
			msg = "您当前的会员无效";
		} else if (showApplyService.validateDogNumMax(mainShows)) {// 1)本场犬展活动是否达到犬只报名数量上限
			showApplyCheckFlag = false;
			msg = "本场犬展活动已达到犬只报名数量上限";
		} else if (System.currentTimeMillis() > mainShows.getClosingTime().getTime()) {// 判断是否已过报名时间
			showApplyCheckFlag = false;
			msg = "已过犬展报名截止时间";
		}
		jo.put("showApplyCheckFlag", showApplyCheckFlag);
		jo.put("msg", msg);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 犬展报名会员校验 //报名当前账号会员有效 //本场犬展活动是否达到犬只报名数量上限 //判断是否已过报名时间
	 * @author: laiguanglong
	 * @date: 2017/7/25 10:03
	 */
	public RESTResponse pedigreeCertifiedCodeCheck(HttpServletRequest request) {

		String mainShowId = request.getParameter("mainShowId");
		// 参数校验
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展id为空");
		}
		MainShows mainShows = mainShowsDao.get(mainShowId);
		if (mainShows == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展id有误");
		}

		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		// 参数校验
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		// 查询并组装返回对象
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {
			// 支持根据芯片号进行查询
			// dog = dogService.getByIdentificationFlag(pedigreeCertifiedCode);
			List<Dog> dogs = dogService.getByIdentificationFlagList(pedigreeCertifiedCode);
			if (CollectionUtils.isEmpty(dogs)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
			}
			if(dogs.size() > 1) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号不唯一，请用血统证书申请");
			}
			dog = dogs.get(0);
		}

		// 1) 被报名犬只犬主人会员有效
		Member dogOwnerMember = memberService.getByMemberCode(dog.getMemberCode());
		if (!MemberUtil.isActiveMember(dogOwnerMember)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "被报名犬只犬主人会员无效");
		}
		// 2) 被报名犬只犬主人会员需与当前登录会员站点一致
		dog.setDogOwnerSite(dogOwnerMember.getMemberSite());
		// 校验犬只是否能办理当前登录类型的业务
		loginServerService.validDogType(dog);
		// 3) 被报名犬只犬主人会员不在禁赛期内
		if (showApplyService.suspendStatus(dog.getMemberCode(), mainShows.getStartTime())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该场活动报名不成功，请致电010-53977050");
		}

		// 1) 报名犬只证书号为有效cku血统证书号：犬只状态正常，血统证书号必须以CKU开头
		if (!"0".equals(dog.getDogState()) && !"5".equals(dog.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态异常，无法办理此业务!");
		}
		// 经犬展部确认开启此判断 2021年5月18日16:17:43
		// 犬只状态为已出口
		if ("5".equals(dog.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态为已出口，不允许参加犬展");
		}
		if (!dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号必须以CKU开头!");
		}
		// 5) 犬只的出生日期不能为空
		if (dog.getBirthdate() == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只信息不全，无法报名犬展活动，请联系CKU协会客服处理。");
		}
		// 2) 报名犬只年龄大于等于3个月
		if (getMonthAge(mainShows.getEndTime(), dog.getBirthdate()) < 3) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只月龄不够3个月!");
		}
		// 4)验证犬只犬展禁止字段
		businessBanService.validateShowBan(dog, "该犬为禁止犬展状态");
		// 6) 该犬只不能有未缴费的犬展报名订单
		ShowApply showApply = new ShowApply();
		showApply.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		showApply.setMainShowId(mainShowId);
		if (!showApplyService.noUnpayShowApply(showApply)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有未支付订单");
		}

		// 做版本兼容使用 （新版不验证重复）
		String checkRepeat = request.getParameter("checkRepeat");
		if (StringUtils.isBlank(checkRepeat)) {
			// 该犬不能已有报该场主犬展的记录
			if (showApplyService.repeatApply(showApply)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经报名了这场主犬展");
			}
		}

		RestDog vo = new RestDog();
		BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
		if (StringUtils.isNotBlank(vo.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				vo.setDogBreedName(dogType.getBreedCnName());
			} else {
				vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
			}
		}
		if (StringUtils.isNotBlank(vo.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(vo.getColorFlag());
			if (dogColorMark != null) {
				vo.setColorFlag(dogColorMark.getDogColorMarkCn());
			}
		}
		// 查询优惠卷：判断犬主与登陆人是否同会员
		Member member = UserUtils.getLoginMember();
		vo.setCouPonNum("0");
		// 登陆人和犬主不同需要发送短信验证码

		vo.setSmsAuthFlag(!(member.getMemberCode().equals(dog.getMemberCode())));
		if (!member.getMemberCode().equals(dog.getMemberCode())) {
			// 查询可用的参展券
			SysCoupon sysCoupon = new SysCoupon();
			sysCoupon.setMemberCode(dog.getMemberCode());
			sysCoupon.setState("0");// 可用的
			sysCoupon.setTargetId(dog.getPedigreeCertifiedCode());
			List<SysCoupon> sList = sysCouponService.findList(sysCoupon);
			if (sList.size() > 0) {
				vo.setCouPonNum(String.valueOf(sList.size()));
			}

			// 查询犬主手机号
			Member dogMember = memberService.getByMemberCode(dog.getMemberCode());
			vo.setDogOwnerMobile(dogMember.getSafeMobile());
		}
		if(showApplyService.isUnpaidShowApply(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前犬主名下犬只已有未缴费的犬展订单，请先处理。");
		}
		

		return new RESTResponse("data", JSONObject.fromObject(vo));
	}

	/**
	 * @description: 犬展报名牵犬师校验
	 * @author: laiguanglong
	 * @date: 2017/7/25 10:03
	 */
	public RESTResponse handlerCheck(HttpServletRequest request) {
		String memberCode = request.getParameter("memberCode");
		String mainShowId = request.getParameter("mainShowId");
		String apply = request.getParameter("apply");
		apply = apply == null ? "" : apply;
		// 参数校验
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "牵犬师会员号为空");
		}
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬展id为空");
		}
		List<Member> members = memberService.getByMemberCodeAMobile(memberCode);

		if (members == null || members.size() == 0) {
			return new RESTResponse(1, "没有找到任何会员信息");
		} else if (members.size() > 1) {
			return new RESTResponse(1, "该手机号下会员不唯一，请使用会员号查询");
		} else {
			Member member = members.get(0);
			if ("yes".equals(apply) && !StringUtils.isBlank(member.getMemberSite())) {
				return new RESTResponse(1, "没有找到任何会员信息");
			} else {
				showApplyService.validateHandler(member, mainShowId);
				JSONObject object = new JSONObject();
				object.put("memberCode", memberCode);
				object.put("name", member.getName());
				if (member.getMobile() != null && member.getMobile().length() == 11) {
					object.put("mobile",
							member.getMobile().substring(0, 3) + "****" + member.getMobile().substring(7, 11));
				} else {
					object.put("mobile", "");
				}
				return new RESTResponse("data", object);
			}
		}
	}

	/**
	 * @description: 犬展报名申请等级贴纸校验
	 * @author: laiguanglong
	 * @date: 2017/7/25 10:03
	 */
	public RESTResponse stickerCheck(HttpServletRequest request) {
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		// 犬展等级贴纸申请校验
		showApplyService.stickerCheck(identificationFlag);
		return new RESTResponse();
	}

	/**
	 * 计算月龄
	 *
	 * @param date
	 * @param birthdate
	 * @return
	 */
	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}

	/**
	 * @description: 获取报名历史犬只
	 * @author: laiguanglong
	 * @date: 2017/7/25 10:03
	 */
	public RESTResponse getApplyHistory(HttpServletRequest request) {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		List<Dog> dogList = dogDao.getApplyHistory(memberCode, (pageNoInt - 1) * pageSizeInt, pageSizeInt);
		List<JSONObject> list = Lists.newArrayList();
		for (Dog dog : dogList) {
			JSONObject jo = new JSONObject();
			jo.put("img", ImgUtil.getImgUrl(request, dog.getStudDogCoverImgId()));
			jo.put("pedigreeCertifiedCode", getString(dog.getPedigreeCertifiedCode()));
			jo.put("dogBreed", getString(dogTypeService.getBreedCnName(dog.getDogBreed())));
			jo.put("gender", getString(DictUtils.getDictLabel(dog.getGender(), "dog_gender", "")));
			jo.put("nickname", getString(dog.getNickname()));
			jo.put("age", getString(dogService.getAge(dog.getBirthdate())));
			jo.put("nameEn", getString(dog.getNameEn()));
			jo.put("dogOwner", getString(dog.getDogOwner()));
			jo.put("colorFlag", getString(dogColorMarkService.getDogColorMarkCn(dog.getColorFlag())));
			list.add(jo);
		}
		return new RESTResponse("list", new PageBeanResult<>(list, dogDao.getApplyHistoryCount(memberCode)));
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	/**
	 * @description: 获取犬展参展劵收费项
	 * @author: chaixueteng
	 * @date: 2018/4/18 10:50
	 */
	public PaymentChargingItem getCouponPaymentChargingItem(String label) {
		String shortName = getOrganizerName(label);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		return paymentChargingItem;
	}

	/**
	 * @description: 选择该场犬展 办公室相应的业务表名
	 * @author: 张向
	 * @date: 2019/3/7 10:00
	 */
	public String getOrganizerName(String label) {
		String shortName = null;
		if (label.indexOf("郑州") != -1) {
			shortName = DOG_SHOW_COUPON_ZZ;
		} else if (label.indexOf("重庆") != -1) {
			shortName = DOG_SHOW_COUPON_CQ;
		} else if (label.indexOf("杭州") != -1) {
			shortName = DOG_SHOW_COUPON_HZ;
		} else if (label.indexOf("长沙") != -1) {
			shortName = DOG_SHOW_COUPON_CS;
		} else if (label.indexOf("北京") != -1) {
			shortName = DOG_SHOW_COUPON_BJ;
		} else if (label.indexOf("长春") != -1) {
			shortName = DOG_SHOW_COUPON_CC;
		} else if (label.indexOf("南方区") != -1) {
			shortName = DOG_SHOW_COUPON_NF;
		} else if (label.indexOf("北方区") != -1) {
			shortName = DOG_SHOW_COUPON_BF;
		} else {
			shortName = DOG_SHOW_COUPON;
		}
		return shortName;
	}

	/**
	 * @Description： 获取优惠券金额
	 * 
	 * @author: yuanshuai
	 * @date: 2019/10/14 11:04
	 */
	public Map<String, String> getCoupon(String showCodes, String pedigreeCertified, String ageGroupJson) {
		Map<String, String> map = new HashMap<>();
		map.put("couponCount", "0");
		map.put("couponOnePrice", "0");
		map.put("useCoupony", "0");
		map.put("couponName", "");
		map.put("explains", "");
		map.put("useCouponn", "0");
		int useCoupony = 0;// 记录犬展可使用参展卷的
		int useCouponn = 0;// 记录犬展不可使用参展卷的
		Member member = UserUtils.getLoginMember();
		// 参数校验
		if (StringUtils.isBlank(showCodes)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬展编号为空");
		}
		if (StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		// 查询狗信息
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		String[] showCodeArray = showCodes.split(",");
		ArrayList<Integer> noUseList = Lists.newArrayList();
		for (int i = 0; i < showCodeArray.length; i++) {
			String showCode = showCodeArray[i];
			ChildShows childShows = childShowsService.get(showCode);
			if (childShows.getUseCoupon().equals("1")) {
				useCouponn++;
				noUseList.add(i);
			} else {
				useCoupony++;
			}
		}
		if (useCoupony > 0) {
			List<String> ageGroupList = Lists.newArrayList();
			if (StringUtils.isNotBlank(ageGroupJson)) {
				// 查询年龄组别信息
				String[] childShowIdArray = ageGroupJson.split(",");
				for (int i = 0; i < childShowIdArray.length; i++) {
					ageGroupList.add(childShowIdArray[i].split("=")[1]);
				}
			}
			// 查询可用的参展卷
			SysCoupon sysCoupon = new SysCoupon();
			sysCoupon.setMemberCode(member.getMemberCode());
			sysCoupon.setState("0");// 可用的
			sysCoupon.setTargetId(dog.getPedigreeCertifiedCode());
			List<SysCoupon> sList = sysCouponService.findList(sysCoupon);
			if (sList.size() > 0 && member.getMemberCode().equals(dog.getMemberCode())) {// 登陆会员与犬主会员为同一会员
				String price = "150";
				map.put("couponCount", String.valueOf(sList.size()));
				if (!CollectionUtils.isEmpty(ageGroupList)) {
					Collections.reverse(noUseList);
					for (int i : noUseList) {
						ageGroupList.remove(i);
					}
					for (String age : ageGroupList) {
						if (Integer.parseInt(age) > 4) {
							price = sList.get(0).getFacePrice();
						}
					}
				}
				map.put("couponOnePrice", price);
				map.put("couponName", sList.get(0).getCouponName());
				map.put("explains", sList.get(0).getExplains());
				map.put("useCoupony", String.valueOf(useCoupony));
				map.put("useCouponn", String.valueOf(useCouponn));
			}
		}
		return map;
	}

	public RESTResponse isAskQzrz(HttpServletRequest request) {
		String memberCode = request.getParameter("memberCode");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String mainShowId = request.getParameter("mainShowId");
		String showNums = request.getParameter("showNums");
		log.info("=======mainShowId=====" + mainShowId);
		log.info("=======showNums=====" + showNums);
		// 参数校验
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		if (StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "主犬展ID为空");
		}
		if (StringUtils.isBlank(showNums)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "子犬展编号为空");
		}
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		if (Objects.isNull(dog)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只不存在");
		}
		boolean flag = false;
		// 如犬主人是CKU在册牵犬师或牵犬师与犬主人不为同一人，则不弹出当前提示内容。
		if (memberCode.equals(dog.getMemberCode())) {
			List<HandlerQualificationCertificate> list = handlerQualificationCertificateDao.getByMemberCode(memberCode);
			// 如牵犬师与犬主人为同一个会员（会员号相同），且不为CKU在册牵犬师（OA-培训-资格证书管理-资格证书号为空）则弹出当前提示；
			flag = CollectionUtils.isEmpty(list);
		}

		if (flag) {
			if (Objects.isNull(dog.getBirthdate())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只出生日期不正确");
			}
			// add by zjw 2021-05-25 增加年龄限制：犬展活动当日犬只月龄需要大于等于9月龄（报名的所有子犬展中有任意一场满足即可）
			// 根据主犬展查询所有子犬展信息
			List<ChildShows> childShows = childShowsService.findChildShowsByMainShowId(mainShowId);
			if (Objects.isNull(childShows)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "子犬展记录为空");
			}
			List<String> showNumList = Arrays.asList(showNums.split(",")).stream().map(showNum -> showNum.trim())
					.collect(Collectors.toList());
			// 根据用户所选子犬展，过滤出子犬展对象信息
			childShows = childShows.stream().filter(chidlShow -> showNumList.contains(chidlShow.getShowCode().trim())
					&& Objects.nonNull(chidlShow.getStartTime())).collect(Collectors.toList());
			if (Objects.isNull(childShows)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "子犬展编号不正确或犬展日期有误");
			}
			Date maxDate = childShows.stream().map(ChildShows::getStartTime).distinct().max(DateUtils::compareDate)
					.get();
			// 判断 子犬展最小开始日期，犬只是否大于等于9月龄
			flag = !DateUtils.isInXMounth(dog.getBirthdate(), maxDate, 9);
		}

		return new RESTResponse("data", flag);
	}

	public RESTResponse checkSms(HttpServletRequest request) {
		String mobile = request.getParameter("mobile"); // 手机号
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode"); // 血统证书号
		String smsCode = request.getParameter("smsCode");

		if (Global.isDevMode() && "6666".equals(smsCode)) {
			return new RESTResponse();
		}

		SMSChangePassword oldSMS = (SMSChangePassword) CacheUtils.get("dogShowCache",
				"sms_dog_show" + pedigreeCertifiedCode + mobile);
		if (oldSMS == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}

		int time = (int) (300 - (System.currentTimeMillis() - oldSMS.getDate().getTime()) / 1000);
		if (time <= 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}

		if (!smsCode.equals(oldSMS.getKey())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的验证码");
		}

		return new RESTResponse();
	}

	public RESTResponse repeatShowApply(HttpServletRequest request) {
		// 该犬不能已有报该场主犬展的记录
		ShowApply showApply = new ShowApply();
		showApply.setMainShowId(request.getParameter("mainShowId"));
		showApply.setPedigreeCertified(request.getParameter("pedigreeCertifiedCode"));

		if (showApplyService.repeatApply(showApply)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已经报名了这场主犬展");
		}

		return new RESTResponse();
	}
	
}