package com.cku.restful.v1.open;

import com.cku.core.*;
import com.cku.oa.dogsporting.entity.DogSportingDogs;
import com.cku.oa.dogsporting.entity.DogSportingMembers;
import com.cku.oa.dogsporting.service.DogSportingDogsService;
import com.cku.oa.dogsporting.service.DogSportingMembersService;
import com.cku.oa.ipaddress.service.IpAddressService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.restful.v1.dogSporting.RestDogSportingDogs;
import com.cku.restful.v1.dogSporting.RestDogSportingMembers;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_DOG_SPORTING_MEMBER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_REGISTER;

/**
 * @author yuanshuai
 * @date 2021/6/23 14:04
 */
@Controller
@RequestMapping(value = "/api/v1/open/dogSporting")
public class OpenDogSportingController extends BaseRestController {

	@Autowired
	private DogSportingDogsService dogSportingDogsService;
	@Autowired
	private DogSportingMembersService dogSportingMembersService;
	@Autowired
	private IpAddressService ipAddressService;
	@Autowired
	private SMSRemindService smsRemindService;

	@RequestMapping(value = "/verificationCode", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerification(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String mobile = request.getParameter("mobile");
		//ip校验
		String ip = IPLimitUtil.getIpAddr(request);
		// 添加到ipAddress
		ipAddressService.addIpAddress(ip);
		// 验证ip是否在黑名单
		if (ipAddressService.isBlackList(ip)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该ip已列为黑名单，请联系客服，致电400-660-7000");
		}
		//会员是否存在校验
		DogSportingMembers member = dogSportingMembersService.getByMemberMobile(mobile);
		if (member == null || StringUtils.isBlank(member.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此手机号无会员信息，请输入正确的会员手机号");
		}
		smsRemindService.sendVerifyCode(request, mobile, false, TYPE_SMS_DOG_SPORTING_MEMBER);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping(value = "/member", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<RestDogSportingMembers> getMemberInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String mobile = request.getParameter("mobile");
		String key = request.getParameter("key");
		if (smsRemindService.checkVerifyCode(mobile, key)) {
			//会员是否存在校验
			DogSportingMembers member = dogSportingMembersService.getByMemberMobile(mobile);
			if (member == null || StringUtils.isBlank(member.getId())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此手机号无会员信息，请输入正确的会员手机号");
			}
			RestDogSportingMembers restMember = new RestDogSportingMembers();
			BeanUtil.copyProperties(restMember, member, "yyyy-MM-dd");
			//屏蔽直辖市字段
			String[] blockCities = {"北京市", "上海市", "天津市", "重庆市"};
			if (Arrays.stream(blockCities).anyMatch(s -> s.equals(restMember.getCity()))) {
				restMember.setCity(null);
			}
			return ResultDto.success(restMember);
		}
		return ResultDto.error(ZAErrorCode.ZA_ERC_UNKNOWN, "验证码输入错误，请重新输入");
	}

	@RequestMapping(value = "/dogList", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestDogSportingDogs> getDogList(HttpServletRequest request, HttpServletResponse response) {
		//获得参数
		String code = request.getParameter("code");
		String memberCode = request.getParameter("memberCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		//校验参数
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		Page<DogSportingDogs> page = new Page<>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		DogSportingDogs search = new DogSportingDogs();
		search.setCode(code);
		search.setMemberCode(memberCode);
		page = dogSportingDogsService.findPage(new Page<>(request, response), search);
		List<RestDogSportingDogs> resultList = page.getList().stream().map(dog -> {
			RestDogSportingDogs restDog = new RestDogSportingDogs();
			BeanUtil.copyProperties(restDog, dog, "yyyy-MM-dd");
			restDog.setSomatotype(DictUtils.getDictLabel(restDog.getSomatotype(), "dog_somatotype", null));
			return restDog;
		}).collect(Collectors.toList());

		long totalPage = (page.getCount() + page.getPageSize() - 1) / page.getPageSize();

		return PageResultDto.success(resultList, page.getCount(), totalPage);
	}

}
