package com.cku.restful.v1.oauth.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

import com.thinkgem.jeesite.common.utils.CacheUtils;

@Service("oAuthService")
public class OAuthServiceImpl {

	@Autowired
	private OAuth2ClientServiceImpl oAuth2ClientService;
	private String cacheName = "oAuth-token";

	public void addAuthCode(String authCode, String username) {
		CacheUtils.put(cacheName, authCode, username);
	}

	public void addAccessToken(String accessToken, String username) {
		CacheUtils.put(cacheName, accessToken, username);
	}

	public String getUsernameByAuthCode(String authCode) {
		return (String) CacheUtils.get(cacheName, authCode);
	}

	public String getUsernameByAccessToken(String accessToken) {
		return (String) CacheUtils.get(cacheName, accessToken);
	}

	public boolean checkAuthCode(String authCode) {
		return CacheUtils.get(cacheName, authCode) != null;
	}

	public boolean checkAccessToken(String accessToken) {
		return CacheUtils.get(cacheName, accessToken) != null;
	}

	public boolean checkClientId(String clientId) {
		return oAuth2ClientService.selectByClientId(clientId) != null;
	}

	public boolean checkClientSecret(String clientSecret) {
		return oAuth2ClientService.selectByClientSecret(clientSecret) != null;
	}

	public long getExpireIn() {
		return 7200L;
	}
}
