package com.cku.restful.v1.kennel.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.kennel.service.RestKennelRenameService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 犬舍名称变更Controller
 * 
 * @author zhuguanjin
 * @version 2016-08-15
 */
@Controller
@RequestMapping(value = "/api/v1/kennel")
public class RestKennelRenameController extends BaseRestController {

	@Autowired
	private RestKennelRenameService restKennelRenameService;

	@ApiOperation(value = "犬舍名称变更-列表", tags = { "犬舍名称变更-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageSize", value = "展示条数"),
			@ApiImplicitParam(name = "pageNo", value = "当前页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "            \"memberEndTime\":\"\",\n"
			+ "            \"originalNameCn\":\"海润犬舍\", // 原犬舍中文名\n" + "            \"canEdit\":true,\n"
			+ "            \"originalNameEn\":\"Hai Run's Kennel（FCI）\",  // 原犬舍英文名\n"
			+ "            \"memberName\":\"\",\n" + "            \"reviewStateCode\":\"\",\n"
			+ "            \"newNameCn\":\"海润犬舍\",   // 新犬舍中文名\n" + "            \"reviewRemarks\":\"\",\n"
			+ "            \"newNameEn\":\"qweqe\", // 新犬舍英文名\n" + "            \"paymentMemberCode\":\"\",\n"
			+ "            \"price\":\"\",\n" + "            \"id\":\"9bc889e77dc449aeb4cb354eb80a41ff\",\n"
			+ "            \"memberType\":\"\",\n" + "            \"reviewState\":\"待审核\", // 审核状态\n"
			+ "            \"createDate\":\"2019-11-13\" // 时间\n"
			+ "            \"medalFlag\":\"0/1\" 0:未选择 1:选择铜牌 （新增）\n" + "        }\n" + "    ],\n" + "    \"total\":1\n"
			+ "}") })
	@RequestMapping(value = "/kennelrename", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennelrename/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void get(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "犬舍名称变更-提交表单", tags = { "犬舍名称变更-zxy" })
	@ApiImplicitParam(name = "token", paramType = "query", value = "token")
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":\"4bb236aa5935427ea9ce992d1903027c\"\n" + "}\n" + "") })
	@RequestMapping(value = "/kennelrename", method = RequestMethod.POST)
	@ResponseBody
	public void post(
			@ApiParam(name = "json", value = "{\n" + "    \"newNameCn\":\"中文名\",\n" + "    \"newNameEn\":\"英文名\",\n"
					+ "    \"fciKennel\":\"fci名\",\n" + "    \"fciKennelBackup\":\"fci备用名\",\n"
					+ "    \"medalFlag\":\"是否选择铜牌 0:喂选择 1:选择\"\n" + "}\n" + "") 
			@RequestBody String json,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennelrename", method = RequestMethod.PUT)
	@ResponseBody
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/kennelrename/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.getPrice();
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "犬舍名称变更-获取收费价格", tags = { "犬舍名称变更-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "medalFlag", value = "0/1 是否选择铜牌补做 0：未选择 1:选择"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":{\n" + "        \"price\":\"120.0\"\n" + "    }\n" + "}\n" + "") })
	@RequestMapping(value = "/kennelrename/getPriceNew", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restKennelRenameService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月12日 上午10:00:50
	 */
	@RequestMapping(value = "/kennelrename/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restKennelRenameService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @Description：获取犬舍更名详细及审核信息
	 * @author yuanshuai
	 * 
	 * @data 2017年3月16日 下午3:42:22
	 */
	@RequestMapping(value = "/kennelrename/renameState", method = RequestMethod.GET)
	@ResponseBody
	public void renameState(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		RESTResponse result = restKennelRenameService.getRenameDetail(memberCode);
		ServletUtils.writeResponse(response, result);
	}
}