package com.cku.restful.v1.finance.service;

import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly = true)
public class KennelRegisterDeleteService {

	@Autowired
	private KennelDao kennelDao;

	/**
	 //犬舍相关收费项有kennel@ZC、kennel@ND、kennel@YJ
	 //需要根据id查询出该犬舍，并根据犬舍截至日期是否为空判断是否是注册犬舍未缴费的状态
	 //只有犬舍截至日期为空的情况下可以物理删除
	 * @author: laiguanglong
	 * @date: 2017/3/29 10:23
	 */
	public void deleteKennelRegister(String id){
		Kennel kennel = kennelDao.get(id);
		if(kennel!=null&&kennel.getEndTime()==null){
			kennelDao.deleteKennelRegister(id);
		}
	}

	/**
	 //犬舍相关收费项有kennel@ZC、kennel@ND、kennel@YJ
	 //需要根据id查询出该犬舍，并根据犬舍截至日期是否为空判断是否是注册犬舍未缴费的状态
	 //该方法只逻辑删除犬舍。用于订单删除处调用
	 * @author: laiguanglong
	 * @date: 2017/3/29 10:23
	 */
	public void logicDeleteKennelRegister(String id){
		Kennel kennel = kennelDao.get(id);
		if(kennel!=null&&kennel.getEndTime()==null){
			kennelDao.logicDeleteKennelRegister(id);
		}
	}
}