package com.cku.restful.v1.dog.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import com.cku.oa.constant.Constants;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.CouponDivideEquallyDto;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.BusinessBanService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.util.CouponUtils;
import com.cku.util.Debugger;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * Created by lyyz on 2019/6/10.
 * <p>
 * 血统证书 整窝办理服务
 * <p>
 * 此服务 2019年7月1号开始使用
 */
@Service
@Transactional(readOnly = true)
public class RestDogBatchService {
	private static Long ZHENGWOSHENG = null;

	static {
		try {
			ZHENGWOSHENG = new SimpleDateFormat("yyyy-MM-dd").parse("2019-07-01").getTime();
		} catch (ParseException e) {
			System.out.println("整窝生业务记录格式化时间出错");
		}
	}

	@Autowired
	public DogService dogService;
	private static final String BLOOD_SAVE_FEE = "dog_blood_save@New";
	private static final String BLOOD_SAVE_FEE_DX = "dog_blood_save_fee@New";
	private static final String DNA_PARENTS_COMPARE_FEE = "dog_dna_parents_compare@New";

	/**
	 * 第二繁殖人登记服务费
	 */
	private static final String SECOND_BREEDER = "second_breeder@all";
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private RestDogBirthCertificateService restDogBirthCertificateService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

	@Autowired
	public BusinessBanService businessBanService;
	@Autowired
	public DogChipService dogChipService;
	@Autowired
	public PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;

	@Autowired
	public DogNoseService dogNoseService;

	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	private static final Logger logger = LoggerFactory.getLogger(RestDogBatchService.class);

	/**
	 * 根据配种证明编号返回配种信息
	 *
	 * @param request
	 * @return
	 */
	public RESTResponse getByBreedCertifiedCode(HttpServletRequest request) {
		String breedCertifiedCode = request.getParameter("breedCertifiedCode");
		if (StringUtils.isEmpty(breedCertifiedCode))
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "配种编号不能为空");
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(breedCertifiedCode);
		if (dogNewborn == null)
			return new RESTResponse();
		JSONObject j = new JSONObject();
		j.put("breedCertifiedCode", dogNewborn.getBreedCertifiedCode());
		j.put("breedDate", DateUtils.formatDate(dogNewborn.getBreedDate(), "yyyy-MM-dd"));
		j.put("maleDogOwner", dogNewborn.getMaleDogOwner());
		j.put("malePedigreeCertified", dogNewborn.getMalePedigreeCertified());
		j.put("femaleDogOwner", dogNewborn.getFemaleDogOwner());
		j.put("femalePedigreeCertified", dogNewborn.getFemalePedigreeCertified());
		return new RESTResponse("data", j);
	}

	/**
	 * 存储新生登记卡和血统证书
	 *
	 * @param json
	 * @return
	 */
	@Transactional(readOnly = false, propagation = Propagation.REQUIRED)
	public RESTResponse post(String json) {
		if (System.currentTimeMillis() < ZHENGWOSHENG) {
			return new RESTResponse(ZAErrorCode.ZA_VALID_FAILED, "整窝办理功能2019年7月1号开放使用");
		}
		JSONObject vo = JSONObject.fromObject(json);
		String fmdogBreedCertifiedCode = vo.getString("fmdogBreedCertifiedCode");
		String hospitalCode = vo.get("hospitalCode") != null ? vo.getString("hospitalCode") : null;
		String haddleWay = vo.get("haddleWay") != null ? vo.getString("haddleWay") : null;
		String ecertFlag = vo.get("ecertFlag") != null ? vo.getString("ecertFlag") : null;
		if ("1".equals(haddleWay) && StringUtils.isBlank(hospitalCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "办理方式为合作机构办理时，合作机构不能为空");
		}
		// 校验当然登录人是否有效会员
		Member member = UserUtils.getLoginMember();
		// 当前账号会员有效
		if (!MemberUtil.isActiveProfessionalMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前会员不是有效专业会员");
		}
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(fmdogBreedCertifiedCode);
		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号有误");
		}
		if (StringUtils.isBlank(dogNewborn.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只种类不能为空");
		}
		List<DogBirthCertificate> lst = postDogBirthCertificate(vo);
		if (lst == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "生成出生纸失败");
		}

		List<DogChip> lstd = dogChipbuildPo(lst, fmdogBreedCertifiedCode, ecertFlag, hospitalCode, "2", haddleWay);
		if (CollectionUtils.isEmpty(lstd)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "构造血统证书信息失败");
		}

		lstd.forEach(i -> {
			dogChipService.save(i);
		});
		// 获取业务收费项 通用收费项
		List<PaymentChargingItem> lstItem = paymentChargingItemService.getFeesAndCharges();
		String businessOrderCode = IdGen.uuid();
		StringBuilder sb = new StringBuilder();
		int size = lstd.size();
		if (lstItem == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项不存在");
		}
		String secondBreederMemberCode = vo.get("secondBreederMemberCode") != null ? vo.getString("secondBreederMemberCode") : null;;
		if (StringUtils.isNotBlank(secondBreederMemberCode)) {
			PaymentChargingItem secondBreederPaymentCharging = paymentChargingItemService.getByShortName(SECOND_BREEDER);
			if (Objects.nonNull(secondBreederPaymentCharging)) {
				lstItem.add(secondBreederPaymentCharging);
			}
		}
		List<PaymentCart> paymentCartList = new ArrayList<>();

		// 收费项写入购物车
		lstItem.forEach(i -> {
			PaymentCart pc = buildDogBatchPaymentCart(i, size, businessOrderCode, fmdogBreedCertifiedCode);
			paymentCartService.addToCart(pc, "1004");
			sb.append(pc.getId() + ",");
			paymentCartList.add(pc);
		});
		BigDecimal orderTotalPrice = paymentCartList.stream().map(pc -> {
			return new BigDecimal(pc.getTotalPrice());
		}).reduce(BigDecimal.ZERO, BigDecimal::add);
		CouponDivideEquallyDto divideEqually = CouponUtils.divideEqually(lstd.size(), orderTotalPrice);
		for (int k = 0; k < lstd.size(); k++) {
			DogChip dc = lstd.get(k);
			if (k == lstd.size() - 1) {
				dc.setFloatingPrice(divideEqually.getRemainderAmount());
			} else {
				dc.setFloatingPrice(divideEqually.getDivideEquallyAmount());
			}
			dogChipService.updateBusinessPrice(dc);
		}
		return new RESTResponse("data", sb.deleteCharAt(sb.length() - 1).toString());
	}

	private String dnaParentsCompare(List<String> birthCerRegCodes, String businessOrderCode,
			String fmdogBreedCertifiedCode) {
		PaymentChargingItem dnaParentsCompareItem = paymentChargingItemService.getByShortName(DNA_PARENTS_COMPARE_FEE);
		for (String birthCerRegCode : birthCerRegCodes) {
			DogDnaParentsCompare dogDnaParentsCompare = new DogDnaParentsCompare();
			dogDnaParentsCompare.setBirthCode(birthCerRegCode);
			dogDnaParentsCompare.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
			dogDnaParentsCompare.setPrice("0");
			dogDnaParentsCompare.setReviewState("0");
			dogDnaParentsCompare.setPaymentState("1");
			// dogDnaParentsCompare.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			dogDnaParentsCompareService.save(dogDnaParentsCompare);
		}

		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(dnaParentsCompareItem.getId());
		paymentCart.setChargingItemName(dnaParentsCompareItem.getName());
		paymentCart.setNum(birthCerRegCodes.size() + "");
		paymentCart.setPrice(dnaParentsCompareItem.getPrice());
		paymentCart.setTotalPrice(Double.parseDouble(dnaParentsCompareItem.getPrice()) * birthCerRegCodes.size() + "");
		paymentCart.setBusinessTable("dog_dna_parents_compare");
		paymentCart.setBusinessIds(fmdogBreedCertifiedCode);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		PaymentCart dnaParentsCompareCart = paymentCartService.addBusinessManage(paymentCart, "1004");
		paymentCartService.addToCart(dnaParentsCompareCart, "1004");
		return dnaParentsCompareCart.getId();
	}

	/**
	 * 血样留存
	 *
	 * @param birthCerRegCodes
	 * @param businessOrderCode
	 * @param orgId
	 * @param fmdogBreedCertifiedCode
	 * @return
	 */
	private String bloodSave(List<DogBirthCertificate> birthCerRegCodes, String businessOrderCode, String orgId,
			String fmdogBreedCertifiedCode, boolean separateApplication) {
		StringBuilder cartIds = new StringBuilder();
		// 登记服务费(纯种犬DNA样本) dog_blood_save@New
		PaymentChargingItem item = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE);
		String price = item.getPrice();
		PaymentChargingItem itemFree = null;
		if (!separateApplication) {
			// 登记服务费（纯种犬DNA样本）100元，登记服务费（纯种犬DNA样本）减免 100元
			itemFree = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE_DX);
			price = "0";
		}

		for (DogBirthCertificate birthCerRegCode : birthCerRegCodes) {
			DogBloodSave dogBloodSave = new DogBloodSave();
			dogBloodSave.setBirthCode(birthCerRegCode.getBirthCerRegCode());
			dogBloodSave.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
			dogBloodSave.setPrice(price);
			dogBloodSave.setOrgId(orgId);
			dogBloodSave.setPaymentState("1");
			dogBloodSave.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			dogBloodSaveService.save(dogBloodSave);
		}
		// 插入购物车
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(Double.parseDouble(item.getPrice()) * birthCerRegCodes.size() + "");
		paymentCart.setNum(birthCerRegCodes.size() + "");
		// paymentCart.setBusinessTable("dog_blood_save");
		paymentCart.setBusinessIds(fmdogBreedCertifiedCode);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setRemarks("整窝办理");
		PaymentCart bloodSaveCart = paymentCartService.addBusinessManage(paymentCart, "1004");
		paymentCartService.addToCart(bloodSaveCart, "1004");
		cartIds.append(bloodSaveCart.getId()).append(",");
		if (itemFree != null) {
			PaymentCart paymentCart2 = new PaymentCart();
			paymentCart2.setChargingItemId(itemFree.getId());
			paymentCart2.setChargingItemName(itemFree.getName());
			paymentCart2.setPrice(itemFree.getPrice());
			paymentCart2.setTotalPrice(itemFree.getPrice());
			paymentCart2.setNum(birthCerRegCodes.size() + "");
			// paymentCart2.setBusinessTable("dog_blood_save");
			paymentCart2.setBusinessTable("dog_c hip");
			paymentCart2.setRemarks("整窝办理");
			paymentCart2.setBusinessIds(fmdogBreedCertifiedCode);
			paymentCart2.setBusinessOrderCode(businessOrderCode);
			PaymentCart bloodSaveCart2 = paymentCartService.addBusinessManage(paymentCart2, "1004");
			paymentCartService.addToCart(bloodSaveCart2, "1004");
			cartIds.append(bloodSaveCart2.getId()).append(",");
		}
		return cartIds.toString();
	}

	// 点位分析(业务表+收费项)
	private String dnaArchive(List<String> birthCerRegCodes, String businessOrderCode, String orgId,
			String fmdogBreedCertifiedCode) {
		List<PaymentChargingItem> dnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
		Double price = dnaArchiveItems.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();
		for (String birthCerRegCode : birthCerRegCodes) {
			DogDnaArchive dogDnaArchive = new DogDnaArchive();
			dogDnaArchive.setBirthCode(birthCerRegCode);
			dogDnaArchive.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
			if (orgId == null || orgId == "") {
				dogDnaArchive.setOrgId(((Org) UserUtils.getSession().getAttribute("org")).getId());
			} else {
				dogDnaArchive.setOrgId(orgId);
			}
			dogDnaArchive.setPrice(price.toString());
			dogDnaArchive.setReviewState("0");
			dogDnaArchive.setPaymentState("1");
			dogDnaArchive.setProcessState("0");
			dogDnaArchive.setPrintState("0");
			// dogDnaArchive.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			dogDnaArchiveService.save(dogDnaArchive);
		}
		StringBuilder cartIds = new StringBuilder();
		dnaArchiveItems.stream().forEach(dnaArchiveItem->{
			PaymentCart paymentCart = new PaymentCart();
			paymentCart.setChargingItemId(dnaArchiveItem.getId());
			paymentCart.setChargingItemName(dnaArchiveItem.getName());
			paymentCart.setPrice(dnaArchiveItem.getPrice());
			paymentCart.setTotalPrice(Double.parseDouble(dnaArchiveItem.getPrice()) * birthCerRegCodes.size() + "");
			paymentCart.setNum(birthCerRegCodes.size() + "");
			paymentCart.setBusinessTable("dog_dna_archive");
			paymentCart.setBusinessIds(fmdogBreedCertifiedCode);
			paymentCart.setBusinessOrderCode(businessOrderCode);
			PaymentCart dnaArchiveCart = paymentCartService.addBusinessManage(paymentCart, "1004");
			paymentCartService.addToCart(dnaArchiveCart, "1004");
			cartIds.append(",").append( dnaArchiveCart.getId());
		});
		
		return cartIds.toString();
	}

	/**
	 * 购物车模型
	 *
	 * @param item                    当前收费项
	 * @param size                    商品数量
	 * @param businessOrderCode       业务id
	 * @param fmdogBreedCertifiedCode 业务表id
	 * @return
	 */
	private PaymentCart buildDogBatchPaymentCart(PaymentChargingItem item, int size, String businessOrderCode,
			String fmdogBreedCertifiedCode) {
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum(size + "");
		String price = item.getPrice();
		paymentCart.setPrice(price);
		if (Objects.equals(item.getShortName(), SECOND_BREEDER)) {
			paymentCart.setTotalPrice(price);
			paymentCart.setNum(Constants.STRING_NUM_ONE);
		} else {
			paymentCart.setTotalPrice(Double.parseDouble(price) * size + "");
			paymentCart.setNum(size + "");
		}
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCart.setBusinessIds(fmdogBreedCertifiedCode);
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setRemarks("整窝办理");
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * 血统证书模型
	 *
	 * @param lst
	 * @param fmdogBreedCertifiedCode 配种证明编号
	 * @param
	 *
	 * @return
	 */
	private List<DogChip> dogChipbuildPo(List<DogBirthCertificate> lst, String fmdogBreedCertifiedCode,
			String ecertFlag, String clubCode, String dnaSaveWay, String haddleWay) {
		// 合作医院
		Org org = StringUtils.isNotBlank(clubCode) ? orgService.get(clubCode) : null;
		List<DogChip> ld = new ArrayList<>();
		lst.forEach(i -> {
			/*DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByBirthCerRegCode(i.getBirthCerRegCode());
			// dogBirthCertificate.setAddUser(org.getUser().getLoginName());
			dogBirthCertificateService.save(dogBirthCertificate);*/
			DogChip po = new DogChip();
			po.setBirthCode(i.getBirthCerRegCode());
			po.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
			po.setReviewState("0");
			po.setPaymentState("1");
			po.setProcessState("0");
			po.setPrintState("0");
			po.setDnaSaveWay(dnaSaveWay);
			po.setHaddleWay(haddleWay);
			po.setIsAll("1");
			po.setHospitalCode(clubCode);
			if (org != null)
				po.setHospitalName(org.getName());
			po.setIsDnaParentsCompare("0");
			po.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			if (StringUtils.isNotBlank(ecertFlag)) {
				po.setEcertFlag(ecertFlag);

			} else {
				po.setEcertFlag("0");// 电子证书标记位：0否；1是
			}
			po.setCallName(i.getCallName());
			ld.add(po);
		});
		return ld;
	}

	/**
	 * 存储 新生犬登记卡
	 *
	 * @param vo
	 * @return
	 */
	public List<DogBirthCertificate> postDogBirthCertificate(JSONObject vo) {

		// 参数校验
		restDogBirthCertificateService.validateParameter(vo);

		// 构造持久对象
		List<DogBirthCertificate> poList = dogBirthCertificatebuildPo(vo);
		// 业务校验
		validateBusiness(poList);
		List<DogBirthCertificate> lst = new ArrayList<DogBirthCertificate>();
		// 写入业务表
		for (DogBirthCertificate po : poList) {
			lst.add(po);
			dogBirthCertificateService.save(po);
			// 记录鼻纹记录
			if (StringUtils.isNotBlank(po.getNoseId())) {
				// 重复的不阻断，只存对的，临时方案
				String flag = dogNoseService.saveNoseId(po.getNoseId(), po.getId(), null);
				if (flag == null) {
					logger.error("出错请求参数：" + vo);
					logger.error("重复的noseId：" + po.getNoseId());
				}
			}
		}
		return lst;
	}

	public void validateBusiness(List<DogBirthCertificate> poList) {
		DogBirthCertificate po = poList.get(0);
		// 重复订单校验
		DogBirthCertificate example = new DogBirthCertificate();
		example.setFmdogBreedCertifiedCode(po.getFmdogBreedCertifiedCode());
		example.setReviewStateExclud("3");
		List<DogBirthCertificate> list = dogBirthCertificateService.findList(example);
		Member loginMember = UserUtils.getLoginMember();
		if (po.getDogBirthday().after(new Date())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期不能大于当前日期！");
		}
		// 申请人为母犬主校验
		Debugger.doAssert(po.getMemberCode().equals(loginMember.getMemberCode()), ZAErrorCode.ZA_VALID_FAILED,
				"申请人需为母犬主人");

		if (list.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有新生犬登记卡申请订单");
		}
		// 根据犬种判断是否超过一窝最大数
		DogType dogType = dogTypeService.getByDogBreedCode(po.getDogBreed());
		if (Integer.parseInt(dogType.getBatchMaxNum()) < poList.size()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您申请的犬只数量超过申请上限，需联系协会线下提交申请");
		}
		basicValidate1(po);
	}

	/**
	 * @description: 基础业务校验，添加业务表和自动审核都会触发
	 * @author: laiguanglong
	 * @date: 2017/2/7 17:05
	 */
	public void basicValidate1(DogBirthCertificate po) {
		// 校验母犬主为有效专业会员
		dogBirthCertificateService.validateMDogOwner(po.getMemberCode());
		// 校验母犬主为有效犬舍
		dogBirthCertificateService.validateMDogOwnerKennel(po.getMemberCode());
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(po.getFmdogBreedCertifiedCode());
		// 校验配种证明为审核通过
		if (!"1".equals(dogNewborn.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明未通过审核，不允许申请出生证明");
		}
		if (!dogBirthCertificateService.checkDogBirthday(po.getDogBirthday(), dogNewborn)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只出生日期必须为配种后50-70天内");
		}
		if (!dogBirthCertificateService.checkDogBirthday1(po.getDogBirthday(),
				po.getCreateDate() == null ? new Date() : po.getCreateDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生证明需在犬只出生十四个月内申请，逾期无法办理");
		}
		// 业务禁止校验
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(dogNewborn.getMalePedigreeCertified());
		Dog motherDog = dogService.getByPedigreeCertifiedCode(dogNewborn.getFemalePedigreeCertified());
		if ("1".equals(fatherDog.getBusinessBan())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬为禁止繁殖状态，无法办理该业务");
		}
		if ("1".equals(motherDog.getBusinessBan())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬为禁止繁殖状态，无法办理该业务");
		}
	}

	private List<DogBirthCertificate> dogBirthCertificatebuildPo(JSONObject vo) {
		String fbcs = vo.getString("fmdogBreedCertifiedCode");
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(fbcs);
		if (dogNewborn == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明号有误");

		// 冷冻精子配种不允许加急
		if (StringUtils.isNotBlank(dogNewborn.getSemenCode()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "冷冻精子繁殖犬只无法办理整窝登记业务，请选择身份识别登记卡方式继续办理");
		if ("1".equals(dogNewborn.getKinGetDna()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "近亲繁殖犬只无法办理整窝登记业务，请选择身份识别登记卡方式继续办理");

		String dog_kennelName = getKennelName(dogNewborn);// 获取犬舍名字
		JSONArray dogBirthCertificateArray = vo.getJSONArray("dogBirthCertificateArray");

		Date dogBirthday = null;
		try {
			dogBirthday = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getString("dogBirthday"));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期格式不对");
		}
		String sameBatchNum = restDogBirthCertificateService.getSameBatchNum(dogBirthCertificateArray);// X公X母
		List<DogBirthCertificate> poList = new ArrayList<>();
		// 校验第二繁殖人
		String secondBreederMemberCode = "";
		String secondBreeder = "";
		if (vo.get("secondBreederMemberCode") != null) {
			secondBreederMemberCode = vo.getString("secondBreederMemberCode");
			secondBreeder = vo.getString("secondBreeder");
			dogBirthCertificateService.checkSecondBreeder(secondBreederMemberCode);
		}

		for (int i = 0; i < dogBirthCertificateArray.size(); i++) {
			JSONObject dogBirthCertificate = dogBirthCertificateArray.getJSONObject(i);
			DogBirthCertificate po = new DogBirthCertificate();
			// po.setPaymentChargingItem(dogBirthCertificatePaymentChargingItem);
			po.setBirthCerRegCode(SysCodeUtil.getBirthCertificateCode());
			po.setDogGender(dogBirthCertificate.getString("dogGender"));
			String dogEnName = dogBirthCertificate.getString("dogEnName"); // 设置犬名
			po.setDogEnName(dog_kennelName + " " + dogEnName.substring(0, 1).toUpperCase()
					+ dogEnName.substring(1).toLowerCase());
			po.setColorFlag(dogBirthCertificate.getString("colorFlag"));
			if (!dogTypeService.validateColorFlag(dogNewborn.getDogBreed(), po.getColorFlag()))
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬种没有毛色" + po.getColorFlag());

			po.setDogBirthday(dogBirthday);
			po.setFmdogBreedCertifiedCode(fbcs);
			po.setFdogPedigreeCertified(dogNewborn.getMalePedigreeCertified());
			po.setMdogPedigreeCertified(dogNewborn.getFemalePedigreeCertified());
			// 以下都是母犬主人的信息
			po.setDogOwenr(dogNewborn.getFemaleDogOwner());
			po.setMemberCode(dogNewborn.getFdogOwnerCode());
			po.setBreeder(dogNewborn.getFemaleDogOwner());
			po.setBreederMemberCode(dogNewborn.getFdogOwnerCode());
			po.setSecondBreederMemberCode(secondBreederMemberCode);
			po.setSecondBreeder(secondBreeder);
			po.setTempUserName(dogNewborn.getFemaleDogOwner());
			po.setTempMemberCode(dogNewborn.getFdogOwnerCode());
			po.setDogBreed(dogNewborn.getDogBreed());
			po.setSameBatchNum(sameBatchNum);
			po.setEcertFlag("1");// 1是电子版 其他纸质版
			// 状态
			po.setUrgent("0");
			po.setReviewState("0");
			po.setPrice("0");
			po.setIsAll("1");
			// 2016年5月19日改为只有协会打印
			po.setPrintType(dogNewborn.getPrintType());
			po.setPaymentState("1");
			// 生成随机6位数字或字母字符串
			// 2017年6月1日后不生成识别码
			// 2019年7月1日整窝办理业务增加识别码
			po.setSnCode(RandomStringUtils.randomAlphanumeric(6).toUpperCase());
			// 申请日期与出生日期差小于两个月增加可抵扣标记，大于两个月增加不可抵扣标记，刚好两个月
			po.setDeduction(dogBirthCertificateService.getDeduction(dogBirthday));
			// 白色柴犬禁止繁殖和赛事业务，20180601以后杜高犬禁止繁殖配种,允许赛事业务
			po.setBusinessBan(businessBanService.getBusinessBan(dogNewborn.getDogBreed(),
					dogBirthCertificate.getString("colorFlag"), dogBirthday));
			po.setShowBan(businessBanService.getShowBan(dogNewborn.getDogBreed(),
					dogBirthCertificate.getString("colorFlag"), dogBirthday));

			if (vo.get("cabPassportType") != null && StringUtils.isNotBlank(vo.getString("cabPassportType"))) {
				po.setEcertFlag(vo.getString("cabPassportType"));

			} else {
				// 电子证书标记位：0否；1是
				po.setEcertFlag("0");
			}
			if (dogBirthCertificate.get("noseId") != null) {
				po.setNoseId(dogBirthCertificate.getString("noseId"));
			}
			// 2020-05-01起犬只办理登记卡默认激活
			po.setActivitionState("1");
			String hospitalCode = vo.get("hospitalCode") != null ? vo.getString("hospitalCode") : null;
			if (StringUtils.isNotBlank(hospitalCode)) {
				Org o = orgService.get(hospitalCode);
				if (o != null) {
					User user = UserUtils.get(o.getUserId());
					if (user != null) {
						po.setAddUser(user.getLoginName());
					}
				}

			}
			if (dogBirthCertificate.has("callName") && dogBirthCertificate.get("callName") != null) {
				po.setCallName(dogBirthCertificate.getString("callName"));
			}
			poList.add(po);

		}
		return poList;

	}

	/**
	 * 获取母犬主 犬舍名字
	 *
	 * @param dogNewborn
	 * @return
	 */
	private String getKennelName(DogNewborn dogNewborn) {
		return restDogBirthCertificateService.validateKennel(dogNewborn);
	}

	/**
	 * 根据犬数量生成价格
	 *
	 * @param request
	 * @return
	 */
	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		if (org.apache.commons.lang3.StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明编号为空");
		}
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(fmdogBreedCertifiedCode);
		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明编号有误");
		}
		// List<DogBirthCertificate> ls =
		// dogBirthCertificateDao.findByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
		// if (ls != null && ls.size() > 0)
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经办理过出生纸 不能整窝办理");
		String num = request.getParameter("num");
		if (StringUtils.isBlank(num)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡申请数为空");
		}
		Integer numInteger;
		try {
			numInteger = Integer.valueOf(num);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡申请数必须为整数");
		}
		// 获取业务收费项
		List<PaymentChargingItem> lstItem = paymentChargingItemService.getFeesAndCharges();
		double totalPrice = 0.0;
		for (PaymentChargingItem pc : lstItem) {
			totalPrice = totalPrice + Double.parseDouble(pc.getPrice());
		}
		JSONObject jo = new JSONObject();
		jo.put("price", String.format("%.2f", (totalPrice * numInteger)));
		return new RESTResponse("data", jo);
	}
}
