package com.cku.partner.club.web;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.RESTResponse;
import com.cku.oa.activity.dao.SysMemberActivityRecordDao;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.club.service.ClubDogChipService;
import com.cku.partner.club.service.DogCertifiedChangeClubService;
import com.cku.partner.club.service.PaymentService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 
 * user chaixueteng 2016年10月17日
 */
@Controller
@RequestMapping(value = "/partner/payment")
public class paymentController extends BaseController {

	@Autowired
	public PaymentService paymentService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public RestOrderService restOrderService;
	@Autowired
	public PaymentOrderDao paymentOrderDao;
	@Autowired
	public OrgService orgService;
	@Autowired
	public ClubDogChipService clubDogChipService;
	@Autowired
	public PaymentOrderService paymentOrderService;
	@Autowired
	public DogCertifiedChangeClubService dogCertifiedChangeClubService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private SysCouponDao sysCouponDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private SysMemberActivityRecordDao sysMemberActivityRecordDao;

	@ModelAttribute
	public Org get(@RequestParam(required = false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = orgService.get(id);
		}
		if (entity == null) {
			entity = new Org();
		}
		return entity;
	}

	/**
	 * 会员续费
	 * 
	 * @Author chaixueteng
	 * @2016年10月17日上午11:12:44
	 */
	@RequestMapping(value = "pay")
	public String pay(String memberCode, String orgId, Model model, RedirectAttributes redirectAttributes) {
		List<PaymentCart> carts = null;
		SysCoupon coupon = null;
		try {
			// 如果是新建进来，要查询优惠券，如果是续费进来，不插入优惠券
			Member member = memberService.getByMemberCode(memberCode);
			if (member != null && member.getMemberEndDate() == null) {
				// 新来的不重新生成订单
				Org org = orgService.get(orgId);
				PaymentOrderDetail paymentOrderDetail = paymentOrderDetailDao
						.findPartnerNewMemberOrder(org.getMemberCode(), member.getId());
				if (paymentOrderDetail != null) {
					Org orgt = (Org) UserUtils.getSession().getAttribute("org");
					// 重新查找 session域固定不变 所以需要重新查询 余额
					String id = orgt.getId();
					Org org2 = orgService.get(id);
					List<PaymentOrderDetail> list = paymentOrderDetailDao
							.getOrderByRunningNum(paymentOrderDetail.getOrderCode(), org.getMemberCode());
					model.addAttribute("order", list);
					model.addAttribute("org", org2);
					PaymentOrder paymentOrder2 = paymentOrderDao
							.getOrderByRunningNum(paymentOrderDetail.getOrderCode());
					model.addAttribute("orderId", paymentOrder2.getId());
					return "partner/sys/paymentPage";
				}
				coupon = sysCouponService.getByTargetId(member.getId() + "&" + memberCode);
			}
			carts = paymentService.toCart(memberCode, orgId, coupon != null ? coupon.getId() : null);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:/partner/clubMember/list?repage";
		}
		return payPage(carts, model, coupon, memberCode);
	}

	/**
	 * 犬舍缴费
	 * 
	 * @Author chaixueteng
	 * @2016年10月18日下午6:46:21
	 */
	@RequestMapping(value = "kennelPay")
	public String kennelPay(String memberCode, Model model, RedirectAttributes redirectAttributes) {
		List<PaymentOrderDetail> list = paymentService.kennelToCart(memberCode);
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder byOrderCode = paymentOrderService.getByOrderCode(orderCode);
		model.addAttribute("orderId", byOrderCode.getId());
		model.addAttribute("order", list);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String id = org.getId();
		Org org2 = orgService.get(id);
		model.addAttribute("org", org2);
		return "partner/sys/paymentPage";
	}

	/**
	 * 购物车跳入到订单确认页
	 * 
	 * @Author chaixueteng
	 * @2016年10月17日下午2:56:59
	 */
	public String payPage(List<PaymentCart> cart, Model model, SysCoupon sysCoupon, String memberCode) {
		PaymentOrder paymentOrder = new PaymentOrder();
		paymentOrder.setMemberCode(cart.get(0).getMemberCode());
		paymentOrder.setMemberName(cart.get(0).getMemberName());
		List<PaymentOrderDetail> list = paymentService.cartToOrder(cart, paymentOrder);
		String orderCode = list.get(0).getOrderCode();
		PaymentOrder paymentOrder2 = paymentOrderDao.getOrderByRunningNum(orderCode);
		if (sysCoupon != null) {
			// 优惠券增加记录订单号，会员号，不然删除订单无法恢复优惠券
			sysCoupon.setRunningNumber(orderCode);
			sysCoupon.setTargetId(sysCoupon.getTargetId().split("&")[0] + "&" + orderCode);
			sysCouponDao.update(sysCoupon);
			List<PaymentOrderDetail> flist = list.stream().filter(a -> "sys_coupon".equals(a.getBusinessTable()))
					.collect(Collectors.toList());
			if (flist != null && flist.size() > 0) {
				flist.get(0).setBusinessIds(sysCoupon.getTargetId());
				paymentOrderDetailDao.update(flist.get(0));
			}
		}

		// 增加会员缴费日志
		List<PaymentOrderDetail> flist = list.stream().filter(a -> "sys_member".equals(a.getBusinessTable()))
				.collect(Collectors.toList());
		if (flist != null && flist.size() > 0) {
			Member member = memberService.findMemberAndKennelByMemberCode(memberCode);
			SysMemberActivityRecord record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			record.setActivityType(flist.get(0).getBusinessCode());
			record.setGroomerType(member.getGroomerType());
			record.setMemberType(member.getMemberType());
			record.setMemeberCode(member.getMemberCode());
			record.setMemeberName(member.getName());
			if (member.getKennel() != null) {
				record.setKennelCode(member.getKennel().getKennelCode());
				record.setKennelEndDate(member.getKennel().getEndTime());
				record.setKennelName(member.getKennel().getName());
				record.setKennelType(member.getKennel().getType());
			}
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setParticipationTime(new Date());
			record.setRecordType("2");
			record.setMemberEndDate(member.getMemberEndDate());
			record.setGroomerEndDate(member.getGroomerEndDate());
			record.setOrderCode(flist.get(0).getOrderCode());
			record.setMemberCardType(member.getMemberCardType());
			record.setCreateBy(list.get(0).getCreateBy());
			sysMemberActivityRecordDao.insert(record);
		}
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String id = org.getId();
		Org org2 = orgService.get(id);
		model.addAttribute("order", list);
		model.addAttribute("org", org2);
		model.addAttribute("orderId", paymentOrder2.getId());
		return "partner/sys/paymentPage";
	}

	/**
	 * 账户充值
	 * 
	 * @Author chaixueteng
	 * @2016年10月17日下午4:30:09
	 */
	// @RequestMapping(value="recharge")//通联支付
	// @ResponseBody
	// public Map<String, String> recharge(PaymentOrder paymentOrder,
	// HttpServletRequest request, HttpServletResponse response) {
	// Map<String, String> map = Maps.newHashMap();
	// //String amount = request.getParameter("amount");
	// Org org = (Org) UserUtils.getSession().getAttribute("org");
	// String memberCode = org.getMemberCode();
	// String name = org.getMember().getName();
	// String amount = paymentOrder.getAmount();
	// String paymentWay = "1";
	// String id = null;
	// try {
	// id = memberService.recharge(memberCode, name, amount, paymentWay);
	// map.put("id",id);
	// } catch (Exception e) {
	// map.put("msg","账户充值失败，请重试");
	// }
	// return map;
	// }
	@RequestMapping(value = "recharge") // 旧支付宝支付
	public String recharge(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		// String amount = request.getParameter("amount");
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String memberCode = org.getMemberCode();
		String name = org.getMember().getName();
		String amount = paymentOrder.getAmount();
		String paymentWay = "1";
		String id = null;
		try {
			id = memberService.recharge(memberCode, name, amount, paymentWay);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:/partner/payment/toRecharge";
		}
		return "redirect:/api/v1/open/alipay/pay/" + id;
	}

	/**
	 * 账户充值页
	 * 
	 * @Author chaixueteng
	 * @2016年10月17日下午4:30:09
	 */
	@RequestMapping(value = "toRecharge")
	public String toRecharge(Model model) {
		model.addAttribute("paymentOrder", new PaymentOrder());
		return "partner/club/clubRecharge";
	}

	/**
	 * 支付页
	 * 
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	// @RequestMapping(value="paymentOrder")//通联支付
	// public String paymentOrder(HttpServletRequest request,HttpServletResponse
	// response){
	// String paymentWay = request.getParameter("paymentWay");
	// String orderId = request.getParameter("orderId");
	// String repage = request.getParameter("repage");
	// if ("25".equals(paymentWay)) {//余额缴费
	// String paymentOrder = paymentService.paymentOrder(paymentWay,orderId);
	// return !StringUtils.isBlank(repage) ? repage : paymentOrder;
	// }
	// return "redirect:/partner/sys/paymentPage";
	// }

	@RequestMapping(value = "paymentOrder") // 旧支付宝支付
	public String paymentOrder(HttpServletRequest request, HttpServletResponse response) {
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		String repage = request.getParameter("repage");
		if ("25".equals(paymentWay)) {// 余额缴费
			String paymentOrder = paymentService.paymentOrder(paymentWay, orderId);
			return !StringUtils.isBlank(repage) ? repage : paymentOrder;
		}
		return "redirect:/api/v1/open/alipay/pay/" + orderId;
	}

	/**
	 * 新生犬支付页
	 * 
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	@MultiSubmit(timeout = 15)
	@RequestMapping(value = "paymentClubOrder")
	public String paymentClubOrder(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		String type = request.getParameter("type");
		String URL = request.getParameter("URL");
		paymentService.updateOrderWay(orderId, paymentWay);
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		if (paymentOrder == null) {
			addMessage(redirectAttributes, "失败!订单已失效");
			return "redirect:/partner/clubMember/dogList?repage";
		} else if ("2".equals(paymentOrder.getPaymentState())) {// 已缴费
			addMessage(redirectAttributes, "失败!订单已缴费");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		if ("25".equals(paymentWay)) {// 余额缴费
			String paymentOrderUrl = paymentService.paymentClubOrder(paymentWay, orderId);
			if ("2".equals(type)) {
				return "redirect:/partner/dna/listBlood?repage";
			} else {
				if (StringUtils.isBlank(URL)) {
					return paymentOrderUrl;
				} else {
					return URL;
				}
			}
		} else {
			return "redirect:/api/v1/open/alipay/pay/" + orderId;
		}
	}

	/**
	 * 新生犬微信缴费
	 * 
	 * @Author chaixueteng
	 * @2016年10月18日上午9:33:15
	 */
	@MultiSubmit(timeout = 10)
	@RequestMapping(value = "/paymentClubOrderByWeixin", method = RequestMethod.POST)
	@ResponseBody
	public void paymentClubOrderByWeixin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String paymentWay = request.getParameter("paymentWay");
		String orderId = request.getParameter("orderId");
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		JSONObject jo = new JSONObject();
		if (paymentOrder == null) {
			jo.put("rc", -1);
			jo.put("msg", "订单已失效");
			ServletUtils.writeResponse(response, new RESTResponse("data", jo));
		}
		if ("1".equals(paymentOrder.getPaymentState())) {// 未缴费未删除
			paymentService.updateOrderWay(orderId, paymentWay);
			jo.put("id", orderId);
			jo.put("rc", 0);
			ServletUtils.writeResponse(response, new RESTResponse("data", jo));
		} else if ("2".equals(paymentOrder.getPaymentState())) {
			jo.put("rc", -1);
			jo.put("msg", "订单已支付");
			ServletUtils.writeResponse(response, new RESTResponse("data", jo));
		}
	}

	/**
	 * 
	 * 微信支付
	 * 
	 * @Author chaixueteng
	 * @2017年5月12日上午9:33:15
	 */
	@RequestMapping(value = "/payWay", method = RequestMethod.POST)
	@ResponseBody
	public void rechargeWeiXin(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");
		String type = request.getParameter("type");
		String chipCode = request.getParameter("dogChip");
		String way = request.getParameter("way");
		String samplingCode = request.getParameter("samplingCode");
		PaymentOrder order = dogCertifiedChangeClubService.toOrder(id, type, chipCode, way,samplingCode);
		JSONObject jo = new JSONObject();
		jo.put("id", order.getId());
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}

	/**
	 * 支付宝
	 * 
	 * @Author chaixueteng
	 * @2016年10月17日下午4:30:09
	 */
	@RequestMapping(value = "payWayzfb")
	@Transactional(readOnly = false)
	public String payWayzfb(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, HttpServletRequest request,
			HttpServletResponse response, RedirectAttributes redirectAttributes, Model model) {
		String id = request.getParameter("id");
		String type = request.getParameter("type");
		String chipCode = request.getParameter("dogChip");
		String way = request.getParameter("way");
		String samplingCode = request.getParameter("samplingCode");
		PaymentOrder order = dogCertifiedChangeClubService.toOrder(id, type, chipCode, way,samplingCode);
		if ("25".equals(way)) {
			paymentService.paymentClubOrder(way, order.getId());
			return "redirect:/partner/clubMember/dogPedigreeCertifiedChangelist?repage";
		}
		return "redirect:/api/v1/open/alipay/pay/" + order.getId();
	}
}
