package com.cku.partner.club.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberType;
import com.cku.oa.sys.service.SysOrgPrintService;
import com.cku.oa.sys.util.PinYinUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 合作机构、合作医院Service
 * @author
 * @version 2016-08-22
 */
@Service
@Transactional(readOnly = true)
public class ClubOrgService extends CrudService<OrgDao, Org> {

	@Autowired
	private SystemService systemService;
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private SysOrgPrintService sysOrgPrintService;


	public Org get(String id) {
		return super.get(id);
	}

	public List<Org> findList(Org org) {
		return super.findList(org);
	}

	public Page<Org> findPage(Page<Org> page, Org org) {
		return super.findPage(page, org);
	}


	@Transactional(readOnly = false)
	public void delete(Org org) {
		super.delete(org);
	}
	@Transactional(readOnly = false)
	public void update(Org org) {
		org.preUpdate();
		dao.updateAddress(org);
	}


	@Transactional(readOnly = false)
	public void saveClubOrg(Org org) throws Exception{
		vaildParma(org);
		Org org1 = (Org) UserUtils.getSession().getAttribute("org");
		if (org.getIsNewRecord()){
			if(UserUtils.getByLoginNameAndUserType(org.getUser().getLoginName(), "3")!=null){
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_PARAMETER,"用户帐号已经存在");
			}
			//同步创建用户登录帐号
			User user = org.getUser();
			user.setUserType("3"); //3代表合作机构与合作医院
			user.setName(org.getName());
			user.setPassword(systemService.entryptPassword(user.getPassword()));
			systemService.saveUser(user);

//			同步创建会员帐号
			Member member = new Member();
			String memberCode = "";
			if(org.getOrgType().equals("chongjihemendian")){
				memberCode = SysCodeUtil.getCJHMemberCode();
			}
			if(org.getOrgType().equals("catRenZheng")){
				memberCode = SysCodeUtil.getCABMemberCode();
			}
			member.setUser(user);
			member.setName(user.getName());
			member.setNameEn(PinYinUtil.getFullSpell(member.getName()));
			member.setMemberType(MemberType.basic.toString());//基础会员
			member.setGender("male");//默认初始化为male
			member.setPaymentState("1"); //未付费
			member.setMemberEndDate(null);
			member.setKuFlag(null);
			member.setKuEndDate(null);
			member.setGroomerType(null);
			member.setGroomerEndDate(null);
			member.setDgMemberType(null);
			member.setDgEndDate(null);
			member.setAccountBalance("0");
			member.setMemberCode(memberCode);
			member.setProvince(org.getProvince());
			member.setCity(org.getCity());
			member.setStreet(org.getStreet());
			member.preInsert();
			memberDao.insert(member);

			org.preInsert();
			org.setVisibleFlag("1");
			org.setAddress(org.getProvince()+org.getCity()+org.getStreet());
			org.setShenHeState("0");
			org.setTuijiansren(org1.getId());
			org.setMemberCode(memberCode);
			dao.insert(org);

			// catRenZheng类型则增加重置打印对象
			if("catRenZheng".equals(org.getOrgType())){
				SysOrgPrint sysOrgPrint = new SysOrgPrint();
				sysOrgPrint.setOrgId(org.getId());
				sysOrgPrint.setValidDate(new Date());
				sysOrgPrint.setOrgCode(memberCode);
				sysOrgPrint.setRestPrintCode("3");
				sysOrgPrintService.save(sysOrgPrint);
			}
		}else{
			//同步修改用户信息
			User user = systemService.getUser(org.getUser().getId());
			user.setName(org.getName());
			if(!StringUtils.isEmpty(org.getUser().getPassword())){
				user.setPassword(systemService.entryptPassword(org.getUser().getPassword()));
			}
			systemService.saveUser(user);

			Org org2 = get(org.getId());
			//如果是合作机构的化，还需要同步修改会员帐号
			Member m = memberDao.getByMemberCode(org2.getMemberCode());
			m.setName(org.getName());
			m.setProvince(org.getProvince());
			m.setCity(org.getCity());
			m.setStreet(org.getStreet());
			memberDao.update(m);

			//更新组织机构信息
			org.preUpdate();
			org.setVisibleFlag("1");
			org.setShenHeState("0");
			org.setTuijiansren(org1.getId());
			org.setMemberCode(org2.getMemberCode());
			org.setAddress(org.getProvince()+org.getCity()+org.getStreet());
			dao.update(org);
		}
	}

	private void vaildParma(Org org) {
		if(StringUtils.isBlank(org.getName())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "门店名称为空");
		}
		if(StringUtils.isBlank(org.getOrgType())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "门店类型为空");
		}
		if("chongjihemendian".equals(org.getOrgType()) && "catRenZheng".equals(org.getOrgType())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "门店类型错误");
		}
		if(StringUtils.isBlank(org.getContact())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "门店负责人为空");
		}
		if(StringUtils.isBlank(org.getTel())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "联系电话为空");
		}
		if(StringUtils.isBlank(org.getCity())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "地址错误");
		}
		if(StringUtils.isBlank(org.getProvince())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "地址错误");
		}
		if(StringUtils.isBlank(org.getStreet())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "地址错误");
		}
		if(StringUtils.isBlank(org.getYingyePic())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "营业执照照片为空");
		}
		if(StringUtils.isBlank(org.getShouYiPic())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "兽医资格照片为空");
		}
	}
}