package com.cku.oa.sys.badword.web;

import com.cku.oa.sys.badword.entity.DemandSensitiveWord;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 敏感词Controller
 * @author wangjie
 * @version 2018-03-13
 */
@Controller
@RequestMapping(value = "${adminPath}/badword/demandSensitiveWord")
public class DemandSensitiveWordController extends BaseController {

	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;

	@ModelAttribute
	public DemandSensitiveWord get(@RequestParam(required=false) String id) {
		DemandSensitiveWord entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = demandSensitiveWordService.get(id);
		}
		if (entity == null){
			entity = new DemandSensitiveWord();
		}
		return entity;
	}

	@RequiresPermissions("badword:demandSensitiveWord:view")
	@RequestMapping(value = {"list", ""})
	public String list(DemandSensitiveWord demandSensitiveWord, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DemandSensitiveWord> page = demandSensitiveWordService.findPage(new Page<DemandSensitiveWord>(request, response), demandSensitiveWord);
		model.addAttribute("page", page);
		return "sys/badword/demandSensitiveWordList";
	}

	@RequiresPermissions("badword:demandSensitiveWord:view")
	@RequestMapping(value = "form")
	public String form(DemandSensitiveWord demandSensitiveWord, Model model) {
		model.addAttribute("demandSensitiveWord", demandSensitiveWord);
		return "sys/badword/demandSensitiveWordForm";
	}

	@RequiresPermissions("badword:demandSensitiveWord:edit")
	@RequestMapping(value = "save")
	public String save(DemandSensitiveWord demandSensitiveWord, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, demandSensitiveWord)){
			return form(demandSensitiveWord, model);
		}
		demandSensitiveWordService.save(demandSensitiveWord);
		addMessage(redirectAttributes, "保存敏感词成功");
		return "redirect:"+ Global.getAdminPath()+"/badword/demandSensitiveWord/?repage";
	}

	@RequiresPermissions("badword:demandSensitiveWord:edit")
	@RequestMapping(value = "delete")
	public String delete(DemandSensitiveWord demandSensitiveWord, RedirectAttributes redirectAttributes) {
		demandSensitiveWordService.delete(demandSensitiveWord);
		addMessage(redirectAttributes, "删除敏感词成功");
		return "redirect:"+ Global.getAdminPath()+"/badword/demandSensitiveWord/?repage";
	}

}