/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowScore;
import com.cku.oa.show.service.ShowScoreService;

/**
 * 犬展积分Controller
 * @author lgl
 * @version 2016-07-12
 */
@Controller
@RequestMapping(value = "${adminPath}/score/showScore")
public class ShowScoreController extends BaseController {

	@Autowired
	private ShowScoreService showScoreService;
	
	private final static String AUTHORITY_PRDFIX = "score:showScore:";
	
	
	@ModelAttribute
	public ShowScore get(@RequestParam(required=false) String id) {
		ShowScore entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showScoreService.get(id);
		}
		if (entity == null){
			entity = new ShowScore();
		}
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowScore showScore, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowScore> page = showScoreService.findPage(new Page<ShowScore>(request, response), showScore); 
		model.addAttribute("page", page);
		return "oa/show/score/showScoreList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = "form")
	public String form(ShowScore showScore, Model model) {
		model.addAttribute("showScore", showScore);
		return "oa/show/score/showScoreForm";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "editForm")
	public String editForm(ShowScore showScore, Model model) {
		model.addAttribute("showScore", showScore);
		return "oa/show/score/showScoreEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "save")
	public String save(ShowScore showScore, Model model, RedirectAttributes redirectAttributes) {
//		showScore.setYear("111111111111111111111111111111111111111111");
		showScore.setScoreType("");
		if (!beanValidator(model, showScore)){
			return form(showScore, model);
		}
		showScoreService.save(showScore);
		addMessage(redirectAttributes, "保存犬展积分成功");
		return "redirect:"+Global.getAdminPath()+"/score/showScore/?repage";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"delete")
	@RequestMapping(value = "delete")
	public String delete(ShowScore showScore, RedirectAttributes redirectAttributes) {
		showScoreService.delete(showScore);
		addMessage(redirectAttributes, "删除犬展积分成功");
		return "redirect:"+Global.getAdminPath()+"/score/showScore/?repage";
	}

}