package com.cku.oa.show.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowScoreTitleDao;
import com.cku.oa.show.entity.ShowScoreTitle;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 赛事积分榜标题Service
 * @author wj
 * @version 2020-12-15
 */
@Service
@Transactional(readOnly = true)
public class ShowScoreTitleService extends CrudService<ShowScoreTitleDao, ShowScoreTitle> {

	public ShowScoreTitle get(String id) {
		return super.get(id);
	}

	public List<ShowScoreTitle> findList(ShowScoreTitle showScoreTitle) {
		return super.findList(showScoreTitle);
	}

	public Page<ShowScoreTitle> findPage(Page<ShowScoreTitle> page, ShowScoreTitle showScoreTitle) {
		return super.findPage(page, showScoreTitle);
	}

	@Transactional(readOnly = false)
	public void save(ShowScoreTitle showScoreTitle) {
		validParam(showScoreTitle);
		validBusiness(showScoreTitle);
		super.save(showScoreTitle);
	}

	private void validParam(ShowScoreTitle showScoreTitle) {
		if(StringUtils.isBlank(showScoreTitle.getYear())){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"年份不能为空！");
		}
		if(StringUtils.isBlank(showScoreTitle.getAgeGroup())){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"组别不能为空！");
		}
		if(StringUtils.isBlank(showScoreTitle.getTitle())){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"标题不能为空！");
		}
		if(showScoreTitle.getStartTime() == null || showScoreTitle.getEndTime() == null){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"起止时间不能为空！");
		}
		if(showScoreTitle.getStartTime().getTime() > showScoreTitle.getEndTime().getTime()){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"起始日期不能大于截止日期！");
		}
	}
	private void validBusiness(ShowScoreTitle showScoreTitle) {
		ShowScoreTitle data = dao.getByYearAndGroup(showScoreTitle.getYear(), showScoreTitle.getAgeGroup());
		if(data != null && !showScoreTitle.getId().equals(data.getId())){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"相同年份和组别不可重复添加”！");
		}
	}

	@Transactional(readOnly = false)
	public void delete(ShowScoreTitle showScoreTitle) {
		super.delete(showScoreTitle);
	}

}