/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.dao.ShowScoreDao;
import com.cku.oa.show.entity.ShowScore;

/**
 * 赛事积分Service
 * @author lgl
 * @version 2016-07-12
 */
@Service
@Transactional(readOnly = true)
public class ShowScoreService extends CrudService<ShowScoreDao, ShowScore> {

	public ShowScore get(String id) {
		return super.get(id);
	}
	
	public List<ShowScore> findList(ShowScore showScore) {
		return super.findList(showScore);
	}
	
	public Page<ShowScore> findPage(Page<ShowScore> page, ShowScore showScore) {
		return super.findPage(page, showScore);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowScore showScore) {
		super.save(showScore);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowScore showScore) {
		super.delete(showScore);
	}
	
}