/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 赛事积分榜标题Entity
 * @author wj
 * @version 2020-12-15
 */
public class ShowScoreTitle extends DataEntity<ShowScoreTitle> {

	private static final long serialVersionUID = 1L;
	private String year;		// 年份
	private String ageGroup;		// 组别
	private String title;		// 标题
	private Date startTime;		// 开始时间
	private Date endTime;		// 结束时间

	public ShowScoreTitle() {
		super();
	}

	public ShowScoreTitle(String id){
		super(id);
	}

	@Length(min=0, max=11, message="年份长度必须介于 0 和 11 之间")
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	@Length(min=0, max=10, message="组别长度必须介于 0 和 10 之间")
	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	@Length(min=0, max=64, message="标题长度必须介于 0 和 30 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

}