/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.service.TreeService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.oa.shop.dao.ShopGoodsClassDao;

/**
 * 商品类别Service
 * @author lyy
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class ShopGoodsClassService extends TreeService<ShopGoodsClassDao, ShopGoodsClass> {

	public ShopGoodsClass get(String id) {
		return super.get(id);
	}
	
	public List<ShopGoodsClass> findList(ShopGoodsClass shopGoodsClass) {
		if (StringUtils.isNotBlank(shopGoodsClass.getParentIds())){
			shopGoodsClass.setParentIds(","+shopGoodsClass.getParentIds()+",");
		}
		return super.findList(shopGoodsClass);
	}

	public List<ShopGoodsClass> findAllList(ShopGoodsClass shopGoodsClass){
		return super.findList(shopGoodsClass);
	};
	@Transactional(readOnly = false)
	public void save(ShopGoodsClass shopGoodsClass) {
		super.save(shopGoodsClass);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShopGoodsClass shopGoodsClass) {
		super.delete(shopGoodsClass);
	}
	
}