package com.cku.oa.sampling.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 采样包日志流程类型
 */
public enum SamplingLogFlowTypeEnum implements IEnum<Integer> {

    ADD(0, "添加"),
    ORDER(1, "下单"),
    POST(2, "邮寄"),
    BIND(3, "绑定"),
    SEND(4, "送检"),
    RESULT(5, "结果"),
    LOGOUT(6, "注销"),
    UNBIND_DOG(7, "解绑犬只"),
    UNBIND_MEMBER(8, "解绑会员");

    private Integer code;

    private String message;

    SamplingLogFlowTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.message;
    }

}
