/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;

/**
 * 犬舍基本信息Entity
 * @author fanhuibin
 * @version 2016-07-13
 */
/**
 * @author user
 *
 */
public class Kennel extends DataEntity<Kennel> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "会员编号", align = 2, sort = 1)
	private String memberCode; // 会员号
	private String kennelCode; // 犬舍编号
	private String paymentState; // 缴费状态
	@ExcelField(title = "犬舍名称", align = 2, sort = 10)
	private String name; // 犬舍名称
	@ExcelField(title = "犬舍英文名称", align = 2, sort = 11)
	private String nameEn; // 犬舍英文名
	@ExcelField(title = "FCI英文名", align = 2, sort = 15)
	private String fciName; // fci犬舍名
	@ExcelField(title = "FCI英文备用名", align = 2, sort = 16)
	private String fciNameBackup; // fci备用名
	private String breed; // 犬舍犬种
	private String breedName; // 犬种名称
	private String phone; // 犬舍电话
	private String website; // 网址
	private String address; // 犬舍地址
	private String postcode; // 犬舍邮编
	private String type; // 犬舍类型
	@ExcelField(title = "犬舍截止日期", align = 2, sort = 12)
	private Date endTime; // 截止时间
	private String createByName; // 创建人姓名
	private String operator; // 操作人
	@ExcelField(title = "犬舍审核状态", align = 2, sort = 13)
	private String reviewState; // 审核状态
	private String reviewRemark; // 审核备注
	private Date reviewDate; // 审核时间
	@ExcelField(title = "FCI审核状态", align = 2, sort = 18)
	private String fciReviewState; // fci审核状态
	private String fciReviewRemark; // fci审核备注
	private Date fciReviewDate; // fci审核通过时间
	private String printState; // 打印状态
	private String fciPrintState; // FCI打印状态
	@ExcelField(title = "FCI犬舍编号", align = 2, sort = 17)
	private String fciKennelCode; // fci犬舍编号
	private String fciKennelAddress; // fci犬舍地址
	private String calculationState; // 核算状态 (0:待核算 1:已通过 2:未通过 3:免核算)
	private Date calculationDate; // 核算日期
	private String calculationFlag; // 是否参与核算 (1:否 0: 是)
	private Member member; // 会员
	private String reviewStateBack; // 中英文审核状态存储站(核算通过后恢复核算前审核状态)

	private String userPaymentState; // 会员缴费状态 -- 查询用
	private String temp; // 临时字段(返回列表专用)
	private String tempFci; // 临时字段(标记首页fci犬舍筛选条件用)
	private Date beginDate; // 筛选条件中的起始日期
	private Date endDate; // 筛选条件中的终止日期
	private String token;// 宠爱王国访问令牌

	@ExcelField(title = "会员姓名", align = 2, sort = 2)
	private String memberNameCn; // 犬舍信息导出专用 -- 会员姓名
	@ExcelField(title = "会员拼音", align = 2, sort = 3)
	private String memberNameEnFirst; // 犬舍信息导出专用 -- 会员拼音
	@ExcelField(title = "会员拼音", align = 2, sort = 4)
	private String memberNameEnLast; // 犬舍信息导出专用 -- 会员拼音
	@ExcelField(title = "会员地址", align = 2, sort = 5)
	private String memberAddress; // 犬舍信息导出专用 -- 会员地址
	@ExcelField(title = "主营犬种", align = 2, sort = 6)
	private String mainBreed; // 犬舍信息导出专用 -- 主营犬种

	private String isCheckType;
	
	
	private String province;//省
	private String city;//市
	private String area;//区
	private String introduction;//简介
	private String bankCard;
	private String mainImage;//主图地址
	
	private String businessTelephone;//营业电话',
	private String businessDays;//'营业时段，周一至周日',
	private String[] businessDaysArr;//'营业时段，周一至周日',
	private String openingTime;//'营业开始时间',
	private String closingTime;//'营业结束时间',
	private String mainDogBreedFirst;//主营犬种一',
	private String mainDogBreedSecond;//主营犬种二',
	private String mainDogBreedThird;//主营犬种三',
	private String mainDogBreedFourth;//主营犬种四',
	private String mainDogBreedFifth;//主营犬种五',
	private String mainDogBreedSixth;//主营犬种六';
	private String kennelImages;//犬舍图片，逗号分隔;
	private List<KennelImage> kennelImageList;

	private String keyword;

	public Kennel() {
		super();
	}

	public Kennel(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 50, message = "犬舍编号长度必须介于 0 和 50 之间")
	public String getKennelCode() {
		return kennelCode;
	}

	public void setKennelCode(String kennelCode) {
		this.kennelCode = kennelCode;
	}

	@Length(min = 0, max = 1, message = "缴费状态长度必须介于 0 和 1 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@Length(min = 1, max = 100, message = "犬舍名称长度必须介于 1 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 100, message = "犬舍英文名长度必须介于 0 和 100 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Length(min = 0, max = 100, message = "fci犬舍名长度必须介于 0 和 100 之间")
	public String getFciName() {
		return fciName;
	}

	public void setFciName(String fciName) {
		this.fciName = fciName;
	}

	@Length(min = 0, max = 100, message = "fci备用名长度必须介于 0 和 100 之间")
	public String getFciNameBackup() {
		return fciNameBackup;
	}

	public void setFciNameBackup(String fciNameBackup) {
		this.fciNameBackup = fciNameBackup;
	}

	@Length(min = 0, max = 1000, message = "犬舍犬种长度必须介于 0 和 1000 之间")
	public String getBreed() {
		return breed;
	}

	public void setBreed(String breed) {
		this.breed = breed;
	}

	@Length(min = 0, max = 1000, message = "犬种名称长度必须介于 0 和 1000 之间")
	public String getBreedName() {
		return breedName;
	}

	public void setBreedName(String breedName) {
		this.breedName = breedName;
	}

	@Length(min = 0, max = 50, message = "犬舍电话长度必须介于 0 和 50 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@Length(min = 0, max = 100, message = "网址长度必须介于 0 和 100 之间")
	public String getWebsite() {
		return website;
	}

	public void setWebsite(String website) {
		this.website = website;
	}

	@Length(min = 0, max = 200, message = "犬舍地址长度必须介于 0 和 200 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Length(min = 0, max = 100, message = "犬舍邮编长度必须介于 0 和 100 之间")
	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	@Length(min = 0, max = 100, message = "犬舍类型长度必须介于 0 和 100 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getCreateByName() {
		return createByName;
	}

	public void setCreateByName(String createByName) {
		this.createByName = createByName;
	}

	@Length(min = 0, max = 500, message = "操作人长度必须介于 0 和 500 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	@Length(min = 0, max = 1, message = "审核状态长度必须介于 0 和 1 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@Length(min = 0, max = 200, message = "审核备注长度必须介于 0 和 200 之间")
	public String getReviewRemark() {
		return reviewRemark;
	}

	public void setReviewRemark(String reviewRemark) {
		this.reviewRemark = reviewRemark;
	}

	@Length(min = 0, max = 1, message = "fci审核状态长度必须介于 0 和 1 之间")
	public String getFciReviewState() {
		return fciReviewState;
	}

	public void setFciReviewState(String fciReviewState) {
		this.fciReviewState = fciReviewState;
	}

	@Length(min = 0, max = 200, message = "fci审核备注长度必须介于 0 和 200 之间")
	public String getFciReviewRemark() {
		return fciReviewRemark;
	}

	public void setFciReviewRemark(String fciReviewRemark) {
		this.fciReviewRemark = fciReviewRemark;
	}

	@Length(min = 0, max = 1, message = "打印状态长度必须介于 0 和 1之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@Length(min = 0, max = 1, message = "FCI打印状态长度必须介于 0 和 1之间")
	public String getFciPrintState() {
		return fciPrintState;
	}

	public void setFciPrintState(String fciPrintState) {
		this.fciPrintState = fciPrintState;
	}

	@Length(min = 0, max = 50, message = "fci犬舍编号长度必须介于 0 和 50 之间")
	public String getFciKennelCode() {
		return fciKennelCode;
	}

	public void setFciKennelCode(String fciKennelCode) {
		this.fciKennelCode = fciKennelCode;
	}

	@Length(min = 0, max = 200, message = "fci犬舍地址长度必须介于 0 和 200 之间")
	public String getFciKennelAddress() {
		return fciKennelAddress;
	}

	public void setFciKennelAddress(String fciKennelAddress) {
		this.fciKennelAddress = fciKennelAddress;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getFciReviewDate() {
		return fciReviewDate;
	}

	public void setFciReviewDate(Date fciReviewDate) {
		this.fciReviewDate = fciReviewDate;
	}

	public JSONObject toJSON() {
		JsonConfig config = new JsonConfig();
		config.setExcludes(new String[] { "page", "member" }); // 指定在转换时不包含哪些属性
		JSONObject jsonObject = JSONObject.fromObject(this, config); // 在转换时传入之前的配置对象
		return jsonObject;
	}

	public String getTemp() {
		return temp;
	}

	public void setTemp(String temp) {
		this.temp = temp;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getMemberNameCn() {
		return memberNameCn;
	}

	public void setMemberNameCn(String memberNameCn) {
		this.memberNameCn = memberNameCn;
	}

	public String getMemberNameEnFirst() {
		return memberNameEnFirst;
	}

	public void setMemberNameEnFirst(String memberNameEnFirst) {
		this.memberNameEnFirst = memberNameEnFirst;
	}

	public String getMemberNameEnLast() {
		return memberNameEnLast;
	}

	public void setMemberNameEnLast(String memberNameEnLast) {
		this.memberNameEnLast = memberNameEnLast;
	}

	public String getMemberAddress() {
		return memberAddress;
	}

	public void setMemberAddress(String memberAddress) {
		this.memberAddress = memberAddress;
	}

	public String getTempFci() {
		return tempFci;
	}

	public void setTempFci(String tempFci) {
		this.tempFci = tempFci;
	}

	public Date getReviewDate() {
		return reviewDate;
	}

	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}

	public String getCalculationState() {
		return calculationState;
	}

	public void setCalculationState(String calculationState) {
		this.calculationState = calculationState;
	}

	public Date getCalculationDate() {
		return calculationDate;
	}

	public void setCalculationDate(Date calculationDate) {
		this.calculationDate = calculationDate;
	}

	public String getCalculationFlag() {
		return calculationFlag;
	}

	public void setCalculationFlag(String calculationFlag) {
		this.calculationFlag = calculationFlag;
	}

	public String getIsCheckType() {
		return isCheckType;
	}

	public void setIsCheckType(String isCheckType) {
		this.isCheckType = isCheckType;
	}

	public String getReviewStateBack() {
		return reviewStateBack;
	}

	public void setReviewStateBack(String reviewStateBack) {
		this.reviewStateBack = reviewStateBack;
	}

	public String getUserPaymentState() {
		return userPaymentState;
	}

	public void setUserPaymentState(String userPaymentState) {
		this.userPaymentState = userPaymentState;
	}

	public String getMainBreed() {
		return mainBreed;
	}

	public void setMainBreed(String mainBreed) {
		this.mainBreed = mainBreed;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getIntroduction() {
		return introduction;
	}

	public void setIntroduction(String introduction) {
		this.introduction = introduction;
	}

	public String getMainImage() {
		return mainImage;
	}

	public void setMainImage(String mainImage) {
		this.mainImage = mainImage;
	}

	public String getBusinessTelephone() {
		return businessTelephone;
	}

	public void setBusinessTelephone(String businessTelephone) {
		this.businessTelephone = businessTelephone;
	}

	public String getBusinessDays() {
		return businessDays;
	}

	public void setBusinessDays(String businessDays) {
		this.businessDays = businessDays;
	}

	public String getOpeningTime() {
		return openingTime;
	}

	public void setOpeningTime(String openingTime) {
		this.openingTime = openingTime;
	}

	public String getClosingTime() {
		return closingTime;
	}

	public void setClosingTime(String closingTime) {
		this.closingTime = closingTime;
	}

	public String getMainDogBreedFirst() {
		return mainDogBreedFirst;
	}

	public void setMainDogBreedFirst(String mainDogBreedFirst) {
		this.mainDogBreedFirst = mainDogBreedFirst;
	}

	public String getMainDogBreedSecond() {
		return mainDogBreedSecond;
	}

	public void setMainDogBreedSecond(String mainDogBreedSecond) {
		this.mainDogBreedSecond = mainDogBreedSecond;
	}

	public String getMainDogBreedThird() {
		return mainDogBreedThird;
	}

	public void setMainDogBreedThird(String mainDogBreedThird) {
		this.mainDogBreedThird = mainDogBreedThird;
	}

	public String getMainDogBreedFourth() {
		return mainDogBreedFourth;
	}

	public void setMainDogBreedFourth(String mainDogBreedFourth) {
		this.mainDogBreedFourth = mainDogBreedFourth;
	}

	public String getMainDogBreedFifth() {
		return mainDogBreedFifth;
	}

	public void setMainDogBreedFifth(String mainDogBreedFifth) {
		this.mainDogBreedFifth = mainDogBreedFifth;
	}

	public String getMainDogBreedSixth() {
		return mainDogBreedSixth;
	}

	public void setMainDogBreedSixth(String mainDogBreedSixth) {
		this.mainDogBreedSixth = mainDogBreedSixth;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getKennelImages() {
		return kennelImages;
	}

	public void setKennelImages(String kennelImages) {
		this.kennelImages = kennelImages;
	}

	public List<KennelImage> getKennelImageList() {
		return kennelImageList;
	}

	public void setKennelImageList(List<KennelImage> kennelImageList) {
		this.kennelImageList = kennelImageList;
	}

	public String[] getBusinessDaysArr() {
		return businessDaysArr;
	}

	public void setBusinessDaysArr(String[] businessDaysArr) {
		this.businessDaysArr = businessDaysArr;
	}

	public String getBankCard() {
		return bankCard;
	}

	public void setBankCard(String bankCard) {
		this.bankCard = bankCard;
	}
	
}