/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 美容课程报名表Entity
 *
 * @author xx
 * @version 2020-09-21
 */
public class GroomerCourseApplication extends DataEntity<GroomerCourseApplication> {

	private static final long serialVersionUID = 1L;
	private String courseCode; // 课程编号
	private String courseId; // 课程id
	private String coursePrice; // 课程价格
	private String memberCode; // 会员号
	private String name; // 姓名
	private String mobile; // 手机号
	private String province; // 省
	private String city; // 城市
	private String area; // 区
	private String street; // 街道
	private String address; // 详细的地址
	private String runningNumber; // 流水号
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间

	private TrainingInstitution trainingInstitution;//美容师培训学校
	private GroomerCourse groomerCourse;//课程表
	private Member member;  //会员表
	private Date beginCreateDate; // 报名 create_date
	private Date endCreateDate; // 结束 create_date
	private String schoolId;


	public String getSchoolId() {
		return schoolId;
	}

	public void setSchoolId(String schoolId) {
		this.schoolId = schoolId;
	}

	public TrainingInstitution getTrainingInstitution() {
		return trainingInstitution;
	}

	public void setTrainingInstitution(TrainingInstitution trainingInstitution) {
		this.trainingInstitution = trainingInstitution;
	}

	public GroomerCourse getGroomerCourse() {
		return groomerCourse;
	}

	public void setGroomerCourse(GroomerCourse groomerCourse) {
		this.groomerCourse = groomerCourse;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public GroomerCourseApplication() {
		super();
	}

	public GroomerCourseApplication(String id) {
		super(id);
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getCoursePrice() {
		return coursePrice;
	}

	public void setCoursePrice(String coursePrice) {
		this.coursePrice = coursePrice;
	}

	public String getCourseId() {
		return courseId;
	}

	public void setCourseId(String courseId) {
		this.courseId = courseId;
	}

	@Length(min = 1, max = 100, message = "课程编号长度必须介于 1 和 100 之间")
	public String getCourseCode() {
		return courseCode;
	}

	public void setCourseCode(String courseCode) {
		this.courseCode = courseCode;
	}

	@Length(min = 0, max = 100, message = "会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

}