package com.cku.oa.finance.service;

import com.cku.core.ZAException;
import com.cku.oa.finance.dao.MemberAccountDao;
import com.cku.oa.finance.entity.MemberAccount;
import com.cku.oa.statistics.service.SplitOrderService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/25
 * Time: 17:29
 */
@Service
@Transactional(readOnly = true)
public class MemberAccountService extends CrudService<MemberAccountDao, MemberAccount> {
    //账户充值收费项目id
    public static  final String MEMBERCHARGINGITEMID = "0";
    @Autowired
    private MemberDao memberDao;
    @Autowired
    private MemberService memberService;
    @Autowired
    private  MemberAccountDao memberAccountDao;
    @Autowired
    private SplitOrderService splitOrderService;
    @Transactional(readOnly = false)
    public void rechargeAccount(MemberAccount memberAccount) throws ZAException {
            //账户充值 chongzhi
            memberAccount.setChargingItemId(MEMBERCHARGINGITEMID);
            memberAccount.setChargingItemNum(1);
            //TODO 流水号生成策略。3种
            String runningNum = SysCodeUtil.getPayRunningNumber();
            Member member = new Member();
            member.setMemberCode(memberAccount.getMemberCode());
            List<Member> members =memberDao.findList(member);
            if(members!=null && members.size()>0){
                member = members.get(0);
            };
            //修改账户余额
            memberService.memberRecharge(memberAccount.getMemberCode(),memberAccount.getPaymentAmount(),new Date(),runningNum);
            memberAccount.setRunningNumber(runningNum);
            memberAccount.setPaymentState("2");
            memberAccount.setPrice(memberAccount.getPaymentAmount());
            memberAccount.setRegisterProvince(member.getRegisterProvince());
            memberAccount.setRegisterCity(member.getRegisterCity());
            //保存
            super.save(memberAccount);
        //		流水拆分
            splitOrderService.initSplit(runningNum);


    }
    @Transactional(readOnly = false)
    public void rechargeAccountReserve(MemberAccount memberAccount,MemberAccount memberAccount2) throws ZAException {
        //账户充值 chongzhi
        memberAccount.setChargingItemId(MEMBERCHARGINGITEMID);
        memberAccount.setChargingItemNum(1);
        //TODO 流水号生成策略。3种
        String runningNum = SysCodeUtil.getPayRunningNumber();
        Member member = new Member();
        member.setMemberCode(memberAccount.getMemberCode());
        List<Member> members =memberDao.findList(member);
        if(members!=null && members.size()>0){
            member = members.get(0);
        };
        //修改账户余额
        memberService.memberRecharge(memberAccount.getMemberCode(),memberAccount.getPaymentAmount(),new Date(),runningNum);
        memberAccount.setRunningNumber(runningNum);
        memberAccount.setPaymentState("2");
        memberAccount.setPrice(memberAccount.getPaymentAmount());
        memberAccount.setRegisterProvince(member.getRegisterProvince());
        memberAccount.setRegisterCity(member.getRegisterCity());
        //保存
        super.save(memberAccount);
        //修改旧订单状态
        memberAccount2.setPaymentState("3");
        memberAccountDao.updateStatus(memberAccount2);
    }

    public Page<MemberAccount> findPage(Page<MemberAccount> page, MemberAccount memberAccount) {
        return super.findPage(page, memberAccount);
    }
    public String getCountPrice(MemberAccount memberAccount) {
        return dao.getCountPrice(memberAccount);
    }


    public Page<MemberAccount> findOrgPage(Page<MemberAccount> page, MemberAccount memberAccount) {
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        memberAccount.setPage(page);
        page.setList(dao.findOrgPage(memberAccount));
        if((pageNo-1)*pageSize>=page.getCount()){
            page.setList(new ArrayList<MemberAccount>(0));
        }
        return page;
    }
    public String getOrgCountPrice(MemberAccount memberAccount) {
        return dao.getOrgCountPrice(memberAccount);
    }

    public Page<MemberAccount> findTrainingPage(Page<MemberAccount> page, MemberAccount memberAccount) {
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        memberAccount.setPage(page);
        page.setList(dao.findTrainingPage(memberAccount));
        if((pageNo-1)*pageSize>=page.getCount()){
            page.setList(new ArrayList<MemberAccount>(0));
        }
        return page;
    }
    public String searchStatisticsDetailCountPrice(MemberAccount memberAccount) {
        return dao.searchStatisticsDetailCountPrice(memberAccount);
    }

    public Page<MemberAccount> searchStatisticsDetailPage(Page<MemberAccount> page, MemberAccount memberAccount) {
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        memberAccount.setPage(page);
        page.setList(dao.searchStatisticsDetailPage(memberAccount));
        if((pageNo-1)*pageSize>=page.getCount()){
            page.setList(new ArrayList<MemberAccount>(0));
        }
        return page;
    }


    public String getTrainingCountPrice(MemberAccount memberAccount) {
        return dao.getTrainingCountPrice(memberAccount);
    }


    public void export(MemberAccount memberAccount, HttpServletResponse response) throws IOException {
        List<MemberAccount> gqcList=memberAccountDao.findList(memberAccount);
        if(!Collections3.isEmpty(gqcList) && gqcList.size() >10000){
            gqcList.subList(0,10000);
        }
        for (MemberAccount data : gqcList ) {
            //支付方式
            String payment_way = DictUtils.getDictLabel(data.getPaymentWay(), "payment_way", "");
            data.setPaymentWay(payment_way);
            //账户余额
            if(StringUtils.isBlank(data.getBalanceMoney())){
                //查询当前余额
                Member member=memberDao.getByMemberCode(data.getMemberCode());
                //查询 截止订单日期 用户充值金额。
                MemberAccount c=new MemberAccount();
                c.setMemberCode(data.getMemberCode());
                c.setPaymentTimeStart(data.getPaymentTime());
                double chongZhiMoney=memberAccountDao.getChongZhiMoney(c);
                //第三部，查询截止订单日期  用户用 用户余额支付的
                double hufeiMoney=memberAccountDao.getHuaMoney(c);
                // 进行加减运算
                BigDecimal b1 = new BigDecimal(member.getAccountBalance());
                BigDecimal b2 = new BigDecimal(chongZhiMoney);
                BigDecimal b3 = new BigDecimal(hufeiMoney);
                BigDecimal result= b1.subtract(b2).add(b3).setScale(2,BigDecimal.ROUND_HALF_UP);
                data.setBalanceMoney(result.toString());
            }
            //付款会员号
            if(StringUtils.isBlank(data.getCmember())){
                if(StringUtils.isBlank(data.getOrgmember())){
                    data.setCmember(data.getMemberCode());
                }else{
                    data.setCmember(data.getOrgmember());
                }
            }
        }
        new ExportExcel("", MemberAccount.class, 2)
		.setDataList(gqcList).write(response, "财务收支明细.xlsx").dispose();
    }

    @Transactional(rollbackFor = RuntimeException.class)
    public Integer savePaymentRemarks(String runningNumber, String paymentRemarks){
        Integer resultCount = memberAccountDao.savePaymentRemarks(runningNumber, paymentRemarks);
        return resultCount;
    }
}
