package com.cku.oa.dog.web.dogamphimixis;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 换发配种证明Controller
 * @author cxt
 * @version 2016-09-10
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogamphimixis/dogAmphimixisProve")
public class DogAmphimixisProveController extends BaseController {

	@Autowired
	private DogAmphimixisProveService dogAmphimixisProveService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogService dogService;


	
	@ModelAttribute
	public DogAmphimixisProve get(@RequestParam(required=false) String id) {
		DogAmphimixisProve entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogAmphimixisProveService.get(id);
		}
		if (entity == null){
			entity = new DogAmphimixisProve();
		}
		return entity;
	}
	
	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogAmphimixisProve dogAmphimixisProve, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogAmphimixisProve> page = dogAmphimixisProveService.findPage(new Page<DogAmphimixisProve>(request, response), dogAmphimixisProve); 
		model.addAttribute("page", page);
		return "oa/dog/dogamphimixis/dogAmphimixisProveList";
	}

	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:view")
	@RequestMapping(value = "form")
	public String form(DogAmphimixisProve dogAmphimixisProve, Model model) {
		model.addAttribute("dogAmphimixisProve", dogAmphimixisProve);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		return "oa/dog/dogamphimixis/dogAmphimixisProveForm";
	}
	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogAmphimixisProve dogAmphimixisProve,Model model){
		/*Dog dog = dogService.get(dogAmphimixisProve.getId());
		String fmdogBreedCertifiedCode = dog.getFmdogBreedCertifiedCode();
		DogAmphimixisProve dap=dogAmphimixisProveService.getByfmdog(fmdogBreedCertifiedCode);*/
		model.addAttribute("dogAmphimixisProve", dogAmphimixisProve);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		return "oa/dog/dogamphimixis/dogAmphimixisProveEdit";
	}
	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:edit")
	@RequestMapping(value = "editSave")
	public String editSave(DogAmphimixisProve dogAmphimixisProve, Model model, RedirectAttributes redirectAttributes) {
		try {
			dogAmphimixisProveService.save(dogAmphimixisProve);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/dog/dogamphimixis/dogAmphimixisProve/editForm?id="+dogAmphimixisProve.getId();
		}
		return "redirect:"+Global.getAdminPath()+"/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/?dogBreed="+dogAmphimixisProve.getDogBreed()
				+ "&repage";
	}
	
	
	
	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:add")
	@RequestMapping(value = "save")
	public String save(DogAmphimixisProve dogAmphimixisProve, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogAmphimixisProve)){
			return form(dogAmphimixisProve, model);
		}
		try {
			dogAmphimixisProveService.save(dogAmphimixisProve);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/dog/dogamphimixis/dogAmphimixisProve/form?id="+dogAmphimixisProve.getId();
		}
		return "redirect:"+Global.getAdminPath()+"/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/?dogBreed="+dogAmphimixisProve.getDogBreed()
				+ "&repage";
	}
	
	@RequiresPermissions("dog:dogamphimixis:dogAmphimixisProve:edit")
	@RequestMapping(value = "delete")
	public String delete(DogAmphimixisProve dogAmphimixisProve, RedirectAttributes redirectAttributes) {
		dogAmphimixisProveService.delete(dogAmphimixisProve);
		addMessage(redirectAttributes, "删除换发配种证明成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogamphimixis/dogAmphimixisProve/?repage";
	}
	
	/**
	 * 根据配种证明号查询信息
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "getByFmdogBreedCertifiedCode")
	@ResponseBody
    public Object getByFmdogBreedCertifiedCode(HttpServletRequest request) {
    	return dogAmphimixisProveService.getByFmdogBreedCertifiedCode(request.getParameter("fmdogBreedCertifiedCode"));
    }
	
	/**
	 * 犬种类别校验
	 * @Author chaixueteng
	 * @2016年10月19日下午7:40:54
	 */
	@RequestMapping(value = "/checkCertified")
	@ResponseBody
	public Object checkCertified(HttpServletRequest request, HttpServletResponse response){
		String dogPedigreeCertified = request.getParameter("dogPedigreeCertified");
	    String a=request.getParameter("a");
	    String dogBreed = request.getParameter("dogBreed");
	    Map<String,String> map= new HashMap<String,String>();
	    try {
			dogAmphimixisProveService.checkCertified(dogPedigreeCertified,a,dogBreed);
			map.put("rc", "0");
		} catch (ZAException e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	
	
	/**
	 * 根据父母配犬证明号查询信息
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getFM")
	@ResponseBody
    public Object getFM(HttpServletRequest request, HttpServletResponse response) {
	    String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
	    return dogAmphimixisProveService.getFM(fmdogBreedCertifiedCode);
    }
}