package com.cku.oa.dog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogTibetanMastiff;
import com.cku.oa.dog.service.DogTibetanMastiffService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 藏獒犬只鉴定Controller
 * @author zhuoHeng
 * @version 2016-08-24
 */
@Controller
@RequestMapping(value = "${adminPath}/dogtibetanmastiff/dogTibetanMastiff")
public class DogTibetanMastiffController extends BaseController {

	@Autowired
	private DogTibetanMastiffService dogTibetanMastiffService;
	
	@ModelAttribute
	public DogTibetanMastiff get(@RequestParam(required=false) String id) {
		DogTibetanMastiff entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogTibetanMastiffService.get(id);
		}
		if (entity == null){
			entity = new DogTibetanMastiff();
		}
		return entity;
	}
	
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogTibetanMastiff dogTibetanMastiff, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogTibetanMastiff> page = dogTibetanMastiffService.findPage(new Page<DogTibetanMastiff>(request, response), dogTibetanMastiff); 
		model.addAttribute("page", page);
		return "oa/dog/dogtibetanmastiff/dogTibetanMastiffList";
	}

	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:view")
	@RequestMapping(value = "form")
	public String form(DogTibetanMastiff dogTibetanMastiff, Model model) {
		model.addAttribute("dogTibetanMastiff", dogTibetanMastiff);
		return "oa/dog/dogtibetanmastiff/dogTibetanMastiffForm";
	}

	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:edit")
	@RequestMapping(value = "save")
	public String save(DogTibetanMastiff dogTibetanMastiff, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogTibetanMastiff)){
			return form(dogTibetanMastiff, model);
		}
		dogTibetanMastiffService.save(dogTibetanMastiff);
		addMessage(redirectAttributes, "保存藏獒犬只鉴定成功");
		return "redirect:"+Global.getAdminPath()+"/dogtibetanmastiff/dogTibetanMastiff/?repage";
	}
	
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:delete")
	@RequestMapping(value = "delete")
	public String delete(DogTibetanMastiff dogTibetanMastiff, RedirectAttributes redirectAttributes) {
		dogTibetanMastiffService.delete(dogTibetanMastiff);
		addMessage(redirectAttributes, "删除藏獒犬只鉴定成功");
		return "redirect:"+Global.getAdminPath()+"/dogtibetanmastiff/dogTibetanMastiff/?repage";
	}
	
	/**
	 * 
	 * @Description：添加藏獒犬只鉴定
	 * @author: zhuoHeng
	 * @version: 2016年8月25日 上午11:09:08
	 */
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:add")
    @RequestMapping(value = "add")
    public String add(DogTibetanMastiff dogTibetanMastiff, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogTibetanMastiff)){
            return form(dogTibetanMastiff, model);
        }
        dogTibetanMastiffService.add(dogTibetanMastiff);
        addMessage(redirectAttributes, "添加藏獒犬只鉴定成功");
        return "redirect:"+Global.getAdminPath()+"/dogtibetanmastiff/dogTibetanMastiff/?repage";
    }
	
	/**
	 * 
	 * @Description：打开藏獒犬只鉴定查看页
	 * @author: zhuoHeng
	 * @version: 2016年8月24日 下午8:13:30
	 */
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:view")
    @RequestMapping(value = "view")
    public String view(DogTibetanMastiff dogTibetanMastiff, Model model) {
        model.addAttribute("dogTibetanMastiff", dogTibetanMastiff);
        return "oa/dog/dogtibetanmastiff/dogTibetanMastiffView";
    }
	
	/**
	 * 
	 * @Description：打开藏獒犬只鉴定审核页
	 * @author: zhuoHeng
	 * @version: 2016年8月24日 下午8:14:29
	 */
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:audit")
    @RequestMapping(value = "review")
    public String review(DogTibetanMastiff dogTibetanMastiff, Model model) {
        model.addAttribute("dogTibetanMastiff", dogTibetanMastiff);
        return "oa/dog/dogtibetanmastiff/dogTibetanMastiffReview";
    }
	
	/**
	 * 
	 * @Description：更改藏獒犬只鉴定审核状态
	 * @author: zhuoHeng
	 * @version: 2016年8月25日 上午10:18:47
	 */
	@RequiresPermissions("dogtibetanmastiff:dogTibetanMastiff:audit")
    @RequestMapping(value = "changeStatus")
    @ResponseBody
    public String changeStatus(DogTibetanMastiff dogTibetanMastiff,Model model){
        if (!beanValidator(model, dogTibetanMastiff)){
            return "{\"rc\":-1,\"msg\":\"error\"}";
        }
        try{
            dogTibetanMastiffService.changeStatus(dogTibetanMastiff);
        } catch (ZAException e) {
            return "{\"rc\":"+e.get_code()+",\"msg\":\""+e.getMessage()+"\"}";
        }
        return "{\"rc\":0,\"msg\":\"success\"}";
    }

}