/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 犬只贴纸Entity
 *
 * @author lgl
 * @version 2018-11-26
 */
public class DogSticker extends DataEntity<DogSticker> {

    private static final long serialVersionUID = 1L;
    private String identificationFlag;        // 芯片号
    private String stickerNo;        // 贴纸号码
    private String stickerClass;        // 贴纸等级:1优宠级;2纯种级;3参赛级;4冠军级
    private String stickerClassName;        // 贴纸等级:1优宠级;2纯种级;3参赛级;4冠军级
    private String cabPassport;        // 宠爱护照号
    private String dogBreed;        // 犬种号
    private String dogGender;
    private String colorFlag;
    private String breedCnName;
    private String nameEn;        // 犬只英文名
    private Date birthday;

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getCabPassport() {
        return cabPassport;
    }

    public void setCabPassport(String cabPassport) {
        this.cabPassport = cabPassport;
    }

    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    public String getDogGender() {
        return dogGender;
    }

    public void setDogGender(String dogGender) {
        this.dogGender = dogGender;
    }

    public String getColorFlag() {
        return colorFlag;
    }

    public void setColorFlag(String colorFlag) {
        this.colorFlag = colorFlag;
    }

    public String getBreedCnName() {
        return breedCnName;
    }

    public void setBreedCnName(String breedCnName) {
        this.breedCnName = breedCnName;
    }

    public String getStickerClassName() {
        return stickerClassName;
    }

    public void setStickerClassName(String stickerClassName) {
        this.stickerClassName = stickerClassName;
    }

    public DogSticker() {
        super();
    }

    public DogSticker(String id) {
        super(id);
    }

    @Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
    public String getIdentificationFlag() {
        return identificationFlag;
    }

    public void setIdentificationFlag(String identificationFlag) {
        this.identificationFlag = identificationFlag;
    }

    @Length(min = 1, max = 20, message = "贴纸号码长度必须介于 1 和 20 之间")
    public String getStickerNo() {
        return stickerNo;
    }

    public void setStickerNo(String stickerNo) {
        this.stickerNo = stickerNo;
    }

    @Length(min = 1, max = 1, message = "贴纸等级:1优宠级;2纯种级;3参赛级;4冠军级长度必须介于 1 和 1 之间")
    public String getStickerClass() {
        return stickerClass;
    }

    public void setStickerClass(String stickerClass) {
        this.stickerClass = stickerClass;
    }

}