/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * DNA双亲比对Entity
 * @author lgl
 * @version 2016-11-24
 */
public class DogDnaParentsCompare extends DataEntity<DogDnaParentsCompare> {
	
	private static final long serialVersionUID = 1L;
	private Integer applySource;		// 办理来源(0:传统亲子比对1:升级2:申请)
	private String pedigreeCertified;		// 血统证书号
	private String birthCode;		// 出生纸编号
	private String paymentMemberCode;		// 付款会员号
	private String price;		// 订单价格
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	// 金质证书状态（0:降级1:正常）
	private Integer goldCertifiedState;
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间

	private Date create_date;		// 申请时间
	private Date beginCreateDate;		// 开始 create_date
	private Date endCreateDate;		// 结束 create_date

	private String name;//付款会员姓名
	private String dogName;//犬名
	private Date dogBirthday;		// 犬生日
	private String dogGender;		// 犬性别
	private String isCanceled;		// 是否撤销:否0；是1
	private String dogBreed;  //犬种

	private String paymentChargingItemId;		//收费项id

	private String fdogPedigreeCertified;		// 公犬证书号
	private String mdogPedigreeCertified;		// 母犬证书号
	private String fdogReviewUserId;		// 父犬主审核人ID
	private String mdogReviewUserId;		// 母犬主审核人ID
	
	private String fdogReviewState;
	
	private String mdogReviewState;

	public List<String> getBirthCodes() {
		return birthCodes;
	}

	public void setBirthCodes(List<String> birthCodes) {
		this.birthCodes = birthCodes;
	}

	private List<String> birthCodes;

	public String getParentDogPedigreeCertified() {
		return parentDogPedigreeCertified;
	}

	public void setParentDogPedigreeCertified(String parentDogPedigreeCertified) {
		this.parentDogPedigreeCertified = parentDogPedigreeCertified;
	}

	private String parentDogPedigreeCertified;

	public String getFdogReviewState() {
		return fdogReviewState;
	}

	public void setFdogReviewState(String fdogReviewState) {
		this.fdogReviewState = fdogReviewState;
	}

	public String getMdogReviewState() {
		return mdogReviewState;
	}

	public void setMdogReviewState(String mdogReviewState) {
		this.mdogReviewState = mdogReviewState;
	}

	public String getFdogReviewUserId() {
		return fdogReviewUserId;
	}

	public void setFdogReviewUserId(String fdogReviewUserId) {
		this.fdogReviewUserId = fdogReviewUserId;
	}

	public String getMdogReviewUserId() {
		return mdogReviewUserId;
	}

	public void setMdogReviewUserId(String mdogReviewUserId) {
		this.mdogReviewUserId = mdogReviewUserId;
	}

	public DogDnaParentsCompare() {
		super();
	}

	public DogDnaParentsCompare(String id){
		super(id);
	}

	public DogDnaParentsCompare(String runningNumber,String paymentChargingItemId,String paymentMemberCode){
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	public Integer getApplySource() {
		return applySource;
	}

	public void setApplySource(Integer applySource) {
		this.applySource = applySource;
	}

	@Length(min=1, max=64, message="出生纸编号长度必须介于 1 和 64 之间")
	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}
	
	@Length(min=1, max=64, message="付款会员号长度必须介于 1 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}
	
	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}
	
	@Length(min=1, max=20, message="审核状态长度必须介于 1 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public Integer getGoldCertifiedState() {
		return goldCertifiedState;
	}

	public void setGoldCertifiedState(Integer goldCertifiedState) {
		this.goldCertifiedState = goldCertifiedState;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=1, max=20, message="付款的状态长度必须介于 1 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public Date getCreate_date() {
		return create_date;
	}

	public void setCreate_date(Date create_date) {
		this.create_date = create_date;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getIsCanceled() {
		return isCanceled;
	}

	public void setIsCanceled(String isCanceled) {
		this.isCanceled = isCanceled;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}

	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	
}