package com.cku.oa.breeder.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.dao.PupDao;
import com.cku.oa.breeder.entity.Pup;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;
import java.util.List;

/**
 * 幼犬信息表Service
 *
 * @author lgl
 * @version 2018-01-12
 */
@Service
@Transactional(readOnly = true)
public class PupService extends CrudService<PupDao, Pup> {

    @Autowired
    private BlacklistService blacklistService;

    public Pup get(String id) {
        return super.get(id);
    }

    public List<Pup> findList(Pup pup) {
        return super.findList(pup);
    }

    public Page<Pup> findPage(Page<Pup> page, Pup pup) {
        return super.findPage(page, pup);
    }

    @Transactional(readOnly = false)
    public void save(Pup pup) {
        super.save(pup);
    }

    @Transactional(readOnly = false)
    public void delete(Pup pup) {
        super.delete(pup);
    }

    /**
     * @description: 幼犬信息发布及修改业务校验
     * @author: laiguanglong
     * @date: 2018/1/16 10:11
     */
    public void validateBusiness(Pup po) {
        //专业有效会员
        Member member = UserUtils.getLoginMember();
        if (!(MemberUtil.isProfessionalMember(member) && MemberUtil.isActiveMember(member))) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "仅限有限专业会员发布幼犬信息");
        }
        //不在黑名单中
        if (blacklistService.isInBlacklist(member.getMemberCode(), "pup")) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的发布权限已被取消，如有疑问，请致电宠爱王国客服！");
        }
        //幼犬年龄不能大于2岁
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(po.getBirthdate());
        calendar.add(Calendar.YEAR, 2);
        if (calendar.getTimeInMillis() < System.currentTimeMillis()) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已超出幼犬发布最高年限(2岁)");
        }
    }
}