define([ "knockout", "sammy" ], function(ko, Sammy) {
	//这里可以添加一些行为
	return function() {
		var self = this;
		//下面是基于js做的导航控制导航功能
		self.loading = ko.observable(false);
		self.moduleOptions = ko.observable({});
		self.loadError = ko.observableArray(false);
		self.updateError = ko.observable(false);
		//是否是商城模块
		self.isShop = ko.observable(false);
		//购物车数据
		self.carts = ko.observableArray([]);
		self.totalPrice = ko.observable("0");
		self.totalNum = ko.observable("0");
		//商城购物车
		self.shopGoodList = ko.observableArray([]);
		self.shopNum = ko.observable("0");
		self.shopTotalPrice = ko.observable("0");
		//导航条
		self.personalTrue = ko.observable(false);
		self.personalFalse = ko.observable(true);
		//会员信息
		self.member = ko.observable(userInfo.getMember());
		self.isMember = ko.observable(userInfo.isMember);
		self.user = ko.observable(userInfo.getUser());
		self.kennel = ko.observable(userInfo.getKennel());
		self.updateError.subscribe(function(error) {
			if (error) {
				alert(error);
				self.updateError(false);
			}
		});
		self.loadError.subscribe(function(error) {
			if (error) {
				self.moduleOptions({
					name : "error",
					data : {
						app : self
					}
				});
			}
		});
		/**
		 * 刷新购物车
		 */
		self.changeCart = function(){
            var sendData = {};
            sendData["home"] = "1";
			util.sendAjax({
				url:'finance/cart',
				data:sendData,
				async:false,
				type:'GET',
				cache:false,
				success:function(json){
					if(json.rc==0){
						self.carts(json.items);
						if(json.items!=null && json.items.length>0){
							var total = 0;
							var num = 0;
							$.each(json.items,function(index,item){
								total=parseFloat(total)+parseFloat(item.totalPrice);
								num = parseInt(num)+parseInt(item.num);
							});
							self.totalPrice(total.toFixed(2));
							self.totalNum(num); 
						}else{
							self.totalPrice("0.00");
							self.totalNum(0);
						}
					}else{
						layer.msg("刷新购物车失败,错误代码:"+json.rc+"错误信息:"+json.msg);
					}
				}
			});
		}
		/**
		 * 刷新商城购物车
		 */
		self.changeShopCart = function(){
            var sendData = {};
            sendData["home"] = "1";
			util.sendAjax({
				url:'shop/shopCarts',
				data:sendData,
				async:false,
				type:'GET',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var goodList = json.list;
						self.shopGoodList(goodList);
						var num = 0;
						var total = 0;
						for(var i=0;i<goodList.length;i++){
							num+=parseInt(goodList[i].goodsNum);
							total+=parseFloat(goodList[i].totalPrice);
						}
						self.shopNum(num);
						self.shopTotalPrice(total.toFixed(2));
					}else{
						layer.msg("刷新商城购物车失败,错误代码:"+json.rc+"错误信息:"+json.msg);
					}
				}
			});
		}
		/**
		 * 展现购物车
		 */
		self.showCarts = function(){
			if($("#cartPanel").css("display")=="none"){
				$("#cartPanel").css("display","block");
			}else{
				$("#cartPanel").css("display","none");
			}
		}
		//跳转到购物车
		self.toOrder = function(){
			$("#cartPanel").css("display","none");
			window.location.href="#/order/check";
		}
		/**
		 * 上面导航栏 change
		 * @param type
		 */
		self.changeTopNav = function(type){
			$("#topNav li").removeAttr("class");
			$("#subnav li").removeAttr("class");
			$("#"+type+"Nav").attr("class","active");
			if(type =="message"){
				self.personalTrue(false);
				self.personalFalse(true);
				window.location.href="#/message/remindlist";
			}else if(type=='member'){
				self.personalTrue(false);
				self.personalFalse(true);
				window.location.href="#home";
			}else if(type=="personal"){
				self.personalTrue(true);
				self.personalFalse(false);
				$("#subnav li[name=personalli]").attr("class","show");
				window.location.href="#/personal/index"
			}else if(type=="loginout"){
				window.location.href="../api/v1/open/logout"
				
			}else if(type=="cku"){
				self.personalTrue(false);
				self.personalFalse(true);
			}
			if($("#cartPanel").css("display")=="block"){
				$("#cartPanel").css("display","none");
			}
			
			$("#subnav li:visible").eq(0).find("dl").show();
			$("#subnav li:visible").eq(0).addClass("show");
			$("#subnav li:visible").eq(0).siblings().find("dl").hide();
			$("#subnav li:visible").eq(0).siblings().removeClass("show");
			
		};
		//初始化subnav 事件
		$(function(){
			//右侧导航条的点击事件
			$("#subnav li > a").click(function(){
				//当前标签页打开，兄弟标签页关闭
				$(this).parent().find("dl").slideDown("fast");
				$(this).parent().addClass("show");
				$(this).parent().siblings().find("dl").slideUp("fast");
				$(this).parent().siblings().removeClass("show");
				
			})
			$("#subnav li dl dd a").each(function(i) {
				$(this).on("click",{obj:$(this)},function(e){
					$("#subnav li dl dd a").removeAttr("class");
					e.data.obj.attr("class","active");
					if($("#cartPanel").css("display")=="block"){
						$("#cartPanel").css("display","none");
					}
				});
			});

			/**
			 * 初始化上侧，右侧导航条
			 */
			var realUrl = location.href;
			if(realUrl.indexOf("?")!=-1){
				realUrl = realUrl.split("?")[0];
			}
			if(realUrl.indexOf("#")==-1){
				$("#memberNav").addClass("active");
			}else{
				var routeUrl = realUrl.split("#")[1];
				if(routeUrl=='home'){
					$("#memberNav").addClass("active");
				}else{
					var type = routeUrl.split("/")[1];
					if(type=="message"){
						$("#messageNav").addClass("active");
					}else if(type=="personal"){
						$("#personalNav").addClass("active");
						self.personalTrue(true);
						self.personalFalse(false);
					}else if (type=="accountsecurity"){
						$("#personalNav").addClass("active");
						self.personalTrue(true);
						self.personalFalse(false);
					}else if(type=="coupon"){
						$("#personalNav").addClass("active");
						self.personalTrue(true);
						self.personalFalse(false);
					}else{
						$("#memberNav").addClass("active");
						self.personalTrue(false);
						self.personalFalse(true);
					}
				}
			}

			/**
			 * 初始化购物车
			 */
			if(userInfo.isMember){
				self.changeCart();
				self.changeShopCart();
			}
		});

		Sammy(function() {
			this.get('#home', function() {
				self.moduleOptions({
					name : "home",
					data : {
						app : self
					}
				});
				self.loading(true);
			});

			this.get(/\#\/([^/]+)\/([^/]+)/, function() {
				var module = this.params.splat[0];
				var action = this.params.splat[1];

				self.moduleOptions({
					name : module + "/" + action,
					data : {
						app : self,
						data : {}
					}
				});
				self.loading(true);
			});

			this.get('/index.html', function() {
				this.app.runRoute('get', '#home')
			});
		});

		Sammy().run();
	}
});