//商城订单详细
//商城订单
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //订单ID
        me.orderId = ko.observable("");
        //订单内容
        me.orderDetail = ko.observable({});
        //订单商品
        me.orderDetailList = ko.observableArray([]);
        //订单时间
        me.orderDate = ko.observable("");
        //倒计时
        me.downTime = ko.observable("");
        //显隐-倒计时
        me.showCountDown = ko.observable(true);
        me.timeRun = null;
        /**
         * 得到订单详情
         */
        me.getOrder = function(){
            util.sendAjax({
                url:'shop/shopOrder/'+me.orderId(),
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    console.log(json);
                    if(json.rc==0){
                        me.orderDetail(json.data);
                        me.orderDate(json.data.orderDate);
                        if(json.data.paymentState=="未缴费"){
                            var lastTime = util.formatDateShort(me.orderDate())+" 23:59:59";
                            var a = Math.floor(new Date(lastTime.replace(/-/g,"/")).getTime()/1000);
                            var b = Math.floor(new Date().getTime()/1000);
                            if(a>=b){
                                me.timeRun = setInterval( me.settime, 1000);
                            }else{
                                me.downTime("已过时");
                            }
                        }else{
                            me.showCountDown(false);
                        }
                        me.orderDetailList(json.data.orderDetailList);
                    }else{
                        layer.msg("查询订单详情失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        me.settime = function(){
            var lastTime = util.formatDateShort(me.orderDate())+" 23:59:59";
            var durTime = new Date(lastTime.replace(/-/g,"/")).getTime()-new Date().getTime();
            var hour = 0;
            var min = 0;
            var sen = 0;
            if(durTime>=60*60*1000){
                hour = Math.floor(durTime/(60*60*1000));
                durTime = durTime-(hour*60*60*1000);
                min = Math.floor(durTime/(60*1000));
                durTime = durTime-(min*60*1000);
                sen = Math.floor(durTime/1000);
                me.downTime(util.formatTwoLength(hour)+":"+util.formatTwoLength(min)+":"+util.formatTwoLength(sen));
            }else if(durTime>=60*1000){
                min = Math.floor(durTime/(60*1000));
                durTime = durTime-(min*60*1000);
                sen = Math.floor(durTime/1000);
                me.downTime(util.formatTwoLength(hour)+":"+util.formatTwoLength(min)+":"+util.formatTwoLength(sen));
            }else if(durTime>=1000){
                sen = Math.floor(durTime/1000);
                me.downTime(util.formatTwoLength(hour)+":"+util.formatTwoLength(min)+":"+util.formatTwoLength(sen));
            }else{
                me.downTime("已过时");
            }

        }
        $(function(){
            var obj = util.getQueryString();
            me.orderId(obj.id);
            me.getOrder();
        })
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(true);
    }
});