<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩播报管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        $(document).ready(function() {
			//回显裁判信息
			var judgeId = '${fns:unescapeHtml(showReportInfo.judgeId)}';
			var judgeIdArray = judgeId.split(",");
			$.each(judgeIdArray, function(i,val) {
				$("#judgeId").find("option[value='"+val+"']").attr("selected",true);
			});
			$("#judgeId").trigger("change");

            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"批量上传图片", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });

            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    loading('正在提交，请稍等...');
                    // form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

		function showImg(id){
			var src = $("#"+id+"Show").attr("src");
			if(src=="")
				return;
			parent.layer.open({
				type: 1,
				title: false,
				area: ['800px', '600px'],
				closeBtn: 0,
				skin: 'layui-layer-nobg', //没有背景色
				shadeClose: true,
				content: "<img src='"+src+"'>"
			});
		}

	</script>
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" action="${ctx}/show/showReportInfo/batchImage" method="post" enctype="multipart/form-data"
		  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
		<input id="uploadFile" name="batch" type="file" accept="application/zip" style="width:330px"/><br/><br/>　　
		<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
	</form>
</div>


<ul class="nav nav-tabs">
	<li><a href="${ctx}/show/showReportInfo/">犬展成绩播报列表</a></li>
	<li class="active">
		<a href="${ctx}/show/showReportInfo/form?id=${showReportInfo.id}">犬展成绩播报查看</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="showReportInfo" action="${ctx}/show/showReportInfo/save" method="post" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<div class="control-group">
		<label class="control-label">犬展地点：</label>
		<div class="controls">
			<form:select path="mainShowId" class="input-xlarge" disabled="true">
				<form:option value="" label="请选择主犬展"/>
				<form:options items="${allMain}" itemLabel="showLocation" itemValue="id" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group">
		<label class="control-label">犬展编号：</label>
		<div class="controls">
			<form:select path="showCode" class="input-xlarge" disabled="true">
				<option value="">请选择犬展编号</option>
				<form:options items="${allChild}" itemLabel="showCode" itemValue="showCode"></form:options>
			</form:select>
			<input type="text" id="showName" value="${showName}" class="input-xlarge" readonly>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">裁判名称：</label>
		<div class="controls">
			<form:select id="judgeId" path="judgeId"  class="input-xxlarge required" disabled="true">
				<form:option value="" label="请选择"/>
				<form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
			</form:select>
			<c:if test="${not empty showReportInfo.judgePic}">
				<img style="width: 50px;height: 50px;"  id="judgePicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.judgePic}">
				<span><a class="btn btn-success" onclick="showImg('judgePic')">预览</a></span>
			</c:if>
			<c:if test="${empty showReportInfo.judgePic}">
				<img  id="judgePicShow" src="">
			</c:if>
			<form:select id="judgeId2" path="judgeId2"  class="input-xxlarge" disabled="true">
				<form:option value="" label="请选择"/>
				<form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
			</form:select>
			<c:if test="${not empty showReportInfo.judgePic2}">
				<img style="width: 50px;height: 50px;"  id="judgePic2Show" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.judgePic2}">
				<span><a class="btn btn-success" onclick="showImg('judgePic2')">预览</a></span>
			</c:if>
			<c:if test="${empty showReportInfo.judgePic2}">
				<img  id="judgePic2Show" src="">
			</c:if>
			<form:select id="judgeId3" path="judgeId3"  class="input-xxlarge" disabled="true">
				<form:option value="" label="请选择"/>
				<form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
			</form:select>
			<c:if test="${not empty showReportInfo.judgePic3}">
				<img style="width: 50px;height: 50px;"  id="judgePic3Show" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.judgePic3}">
				<span><a class="btn btn-success" onclick="showImg('judgePic3')">预览</a></span>
			</c:if>
			<c:if test="${empty showReportInfo.judgePic3}">
				<img  id="judgePic3Show" src="">
			</c:if>
		</div>
	</div>
	<div style="clear:both;"></div>

	<div class="control-group">
		<label class="control-label">裁判照片：</label>
		<div class="controls">


		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group">
		<label class="control-label">BIS队列照：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bisPic }">
				<img style="width: 50px;height: 50px;"  id="bisPicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bisPic}">
			</c:if>
			<c:if test="${empty showReportInfo.bisPic }">
				<img  id="bisPicShow" src="">
			</c:if>
			<span><a class="btn btn-success" onclick="showImg('bisPic')">预览</a></span>

		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group" >
		<label class="control-label">BIS1序号：</label>
		<div class="controls">
			<form:input path="bis1Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('bis1')" class="input-xlarge " />
		</div>
	</div>
	<div class="control-group ">
		<label class="control-label">BIS1图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bis1Pic }">
				<img style="width: 50px;height: 50px;"  id="bis1PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bis1Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bis1Pic }">
				<img  id="bis1PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bis1Pic')">预览</a></span>


		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bis1DogName" value="${bis1Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bis1DogSex" value="${bis1Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bis1DogType" value="${bis1Score.dogTypeZh}   ${bis1Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bis1DogOwner" value="${bis1Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BIS2序号：</label>
		<div class="controls">
			<form:input path="bis2Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('bis2')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BIS2图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bis2Pic }">
				<img style="width: 50px;height: 50px;"  id="bis2PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bis2Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bis2Pic }">
				<img  id="bis2PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bis2Pic')">预览</a></span>
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bis2DogName" value="${bis2Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bis2DogSex" value="${bis2Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bis2DogType" value="${bis2Score.dogTypeZh}   ${bis2Score.dogTypeEn}"  name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bis2DogOwner" value="${bis2Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">BIS3序号：</label>
		<div class="controls">
			<form:input path="bis3Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('bis3')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BIS3图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bis3Pic }">
				<img style="width: 50px;height: 50px;"  id="bis3PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bis3Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bis3Pic }">
				<img  id="bis3PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bis3Pic')">预览</a></span>
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bis3DogName" value="${bis3Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bis3DogSex" value="${bis3Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bis3DogType" value="${bis3Score.dogTypeZh}   ${bis3Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bis3DogOwner" value="${bis3Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">BIS4序号：</label>
		<div class="controls">
			<form:input path="bis4Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('bis4')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">BIS4图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bis4Pic }">
				<img style="width: 50px;height: 50px;"  id="bis4PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bis4Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bis4Pic }">
				<img  id="bis4PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bis4Pic')">预览</a></span>
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bis4DogName" value="${bis4Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bis4DogSex" value="${bis4Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bis4DogType" value="${bis4Score.dogTypeZh}   ${bis4Score.dogTypeEn}" name="scoreDogType"   class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bis4DogOwner" value="${bis4Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">JBIS队列照：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.jbisPic }">
				<img style="width: 50px;height: 50px;"  id="jbisPicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.jbisPic}">
			</c:if>
			<c:if test="${empty showReportInfo.jbisPic }">
				<img  id="jbisPicShow" src="">
			</c:if>
			<span><a class="btn btn-success" onclick="showImg('jbisPic')">预览</a></span>
		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group">
		<label class="control-label">JBIS1序号：</label>
		<div class="controls">
			<form:input path="jbis1Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('jbis1')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">JBIS1图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.jbis1Pic }">
				<img style="width: 50px;height: 50px;"  id="jbis1PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.jbis1Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.jbis1Pic }">
				<img  id="jbis1PicShow" src="">
			</c:if>
			<span><a class="btn btn-success" onclick="showImg('jbis1Pic')">预览</a></span>
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="jbis1DogName" value="${jbis1Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="jbis1DogSex" value="${jbis1Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="jbis1DogType" value="${jbis1Score.dogTypeZh}   ${jbis1Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="jbis1DogOwner" value="${jbis1Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">JBIS2序号：</label>
		<div class="controls">
			<form:input path="jbis2Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('jbis2')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">JBIS2图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.jbis2Pic }">
				<img style="width: 50px;height: 50px;"  id="jbis2PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.jbis2Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.jbis2Pic }">
				<img  id="jbis2PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('jbis2Pic')">预览</a></span>
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="jbis2DogName" value="${jbis2Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="jbis2DogSex" value="${jbis2Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="jbis2DogType" value="${jbis2Score.dogTypeZh}   ${jbis2Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="jbis2DogOwner" value="${jbis2Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">JBIS3序号：</label>
		<div class="controls">
			<form:input path="jbis3Order" htmlEscape="false" maxlength="10"  disabled="true" onblur="findScore('jbis3')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">JBIS3图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.jbis3Pic }">
				<img style="width: 50px;height: 50px;"  id="jbis3PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.jbis3Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.jbis3Pic }">
				<img  id="jbis3PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('jbis3Pic')">预览</a></span>
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="jbis3DogName" value="${jbis3Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="jbis3DogSex" value="${jbis3Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="jbis3DogType" value="${jbis3Score.dogTypeZh}   ${jbis3Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="jbis3DogOwner" value="${jbis3Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">JBIS4序号：</label>
		<div class="controls">
			<form:input path="jbis4Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('jbis4')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">JBIS4图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.jbis4Pic }">
				<img style="width: 50px;height: 50px;"  id="jbis4PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.jbis4Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.jbis4Pic }">
				<img  id="jbis4PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('jbis4Pic')">预览</a></span>

		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="jbis4DogName" value="${jbis4Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="jbis4DogSex" value="${jbis4Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="jbis4DogType" value="${jbis4Score.dogTypeZh}   ${jbis4Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="jbis4DogOwner" value="${jbis4Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">PBIS队列照：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.pbisPic }">
				<img style="width: 50px;height: 50px;"  id="pbisPicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.pbisPic}">
			</c:if>
			<c:if test="${empty showReportInfo.pbisPic }">
				<img  id="pbisPicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('pbisPic')">预览</a></span>

		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group">
		<label class="control-label">PBIS1序号：</label>
		<div class="controls">
			<form:input path="pbis1Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('pbis1')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS1图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.pbis1Pic }">
				<img style="width: 50px;height: 50px;"  id="pbis1PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.pbis1Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.pbis1Pic }">
				<img  id="pbis1PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('pbis1Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="pbis1DogName" value="${pbis1Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="pbis1DogSex" value="${pbis1Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="pbis1DogType" value="${pbis1Score.dogTypeZh}   ${pbis1Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="pbis1DogOwner" value="${pbis1Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS2序号：</label>
		<div class="controls">
			<form:input path="pbis2Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('pbis2')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS2图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.pbis2Pic }">
				<img style="width: 50px;height: 50px;"  id="pbis2PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.pbis2Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.pbis2Pic }">
				<img  id="pbis2PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('pbis2Pic')">预览</a></span>

		</div>
	</div>


	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="pbis2DogName" value="${pbis2Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="pbis2DogSex" value="${pbis2Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="pbis2DogType" value="${pbis2Score.dogTypeZh}   ${pbis2Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="pbis2DogOwner" value="${pbis2Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS3序号：</label>
		<div class="controls">
			<form:input path="pbis3Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('pbis3')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS3图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.pbis3Pic }">
				<img style="width: 50px;height: 50px;"  id="pbis3PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.pbis3Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.pbis3Pic }">
				<img  id="pbis3PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('pbis3Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="pbis3DogName" value="${pbis3Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="pbis3DogSex" value="${pbis3Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="pbis3DogType" value="${pbis3Score.dogTypeZh}   ${pbis3Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="pbis3DogOwner" value="${pbis3Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">PBIS4序号：</label>
		<div class="controls">
			<form:input path="pbis4Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('pbis4')" class="input-xlarge "/>
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">PBIS4图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.pbis4Pic }">
				<img style="width: 50px;height: 50px;"  id="pbis4PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.pbis4Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.pbis4Pic }">
				<img  id="pbis4PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('pbis4Pic')">预览</a></span>

		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="pbis4DogName" value="${pbis4Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="pbis4DogSex" value="${pbis4Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="pbis4DogType" value="${pbis4Score.dogTypeZh}   ${pbis4Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="pbis4DogOwner" value="${pbis4Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BBIS队列照：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bbisPic }">
				<img style="width: 50px;height: 50px;"  id="bbisPicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bbisPic}">
			</c:if>
			<c:if test="${empty showReportInfo.bbisPic }">
				<img  id="bbisPicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bbisPic')">预览</a></span>

		</div>
	</div>
	<div style = "clear:both;"></div>
	<div class="control-group">
		<label class="control-label">BBIS1序号：</label>
		<div class="controls">
			<form:input path="bbis1Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('bbis1')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">BBIS1图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bbis1Pic }">
				<img style="width: 50px;height: 50px;"  id="bbis1PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bbis1Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bbis1Pic }">
				<img  id="bbis1PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bbis1Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bbis1DogName" value="${bbis1Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bbis1DogSex" value="${bbis1Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bbis1DogType" value="${bbis1Score.dogTypeZh}   ${bbis1Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bbis1DogOwner" value="${bbis1Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BBIS2序号：</label>
		<div class="controls">
			<form:input path="bbis2Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('bbis2')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">BBIS2图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bbis2Pic }">
				<img style="width: 50px;height: 50px;"  id="bbis2PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bbis2Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bbis2Pic }">
				<img  id="bbis2PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bbis2Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bbis2DogName" value="${bbis2Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bbis2DogSex" value="${bbis2Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bbis2DogType" value="${bbis2Score.dogTypeZh}   ${bbis2Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bbis2DogOwner" value="${bbis2Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">BBIS3序号：</label>
		<div class="controls">
			<form:input path="bbis3Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('bbis3')" class="input-xlarge "/>
		</div>
	</div>


	<div class="control-group">
		<label class="control-label">BBIS3图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bbis3Pic }">
				<img style="width: 50px;height: 50px;"  id="bbis3PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bbis3Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bbis3Pic }">
				<img  id="bbis3PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bbis3Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bbis3DogName" value="${bbis3Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bbis3DogSex" value="${bbis3Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bbis3DogType" value="${bbis3Score.dogTypeZh}   ${bbis3Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bbis3DogOwner" value="${bbis3Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group">
		<label class="control-label">BBIS4序号：</label>
		<div class="controls">
			<form:input path="bbis4Order" htmlEscape="false" maxlength="10" disabled="true" onblur="findScore('bbis4')" class="input-xlarge "/>
		</div>
	</div>



	<div class="control-group">
		<label class="control-label">BBIS4图片：</label>
		<div class="controls">
			<c:if test="${not empty showReportInfo.bbis4Pic }">
				<img style="width: 50px;height: 50px;"  id="bbis4PicShow" src="${pageContext.request.contextPath}/api/v1/open/image/${showReportInfo.bbis4Pic}">
			</c:if>
			<c:if test="${empty showReportInfo.bbis4Pic }">
				<img  id="bbis4PicShow" src="">
			</c:if>

			<span><a class="btn btn-success" onclick="showImg('bbis4Pic')">预览</a></span>

		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">犬名：</label>
		<div class="controls">
			<input type="text" readonly id="bbis4DogName" value="${bbis4Score.dogName}" name="scoreDogName"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">性别：</label>
		<div class="controls">
			<input type="text" readonly id="bbis4DogSex" value="${bbis4Score.dogSex}" name="scoreDogSex"  class="input-xlarge ">
		</div>
	</div>

	<div class="control-group" >
		<label class="control-label">品种：</label>
		<div class="controls">
			<input type="text" readonly id="bbis4DogType" value="${bbis4Score.dogTypeZh}   ${bbis4Score.dogTypeEn}" name="scoreDogType"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">犬主：</label>
		<div class="controls">
			<input type="text" readonly id="bbis4DogOwner" value="${bbis4Score.dogOwnerZh}" name="scoreDogOwner"  class="input-xlarge ">
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">备注信息：</label>
		<div class="controls">
			<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " disabled="true"/>
		</div>
	</div>
	<div style = "clear:both;"></div>


	<div class="form-actions">
		<shiro:hasPermission name="show:showReportInfo:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>