<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展播报信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"批量上传图片", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });

			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				rules:{
					mainShowId:{
						required:true
					},
					showCode:{
						required:true
					}
				}, 
				messages:{
					mainShowId:{
						required:"犬展地点不能为空"
					},
					showCode:{
						required:"犬展编号不能为空"
					}
				},  
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

        function deleteImg(type){
            $("#"+type+"Show").attr("src","");
            $("#"+type+"Show").removeAttr("style");
            $("#"+type).val("");
        }
        function showImg(type){
            var src = $("#"+type+"Show").attr("src");
            if(src=="")
                return;
            parent.layer.open({
                type: 1,
                title: false,
                area: ['800px', '600px'],
                closeBtn: 0,
                skin: 'layui-layer-nobg', //没有背景色
                shadeClose: true,
                content: "<img src='"+src+"'>"
            });
            ;
		}
		var childMap = {};
        //var judgeMap = {};

        function checkMainShow(){
            var mainShowId =$("#mainShowId").val();
            if(mainShowId==""){
                $("#showCode").val("").trigger("change");
                //$("#judgeId").val("").trigger("change");
                return;
			}
            $.post('${ctx}/show/showReportInfo/findChildShowsByMainShowId', {
                mainShowId: mainShowId
            }, function(data) {
				if(data!=null && data.length>0){
				    var html = "<option value=\"\" selected>请选择犬展编号</option>";
				    for(var i=0;i<data.length;i++){
				        html+="<option value='"+data[i].showCode+"'>"+data[i].showCode+"</option>";
				        var refereeIds = data[i].referee;
                        childMap[data[i].showCode] = data[i].showName;
                        //judgeMap[data[i].showCode] = data[i].referee;
					};
				    $("#showCode").html(html);
				}
                $("#showCode").val("").trigger("change");
            });

            <%--$.post('${ctx}/show/showReportInfo/findJudgeByMainShowId', {--%>
                <%--mainShowId: mainShowId--%>
            <%--}, function(data) {--%>
                <%--if(data!=null && data.length>0){--%>
                    <%--var html = "<option value=\"\" selected>请选择裁判</option>";--%>
                    <%--for(var i=0;i<data.length;i++){--%>
                        <%--html+="<option value='"+data[i].id+"'>"+data[i].judgeName+"</option>"--%>
                    <%--};--%>
                    <%--$("#judgeId").html(html);--%>
                <%--}--%>
                <%--$("#judgeId").val("").trigger("change");--%>
            <%--});--%>
		};


        function showShowName(){
            var showCode = $("#showCode").val();
            $("#showName").val(childMap[showCode]);
            //$("#judgeId").val(judgeMap[showCode]);
            if(showCode != ''){
				/*$.post('${ctx}/show/showReportInfo/findJudgeNameById', {
					judgeId: judgeMap[showCode]
				}, function(data) {
					$("#judgeName").val(data);
				});*/
				refreshScoreByShowCode();
			}
		}

		function refreshScoreByShowCode() {
			var showCode = $("#showCode").val();
			$.post('${ctx}/show/showReportInfo/findAllScoreByShowCode', {
				showCode: showCode
			}, function(json) {
				if (json.rc == '0') {
					//bis
					if (json.data.bis1.orderCode != undefined) {
						$("#bis1Order").val(json.data.bis1.orderCode);
						$("#bis1DogName").val(json.data.bis1.dogName);
						$("#bis1DogSex").val(json.data.bis1.dogGender == '1' ? '公' : '母');
						$("#bis1DogType").val(json.data.bis1.breedCnName + "   " + json.data.bis1.breedEnName);
						$("#bis1DogOwner").val(json.data.bis1.dogOwnerNameCn);
					}
					if (json.data.bis2.orderCode != undefined) {
						$("#bis2Order").val(json.data.bis2.orderCode);
						$("#bis2DogName").val(json.data.bis2.dogName);
						$("#bis2DogSex").val(json.data.bis2.dogGender == '1' ? '公' : '母');
						$("#bis2DogType").val(json.data.bis2.breedCnName + "   " + json.data.bis2.breedEnName);
						$("#bis2DogOwner").val(json.data.bis2.dogOwnerNameCn);
					}
					if (json.data.bis3.orderCode != undefined) {
						$("#bis3Order").val(json.data.bis3.orderCode);
						$("#bis3DogName").val(json.data.bis3.dogName);
						$("#bis3DogSex").val(json.data.bis3.dogGender == '1' ? '公' : '母');
						$("#bis3DogType").val(json.data.bis3.breedCnName + "   " + json.data.bis3.breedEnName);
						$("#bis3DogOwner").val(json.data.bis3.dogOwnerNameCn);
					}
					if (json.data.bis4.orderCode != undefined) {
						$("#bis4Order").val(json.data.bis4.orderCode);
						$("#bis4DogName").val(json.data.bis4.dogName);
						$("#bis4DogSex").val(json.data.bis4.dogGender == '1' ? '公' : '母');
						$("#bis4DogType").val(json.data.bis4.breedCnName + "   " + json.data.bis4.breedEnName);
						$("#bis4DogOwner").val(json.data.bis4.dogOwnerNameCn);
					}
					//jbis
					if (json.data.jbis1.orderCode != undefined) {
						$("#jbis1Order").val(json.data.jbis1.orderCode);
						$("#jbis1DogName").val(json.data.jbis1.dogName);
						$("#jbis1DogSex").val(json.data.jbis1.dogGender == '1' ? '公' : '母');
						$("#jbis1DogType").val(json.data.jbis1.breedCnName + "   " + json.data.jbis1.breedEnName);
						$("#jbis1DogOwner").val(json.data.jbis1.dogOwnerNameCn);
					}
					if (json.data.jbis2.orderCode != undefined) {
						$("#jbis2Order").val(json.data.jbis2.orderCode);
						$("#jbis2DogName").val(json.data.jbis2.dogName);
						$("#jbis2DogSex").val(json.data.jbis2.dogGender == '1' ? '公' : '母');
						$("#jbis2DogType").val(json.data.jbis2.breedCnName + "   " + json.data.jbis2.breedEnName);
						$("#jbis2DogOwner").val(json.data.jbis2.dogOwnerNameCn);
					}
					if (json.data.jbis3.orderCode != undefined) {
						$("#jbis3Order").val(json.data.jbis3.orderCode);
						$("#jbis3DogName").val(json.data.jbis3.dogName);
						$("#jbis3DogSex").val(json.data.jbis3.dogGender == '1' ? '公' : '母');
						$("#jbis3DogType").val(json.data.jbis3.breedCnName + "   " + json.data.jbis3.breedEnName);
						$("#jbis3DogOwner").val(json.data.jbis3.dogOwnerNameCn);
					}
					if (json.data.jbis4.orderCode != undefined) {
						$("#jbis4Order").val(json.data.jbis4.orderCode);
						$("#jbis4DogName").val(json.data.jbis4.dogName);
						$("#jbis4DogSex").val(json.data.jbis4.dogGender == '1' ? '公' : '母');
						$("#jbis4DogType").val(json.data.jbis4.breedCnName + "   " + json.data.jbis4.breedEnName);
						$("#jbis4DogOwner").val(json.data.jbis4.dogOwnerNameCn);
					}
					//pbis
					if (json.data.pbis1.orderCode != undefined) {
						$("#pbis1Order").val(json.data.pbis1.orderCode);
						$("#pbis1DogName").val(json.data.pbis1.dogName);
						$("#pbis1DogSex").val(json.data.pbis1.dogGender == '1' ? '公' : '母');
						$("#pbis1DogType").val(json.data.pbis1.breedCnName + "   " + json.data.pbis1.breedEnName);
						$("#pbis1DogOwner").val(json.data.pbis1.dogOwnerNameCn);
					}
					if (json.data.pbis2.orderCode != undefined) {
						$("#pbis2Order").val(json.data.pbis2.orderCode);
						$("#pbis2DogName").val(json.data.pbis2.dogName);
						$("#pbis2DogSex").val(json.data.pbis2.dogGender == '1' ? '公' : '母');
						$("#pbis2DogType").val(json.data.pbis2.breedCnName + "   " + json.data.pbis2.breedEnName);
						$("#pbis2DogOwner").val(json.data.pbis2.dogOwnerNameCn);
					}
					if (json.data.pbis3.orderCode != undefined) {
						$("#pbis3Order").val(json.data.pbis3.orderCode);
						$("#pbis3DogName").val(json.data.pbis3.dogName);
						$("#pbis3DogSex").val(json.data.pbis3.dogGender == '1' ? '公' : '母');
						$("#pbis3DogType").val(json.data.pbis3.breedCnName + "   " + json.data.pbis3.breedEnName);
						$("#pbis3DogOwner").val(json.data.pbis3.dogOwnerNameCn);
					}
					if (json.data.pbis4.orderCode != undefined) {
						$("#pbis4Order").val(json.data.pbis4.orderCode);
						$("#pbis4DogName").val(json.data.pbis4.dogName);
						$("#pbis4DogSex").val(json.data.pbis4.dogGender == '1' ? '公' : '母');
						$("#pbis4DogType").val(json.data.pbis4.breedCnName + "   " + json.data.pbis4.breedEnName);
						$("#pbis4DogOwner").val(json.data.pbis4.dogOwnerNameCn);
					}
					//bbis
					if (json.data.bbis1.orderCode != undefined) {
						$("#bbis1Order").val(json.data.bbis1.orderCode);
						$("#bbis1DogName").val(json.data.bbis1.dogName);
						$("#bbis1DogSex").val(json.data.bbis1.dogGender == '1' ? '公' : '母');
						$("#bbis1DogType").val(json.data.bbis1.breedCnName + "   " + json.data.bbis1.breedEnName);
						$("#bbis1DogOwner").val(json.data.bbis1.dogOwnerNameCn);
					}
					if (json.data.bbis2.orderCode != undefined) {
						$("#bbis2Order").val(json.data.bbis2.orderCode);
						$("#bbis2DogName").val(json.data.bbis2.dogName);
						$("#bbis2DogSex").val(json.data.bbis2.dogGender == '1' ? '公' : '母');
						$("#bbis2DogType").val(json.data.bbis2.breedCnName + "   " + json.data.bbis2.breedEnName);
						$("#bbis2DogOwner").val(json.data.bbis2.dogOwnerNameCn);
					}
					if (json.data.bbis3.orderCode != undefined) {
						$("#bbis3Order").val(json.data.bbis3.orderCode);
						$("#bbis3DogName").val(json.data.bbis3.dogName);
						$("#bbis3DogSex").val(json.data.bbis3.dogGender == '1' ? '公' : '母');
						$("#bbis3DogType").val(json.data.bbis3.breedCnName + "   " + json.data.bbis3.breedEnName);
						$("#bbis3DogOwner").val(json.data.bbis3.dogOwnerNameCn);
					}
					if (json.data.bbis4.orderCode != undefined) {
						$("#bbis4Order").val(json.data.bbis4.orderCode);
						$("#bbis4DogName").val(json.data.bbis4.dogName);
						$("#bbis4DogSex").val(json.data.bbis4.dogGender == '1' ? '公' : '母');
						$("#bbis4DogType").val(json.data.bbis4.breedCnName + "   " + json.data.bbis4.breedEnName);
						$("#bbis4DogOwner").val(json.data.bbis4.dogOwnerNameCn);
					}
				} else {
					alert(json.msg)
				}
			});
		}

		function findScore(type){
            var showCode = $("#showCode").val();
            var order = $("#"+type+"Order").val();

            if(showCode=='' || showCode==null){
                parent.layer.alert('请选择犬展编号!');
				return;
            };
            if(order=='' || order == null){
                parent.layer.alert('请填写秩序号!');
                return;
            }
            $.post('${ctx}/show/showReportInfo/findScore', {
                showCode: showCode,
                order:order
            }, function(data) {
                if(data==null || data==''){
                    parent.layer.alert("此犬展编号"+showCode+"没有秩序号为"+order+"记录！");
				}else{
					$("#"+type+"DogName").val(data.dogName);
                    $("#"+type+"DogSex").val(data.dogSex);
                    $("#"+type+"DogType").val(data.dogTypeZh+"   "+data.dogTypeEn);
                    $("#"+type+"DogOwner").val(data.dogOwnerZh);
				}
            });

		}
	</script>
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<div id="importBox" class="hide">
	<form id="importForm" action="${ctx}/show/showReportInfo/batchImage" method="post" enctype="multipart/form-data"
		  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
		<input id="uploadFile" name="batch" type="file" accept="application/zip" style="width:330px"/><br/><br/>　　
		<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
	</form>
</div>


	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/showReportInfo/">犬展成绩播报列表</a></li>
		<li class="active">
			<a href="${ctx}/show/showReportInfo/addForm?id=${showReportInfo.id}">犬展成绩播报添加</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showReportInfo" action="${ctx}/show/showReportInfo/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">犬展地点：</label>
			<div class="controls">
				<form:select path="mainShowId" class="input-xlarge" onchange="checkMainShow()">
					<form:option value="" label="请选择主犬展"/>
					<form:options items="${allMain}" itemLabel="showLocation" itemValue="id" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
				<form:select path="showCode" class="input-xlarge" onchange="showShowName()">
					<option value="">请选择犬展编号</option>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<input type="text" id="showName" value="" class="input-xlarge" readonly>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">裁判名称：</label>
			<div class="controls">
				<!--  <form:hidden path="judgeId" />
				<input type="text" id="judgeName" class="input-xlarge" readonly />-->
				 <form:select id="judgeId" path="judgeId" class="input-xlarge">
				 		<option value="">请选择裁判</option>
                        <form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
                 </form:select>
			</div>
		</div>
		<div style = "clear:both;"></div>

		<div class="control-group">
			<label class="control-label">裁判照片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="judgePic" label="请上传裁判照片" fileId="${showReportInfo.judgePic}" requestMapping="/showReport/judgePic"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">BIS队列照：</label>
			<div class="controls">
					<sys:cropperImageUpload id="bisPic" label="请上传BIS队列照" fileId="${showReportInfo.bisPic}" requestMapping="/showReport/bisPic"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group" >
			<label class="control-label">BIS1序号：</label>
			<div class="controls">
				<form:input path="bis1Order" htmlEscape="false" maxlength="10" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group ">
			<label class="control-label">BIS1图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bis1Pic" label="请上传BIS1图片" fileId="${showReportInfo.bis1Pic}" requestMapping="/showReport/bis1Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bis1DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bis1DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bis1DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bis1DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BIS2序号：</label>
			<div class="controls">
				<form:input path="bis2Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BIS2图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bis2Pic" label="请上传BIS2图片" fileId="${showReportInfo.bis2Pic}" requestMapping="/showReport/bis2Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bis2DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bis2DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bis2DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bis2DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIS3序号：</label>
			<div class="controls">
				<form:input path="bis3Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BIS3图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bis3Pic" label="请上传BIS3图片" fileId="${showReportInfo.bis3Pic}" requestMapping="/showReport/bis3Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bis3DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bis3DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bis3DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bis3DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIS4序号：</label>
			<div class="controls">
				<form:input path="bis4Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">BIS4图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bis4Pic" label="请上传BIS4图片" fileId="${showReportInfo.bis4Pic}" requestMapping="/showReport/bis4Pic"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bis4DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bis4DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bis4DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bis4DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">JBIS队列照：</label>
			<div class="controls">
					<sys:cropperImageUpload id="jbisPic" label="请上传JBIS队列照" fileId="${showReportInfo.jbisPic}" requestMapping="/showReport/jbisPic"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">JBIS1序号：</label>
			<div class="controls">
				<form:input path="jbis1Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">JBIS1图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="jbis1Pic" label="请上传JBIS1队列照" fileId="${showReportInfo.jbis1Pic}" requestMapping="/showReport/jbis1Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="jbis1DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="jbis1DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="jbis1DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="jbis1DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">JBIS2序号：</label>
			<div class="controls">
				<form:input path="jbis2Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">JBIS2图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="jbis2Pic" label="请上传JBIS2队列照" fileId="${showReportInfo.jbis2Pic}" requestMapping="/showReport/jbis2Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="jbis2DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="jbis2DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="jbis2DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="jbis2DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">JBIS3序号：</label>
			<div class="controls">
				<form:input path="jbis3Order" htmlEscape="false" maxlength="10"  class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">JBIS3图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="jbis3Pic" label="请上传JBIS3队列照" fileId="${showReportInfo.jbis3Pic}" requestMapping="/showReport/jbis3Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="jbis3DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="jbis3DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="jbis3DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="jbis3DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">JBIS4序号：</label>
			<div class="controls">
				<form:input path="jbis4Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">JBIS4图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="jbis4Pic" label="请上传JBIS4队列照" fileId="${showReportInfo.jbis4Pic}" requestMapping="/showReport/jbis4Pic"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="jbis4DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="jbis4DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="jbis4DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="jbis4DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">PBIS队列照：</label>
			<div class="controls">
				<sys:cropperImageUpload id="pbisPic" label="请上传PBIS队列照" fileId="${showReportInfo.pbisPic}" requestMapping="/showReport/pbisPic"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">PBIS1序号：</label>
			<div class="controls">
				<form:input path="pbis1Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS1图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="pbis1Pic" label="请上传PBIS1队列照" fileId="${showReportInfo.pbis1Pic}" requestMapping="/showReport/pbis1Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="pbis1DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="pbis1DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="pbis1DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="pbis1DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS2序号：</label>
			<div class="controls">
				<form:input path="pbis2Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS2图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="pbis2Pic" label="请上传PBIS2队列照" fileId="${showReportInfo.pbis2Pic}" requestMapping="/showReport/pbis2Pic"/>
			</div>
		</div>


		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="pbis2DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="pbis2DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="pbis2DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="pbis2DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS3序号：</label>
			<div class="controls">
				<form:input path="pbis3Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS3图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="pbis3Pic" label="请上传PBIS3队列照" fileId="${showReportInfo.pbis3Pic}" requestMapping="/showReport/pbis3Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="pbis3DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="pbis3DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="pbis3DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="pbis3DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">PBIS4序号：</label>
			<div class="controls">
				<form:input path="pbis4Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">PBIS4图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="pbis4Pic" label="请上传PBIS4队列照" fileId="${showReportInfo.pbis4Pic}" requestMapping="/showReport/pbis4Pic"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="pbis4DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="pbis4DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="pbis4DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="pbis4DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BBIS队列照：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bbisPic" label="请上传BBIS图片" fileId="${showReportInfo.bbisPic}" requestMapping="/showReport/bbisPic"/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">BBIS1序号：</label>
			<div class="controls">
				<form:input path="bbis1Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">BBIS1图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bbis1Pic" label="请上传BBIS1图片" fileId="${showReportInfo.bbis1Pic}" requestMapping="/showReport/bbis1Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bbis1DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bbis1DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bbis1DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bbis1DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BBIS2序号：</label>
			<div class="controls">
				<form:input path="bbis2Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">BBIS2图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bbis2Pic" label="请上传BBIS2图片" fileId="${showReportInfo.bbis2Pic}" requestMapping="/showReport/bbis2Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bbis2DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bbis2DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bbis2DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bbis2DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBIS3序号：</label>
			<div class="controls">
				<form:input path="bbis3Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>


		<div class="control-group">
			<label class="control-label">BBIS3图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bbis3Pic" label="请上传BBIS3图片" fileId="${showReportInfo.bbis3Pic}" requestMapping="/showReport/bbis3Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bbis3DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bbis3DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bbis3DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bbis3DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">BBIS4序号：</label>
			<div class="controls">
				<form:input path="bbis4Order" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>



		<div class="control-group">
			<label class="control-label">BBIS4图片：</label>
			<div class="controls">
				<sys:cropperImageUpload id="bbis4Pic" label="请上传BBIS4图片" fileId="${showReportInfo.bbis4Pic}" requestMapping="/showReport/bbis4Pic"/>
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">犬名：</label>
			<div class="controls">
				<input type="text" readonly id="bbis4DogName" name="scoreDogName"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">性别：</label>
			<div class="controls">
				<input type="text" readonly id="bbis4DogSex" name="scoreDogSex"  class="input-xlarge ">
			</div>
		</div>

		<div class="control-group" >
			<label class="control-label">品种：</label>
			<div class="controls">
				<input type="text" readonly id="bbis4DogType" name="scoreDogType"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">犬主：</label>
			<div class="controls">
				<input type="text" readonly id="bbis4DogOwner" name="scoreDogOwner"  class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div style = "clear:both;"></div>


		<div class="form-actions">
			<shiro:hasPermission name="show:showReportInfo:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>