<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>赛事审查员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/groomer/groomerShowReferee/">美容师审查员列表</a></li>
		<li class="active"><a href="${ctx}/groomer/groomerShowReferee/form?id=${groomerShowReferee.id}">美容师审查员查看<shiro:hasPermission name="referee:showReferee:edit">${not empty showReferee.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="referee:showReferee:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerShowReferee" action="${ctx}/groomer/groomerShowReferee/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">审查员中文名：</label>
			<div class="controls">
				<form:input path="refereeNameCn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员英文名：</label>
			<div class="controls">
				<form:input path="refereeNameEn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员性别：</label>
			<div class="controls">
				<form:select path="refereeSex" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('sex')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员国籍：</label>
			<div class="controls">
				<form:input path="refereeCitizenship" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员图片：</label>
			<div class="controls">
				<img  style="max-width:200px;" src="${ctx }/sys/file/image/${groomerShowReferee.refereePicture }">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员签名照片：</label>
			<div class="controls">
				<img  style="max-width:200px;" src="${ctx }/sys/file/image/${groomerShowReferee.refereeSignaturePhoto }">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员介绍：</label>
			<div class="controls">
				<form:input path="refereeIntroduce" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员类型：</label>
			<div class="controls">
				<form:select path="refereeType" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('show_referee_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员头衔：</label>
			<div class="controls">
				<form:input path="refereeTitle" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">link_order：</label>
			<div class="controls">
				<form:input path="refereeLinkOrder" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>