<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//回显合作机构
			$('#orgId').append("<option value ='${dogPedigreeCertifiedChange.orgId}'>${dogPedigreeCertifiedChange.orgName}</option>");
			$("#orgId").trigger("change");

			//显示不正确的犬种
			var reg = /[\u4e00-\u9fa5]/g;
			var flag = reg.test('${dogPedigreeCertifiedChange.dogBreed}');
			if(flag==true){
				$('#errorDogBreed').html('<font color="#FF0000">${dogPedigreeCertifiedChange.dogBreed}</font> ');
			}

		});

		function getDogColorMarkByDogBreed(){
			var dogBreedCode = $("#dogBreed").val();
			$.post('${ctx}/dogcolormark/dogColorMark/getByDogBreed', {
				dogBreedCode: dogBreedCode
			}, function(data) {
				$('#dogFurColor').empty();
				$.each(data, function(i,val) {
					$('#dogFurColor').append("<option value ='"+val.dogColorMarkCode+"'>"+val.dogColorMarkCn+"</option>");
				});
			});
		}

		function getOrgByProvince(){
			var province = $("#province").val();
			$.post('${ctx}/sys/org/getOrgForPedigreeCertifiedChange', {
				province: province
			}, function(data) {
				$('#orgId').empty();
				$('#orgId').append("<option value =''>选择合作机构</option>");
				$.each(data, function(i,val) {
					$('#orgId').append("<option value ='"+val.id+"'>"+val.name+"</option>");
				});
				$("#orgId").trigger("change");
			});
		}

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange">证书换发列表</a></li>
		<li class="active"><a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/form?id=${dogPedigreeCertifiedChange.id}">证书换发<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit">${not empty dogPedigreeCertifiedChange.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogPedigreeCertifiedChange" action="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">国外血统证书号：</label>
			<div class="controls">
				<form:input path="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属协会：</label>
			<div class="controls">
				<form:select path="association" class="input-xlarge required">
					<form:options items="${associationList}" itemLabel="name" itemValue="code" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
				<form:select path="dogBreed" class="input-xlarge required" onchange="getDogColorMarkByDogBreed()">
					<form:options items="${dogTypeList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
				</form:select>
				<span id="errorDogBreed" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="128" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				<form:select id="dogFurColor" path="dogFurColor" class="input-xlarge required">
					<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="dogBirthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.dogBirthday}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只芯片号：</label>
			<div class="controls">
				<form:input path="dogChip" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">合作机构：</label>
			<div class="controls">
				<form:select path="province" class="input-medium" onchange="getOrgByProvince()">
					<form:option value="" label="选择地区"/>
					<form:options items="${provinceList}" itemLabel="name" itemValue="name" htmlEscape="false"/>
				</form:select>
				<form:select path="orgId" class="input-xlarge">
				</form:select>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬主姓名：</label>
            <div class="controls">
                <form:input path="dogOwnerName" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
            </div>
        </div>
		<div class="control-group">
            <label class="control-label">犬主会员号：</label>
            <div class="controls">
                <form:input path="paymentMemberCode" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge " disabled="true">
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
				<form:input path="reviewRemarks" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">付款的状态：</label>
			<div class="controls">
				<form:select path="paymentState" class="input-xlarge " disabled="true">
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>