<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>语言管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/contest/language/">语言列表</a></li>
		<shiro:hasPermission name="contest:language:edit"><li><a href="${ctx}/contest/language/form">语言添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="language" action="${ctx}/contest/language/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>编号：</label>
				<form:input path="languageNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>代码：</label>
				<form:input path="code" htmlEscape="false" maxlength="5" class="input-medium"/>
			</li>
			<li><label>名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>编号</th>
				<th>代码</th>
				<th>名称</th>
				<shiro:hasPermission name="contest:language:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="language">
			<tr>
				<td><a href="${ctx}/contest/language/form?id=${language.id}">
					${language.languageNo}
				</a></td>
				<td>
					${language.code}
				</td>
				<td>
					${language.name}
				</td>
				<shiro:hasPermission name="contest:language:edit"><td>
    				<a href="${ctx}/contest/language/form?id=${language.id}">修改</a>
					<a href="${ctx}/contest/language/delete?id=${language.id}" onclick="return confirmx('确认要删除该语言吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>